/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.content.Context;
import android.os.IBinder;
import android.os.RemoteException;
import com.google.android.gms.ads.VideoController;
import com.google.android.gms.ads.formats.MediaView;
import com.google.android.gms.ads.formats.NativeAd;
import com.google.android.gms.ads.formats.NativeCustomTemplateAd;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.ObjectWrapper;
import com.google.android.gms.internal.ads.zzaco;
import com.google.android.gms.internal.ads.zzacs;
import com.google.android.gms.internal.ads.zzacx;
import com.google.android.gms.internal.ads.zzado;
import com.google.android.gms.internal.ads.zzazw;
import com.google.android.gms.internal.ads.zzxl;
import java.util.List;
import java.util.WeakHashMap;

public final class zzadt
implements NativeCustomTemplateAd {
    private static WeakHashMap<IBinder, zzadt> zzczf = new WeakHashMap();
    private final zzado zzczg;
    private final MediaView zzczh;
    private final VideoController zzcgy = new VideoController();
    private NativeCustomTemplateAd.DisplayOpenMeasurement zzczi;

    @VisibleForTesting
    private zzadt(zzado zzado2) {
        this.zzczg = zzado2;
        Context context = null;
        try {
            context = (Context)ObjectWrapper.unwrap((IObjectWrapper)zzado2.zzse());
        }
        catch (RemoteException | NullPointerException throwable) {
            zzazw.zzc("", throwable);
        }
        MediaView mediaView = null;
        if (context != null) {
            Object object = context;
            mediaView = new MediaView((Context)object);
            try {
                if (!this.zzczg.zzp(ObjectWrapper.wrap((Object)((Object)mediaView)))) {
                    mediaView = null;
                }
            }
            catch (RemoteException remoteException) {
                mediaView = null;
                object = remoteException;
                zzazw.zzc("", (Throwable)object);
            }
        }
        this.zzczh = mediaView;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static zzadt zza(zzado zzado2) {
        WeakHashMap<IBinder, zzadt> weakHashMap = zzczf;
        synchronized (weakHashMap) {
            zzadt zzadt2 = zzczf.get(zzado2.asBinder());
            if (zzadt2 != null) {
                return zzadt2;
            }
            zzadt2 = new zzadt(zzado2);
            zzczf.put(zzado2.asBinder(), zzadt2);
            return zzadt2;
        }
    }

    public final zzado zzsi() {
        return this.zzczg;
    }

    @Override
    public final CharSequence getText(String string) {
        try {
            return this.zzczg.zzcv(string);
        }
        catch (RemoteException remoteException) {
            zzazw.zzc("", remoteException);
            return null;
        }
    }

    @Override
    public final NativeAd.Image getImage(String string) {
        try {
            zzacs zzacs2 = this.zzczg.zzcw(string);
            if (zzacs2 != null) {
                return new zzacx(zzacs2);
            }
        }
        catch (RemoteException remoteException) {
            zzazw.zzc("", remoteException);
        }
        return null;
    }

    @Override
    public final VideoController getVideoController() {
        try {
            zzxl zzxl2 = this.zzczg.getVideoController();
            if (zzxl2 != null) {
                this.zzcgy.zza(zzxl2);
            }
        }
        catch (RemoteException remoteException) {
            zzazw.zzc("Exception occurred while getting video controller", remoteException);
        }
        return this.zzcgy;
    }

    @Override
    public final MediaView getVideoMediaView() {
        return this.zzczh;
    }

    @Override
    public final List<String> getAvailableAssetNames() {
        try {
            return this.zzczg.getAvailableAssetNames();
        }
        catch (RemoteException remoteException) {
            zzazw.zzc("", remoteException);
            return null;
        }
    }

    @Override
    public final String getCustomTemplateId() {
        try {
            return this.zzczg.getCustomTemplateId();
        }
        catch (RemoteException remoteException) {
            zzazw.zzc("", remoteException);
            return null;
        }
    }

    @Override
    public final void performClick(String string) {
        try {
            this.zzczg.performClick(string);
            return;
        }
        catch (RemoteException remoteException) {
            zzazw.zzc("", remoteException);
            return;
        }
    }

    @Override
    public final void recordImpression() {
        try {
            this.zzczg.recordImpression();
            return;
        }
        catch (RemoteException remoteException) {
            zzazw.zzc("", remoteException);
            return;
        }
    }

    @Override
    public final NativeCustomTemplateAd.DisplayOpenMeasurement getDisplayOpenMeasurement() {
        try {
            if (this.zzczi == null && this.zzczg.zzsf()) {
                this.zzczi = new zzaco(this.zzczg);
            }
        }
        catch (RemoteException remoteException) {
            zzazw.zzc("", remoteException);
        }
        return this.zzczi;
    }

    @Override
    public final void destroy() {
        try {
            this.zzczg.destroy();
            return;
        }
        catch (RemoteException remoteException) {
            zzazw.zzc("", remoteException);
            return;
        }
    }
}

