/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.os.RemoteException;
import androidx.annotation.Nullable;
import com.google.ads.mediation.admob.AdMobAdapter;
import com.google.android.gms.ads.VideoController;
import com.google.android.gms.ads.formats.NativeCustomTemplateAd;
import com.google.android.gms.ads.mediation.MediationBannerAdapter;
import com.google.android.gms.ads.mediation.MediationBannerListener;
import com.google.android.gms.ads.mediation.MediationInterstitialAdapter;
import com.google.android.gms.ads.mediation.MediationInterstitialListener;
import com.google.android.gms.ads.mediation.MediationNativeAdapter;
import com.google.android.gms.ads.mediation.MediationNativeListener;
import com.google.android.gms.ads.mediation.NativeAdMapper;
import com.google.android.gms.ads.mediation.UnifiedNativeAdMapper;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.ads.zzadt;
import com.google.android.gms.internal.ads.zzalv;
import com.google.android.gms.internal.ads.zzamj;
import com.google.android.gms.internal.ads.zzazw;

public final class zzamm
implements MediationBannerListener,
MediationInterstitialListener,
MediationNativeListener {
    private final zzalv zzdgu;
    private NativeAdMapper zzdgv;
    private UnifiedNativeAdMapper zzdgw;
    private NativeCustomTemplateAd zzdgx;

    public zzamm(zzalv zzalv2) {
        this.zzdgu = zzalv2;
    }

    @Override
    public final void zza(MediationBannerAdapter mediationBannerAdapter, String string, String string2) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzazw.zzed("Adapter called onAppEvent.");
        try {
            this.zzdgu.onAppEvent(string, string2);
            return;
        }
        catch (RemoteException remoteException) {
            zzazw.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    @Override
    public final void onAdClicked(MediationBannerAdapter mediationBannerAdapter) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzazw.zzed("Adapter called onAdClicked.");
        try {
            this.zzdgu.onAdClicked();
            return;
        }
        catch (RemoteException remoteException) {
            zzazw.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    @Override
    public final void onAdClosed(MediationBannerAdapter mediationBannerAdapter) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzazw.zzed("Adapter called onAdClosed.");
        try {
            this.zzdgu.onAdClosed();
            return;
        }
        catch (RemoteException remoteException) {
            zzazw.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    @Override
    public final void onAdFailedToLoad(MediationBannerAdapter mediationBannerAdapter, int n) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzazw.zzed(new StringBuilder(55).append("Adapter called onAdFailedToLoad with error. ").append(n).toString());
        try {
            this.zzdgu.onAdFailedToLoad(n);
            return;
        }
        catch (RemoteException remoteException) {
            zzazw.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    @Override
    public final void onAdLeftApplication(MediationBannerAdapter mediationBannerAdapter) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzazw.zzed("Adapter called onAdLeftApplication.");
        try {
            this.zzdgu.onAdLeftApplication();
            return;
        }
        catch (RemoteException remoteException) {
            zzazw.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    @Override
    public final void onAdOpened(MediationBannerAdapter mediationBannerAdapter) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzazw.zzed("Adapter called onAdOpened.");
        try {
            this.zzdgu.onAdOpened();
            return;
        }
        catch (RemoteException remoteException) {
            zzazw.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    @Override
    public final void onAdLoaded(MediationBannerAdapter mediationBannerAdapter) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzazw.zzed("Adapter called onAdLoaded.");
        try {
            this.zzdgu.onAdLoaded();
            return;
        }
        catch (RemoteException remoteException) {
            zzazw.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    @Override
    public final void onAdClicked(MediationInterstitialAdapter mediationInterstitialAdapter) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzazw.zzed("Adapter called onAdClicked.");
        try {
            this.zzdgu.onAdClicked();
            return;
        }
        catch (RemoteException remoteException) {
            zzazw.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    @Override
    public final void onAdClosed(MediationInterstitialAdapter mediationInterstitialAdapter) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzazw.zzed("Adapter called onAdClosed.");
        try {
            this.zzdgu.onAdClosed();
            return;
        }
        catch (RemoteException remoteException) {
            zzazw.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    @Override
    public final void onAdFailedToLoad(MediationInterstitialAdapter mediationInterstitialAdapter, int n) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzazw.zzed(new StringBuilder(55).append("Adapter called onAdFailedToLoad with error ").append(n).append(".").toString());
        try {
            this.zzdgu.onAdFailedToLoad(n);
            return;
        }
        catch (RemoteException remoteException) {
            zzazw.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    @Override
    public final void onAdLeftApplication(MediationInterstitialAdapter mediationInterstitialAdapter) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzazw.zzed("Adapter called onAdLeftApplication.");
        try {
            this.zzdgu.onAdLeftApplication();
            return;
        }
        catch (RemoteException remoteException) {
            zzazw.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    @Override
    public final void onAdOpened(MediationInterstitialAdapter mediationInterstitialAdapter) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzazw.zzed("Adapter called onAdOpened.");
        try {
            this.zzdgu.onAdOpened();
            return;
        }
        catch (RemoteException remoteException) {
            zzazw.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    @Override
    public final void onAdLoaded(MediationInterstitialAdapter mediationInterstitialAdapter) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzazw.zzed("Adapter called onAdLoaded.");
        try {
            this.zzdgu.onAdLoaded();
            return;
        }
        catch (RemoteException remoteException) {
            zzazw.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    @Override
    public final void onAdLoaded(MediationNativeAdapter mediationNativeAdapter, NativeAdMapper nativeAdMapper) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzazw.zzed("Adapter called onAdLoaded.");
        this.zzdgv = nativeAdMapper;
        this.zzdgw = null;
        zzamm.zza(mediationNativeAdapter, this.zzdgw, this.zzdgv);
        try {
            this.zzdgu.onAdLoaded();
            return;
        }
        catch (RemoteException remoteException) {
            zzazw.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    @Override
    public final void onAdLoaded(MediationNativeAdapter mediationNativeAdapter, UnifiedNativeAdMapper unifiedNativeAdMapper) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzazw.zzed("Adapter called onAdLoaded.");
        this.zzdgw = unifiedNativeAdMapper;
        this.zzdgv = null;
        zzamm.zza(mediationNativeAdapter, this.zzdgw, this.zzdgv);
        try {
            this.zzdgu.onAdLoaded();
            return;
        }
        catch (RemoteException remoteException) {
            zzazw.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    private static void zza(MediationNativeAdapter mediationNativeAdapter, @Nullable UnifiedNativeAdMapper unifiedNativeAdMapper, @Nullable NativeAdMapper nativeAdMapper) {
        if (mediationNativeAdapter instanceof AdMobAdapter) {
            return;
        }
        VideoController videoController = new VideoController();
        videoController.zza(new zzamj());
        if (unifiedNativeAdMapper != null && unifiedNativeAdMapper.hasVideoContent()) {
            unifiedNativeAdMapper.zza(videoController);
        }
        if (nativeAdMapper != null && nativeAdMapper.hasVideoContent()) {
            nativeAdMapper.zza(videoController);
        }
    }

    @Override
    public final void zza(MediationNativeAdapter mediationNativeAdapter, NativeCustomTemplateAd nativeCustomTemplateAd) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        String string = String.valueOf(nativeCustomTemplateAd.getCustomTemplateId());
        zzazw.zzed(string.length() != 0 ? "Adapter called onAdLoaded with template id ".concat(string) : new String("Adapter called onAdLoaded with template id "));
        this.zzdgx = nativeCustomTemplateAd;
        try {
            this.zzdgu.onAdLoaded();
            return;
        }
        catch (RemoteException remoteException) {
            zzazw.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    @Override
    public final void zza(MediationNativeAdapter mediationNativeAdapter, NativeCustomTemplateAd nativeCustomTemplateAd, String string) {
        if (nativeCustomTemplateAd instanceof zzadt) {
            try {
                this.zzdgu.zza(((zzadt)nativeCustomTemplateAd).zzsi(), string);
                return;
            }
            catch (RemoteException remoteException) {
                zzazw.zze("#007 Could not call remote method.", remoteException);
                return;
            }
        }
        zzazw.zzfc("Unexpected native custom template ad type.");
    }

    @Override
    public final void onAdFailedToLoad(MediationNativeAdapter mediationNativeAdapter, int n) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzazw.zzed(new StringBuilder(55).append("Adapter called onAdFailedToLoad with error ").append(n).append(".").toString());
        try {
            this.zzdgu.onAdFailedToLoad(n);
            return;
        }
        catch (RemoteException remoteException) {
            zzazw.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    @Override
    public final void onAdOpened(MediationNativeAdapter mediationNativeAdapter) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzazw.zzed("Adapter called onAdOpened.");
        try {
            this.zzdgu.onAdOpened();
            return;
        }
        catch (RemoteException remoteException) {
            zzazw.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    @Override
    public final void onAdClosed(MediationNativeAdapter mediationNativeAdapter) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzazw.zzed("Adapter called onAdClosed.");
        try {
            this.zzdgu.onAdClosed();
            return;
        }
        catch (RemoteException remoteException) {
            zzazw.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    @Override
    public final void onAdLeftApplication(MediationNativeAdapter mediationNativeAdapter) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzazw.zzed("Adapter called onAdLeftApplication.");
        try {
            this.zzdgu.onAdLeftApplication();
            return;
        }
        catch (RemoteException remoteException) {
            zzazw.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    @Override
    public final void onAdClicked(MediationNativeAdapter mediationNativeAdapter) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        NativeAdMapper nativeAdMapper = this.zzdgv;
        UnifiedNativeAdMapper unifiedNativeAdMapper = this.zzdgw;
        if (this.zzdgx == null) {
            if (nativeAdMapper == null && unifiedNativeAdMapper == null) {
                zzazw.zze("#007 Could not call remote method.", null);
                return;
            }
            if (unifiedNativeAdMapper != null && !unifiedNativeAdMapper.getOverrideClickHandling()) {
                zzazw.zzed("Could not call onAdClicked since setOverrideClickHandling is not set to true");
                return;
            }
            if (nativeAdMapper != null && !nativeAdMapper.getOverrideClickHandling()) {
                zzazw.zzed("Could not call onAdClicked since setOverrideClickHandling is not set to true");
                return;
            }
        }
        zzazw.zzed("Adapter called onAdClicked.");
        try {
            this.zzdgu.onAdClicked();
            return;
        }
        catch (RemoteException remoteException) {
            zzazw.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    @Override
    public final void onAdImpression(MediationNativeAdapter mediationNativeAdapter) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        NativeAdMapper nativeAdMapper = this.zzdgv;
        UnifiedNativeAdMapper unifiedNativeAdMapper = this.zzdgw;
        if (this.zzdgx == null) {
            if (nativeAdMapper == null && unifiedNativeAdMapper == null) {
                zzazw.zze("#007 Could not call remote method.", null);
                return;
            }
            if (unifiedNativeAdMapper != null && !unifiedNativeAdMapper.getOverrideImpressionRecording()) {
                zzazw.zzed("Could not call onAdImpression since setOverrideImpressionRecording is not set to true");
                return;
            }
            if (nativeAdMapper != null && !nativeAdMapper.getOverrideImpressionRecording()) {
                zzazw.zzed("Could not call onAdImpression since setOverrideImpressionRecording is not set to true");
                return;
            }
        }
        zzazw.zzed("Adapter called onAdImpression.");
        try {
            this.zzdgu.onAdImpression();
            return;
        }
        catch (RemoteException remoteException) {
            zzazw.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    @Override
    public final void onVideoEnd(MediationNativeAdapter mediationNativeAdapter) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzazw.zzed("Adapter called onVideoEnd.");
        try {
            this.zzdgu.onVideoEnd();
            return;
        }
        catch (RemoteException remoteException) {
            zzazw.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    public final NativeAdMapper zztt() {
        return this.zzdgv;
    }

    public final UnifiedNativeAdMapper zztu() {
        return this.zzdgw;
    }

    public final NativeCustomTemplateAd zztv() {
        return this.zzdgx;
    }
}

