/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.net.Uri;
import android.os.RemoteException;
import android.view.MotionEvent;
import android.view.View;
import androidx.annotation.Nullable;
import com.google.android.gms.ads.query.UpdateClickUrlCallback;
import com.google.android.gms.ads.query.UpdateImpressionUrlsCallback;
import com.google.android.gms.dynamic.ObjectWrapper;
import com.google.android.gms.internal.ads.zzaqc;
import com.google.android.gms.internal.ads.zzaqf;
import com.google.android.gms.internal.ads.zzaqg;
import com.google.android.gms.internal.ads.zzaqh;
import com.google.android.gms.internal.ads.zzaqi;
import com.google.android.gms.internal.ads.zzavn;
import com.google.android.gms.internal.ads.zzazw;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;

public final class zzaqd {
    @Nonnull
    private final View zzaae;
    @Nullable
    private final Map<String, WeakReference<View>> zzdli;
    @Nullable
    private final zzavn zzdlj;

    public zzaqd(zzaqi zzaqi2) {
        this.zzaae = zzaqi.zza(zzaqi2);
        this.zzdli = zzaqi.zzb(zzaqi2);
        this.zzdlj = zzaqc.zzr(zzaqi.zza(zzaqi2).getContext());
        zzaqd zzaqd2 = this;
        if (zzaqd2.zzdlj == null || zzaqd2.zzdli == null || zzaqd2.zzdli.isEmpty()) {
            return;
        }
        try {
            zzaqd2.zzdlj.zza(new zzaqh(ObjectWrapper.wrap((Object)zzaqd2.zzaae).asBinder(), ObjectWrapper.wrap(zzaqd2.zzdli).asBinder()));
            return;
        }
        catch (RemoteException remoteException) {
            zzazw.zzfa("Failed to call remote method.");
            return;
        }
    }

    public final void updateImpressionUrls(List<Uri> list, UpdateImpressionUrlsCallback updateImpressionUrlsCallback) {
        if (this.zzdlj == null) {
            updateImpressionUrlsCallback.onFailure("Failed to get internal reporting info generator.");
        }
        try {
            this.zzdlj.zza(list, ObjectWrapper.wrap((Object)this.zzaae), new zzaqg(this, updateImpressionUrlsCallback));
            return;
        }
        catch (RemoteException remoteException) {
            String string = String.valueOf((Object)remoteException);
            updateImpressionUrlsCallback.onFailure(new StringBuilder(16 + String.valueOf(string).length()).append("Internal error: ").append(string).toString());
            return;
        }
    }

    public final void updateClickUrl(Uri uri, UpdateClickUrlCallback updateClickUrlCallback) {
        if (this.zzdlj == null) {
            updateClickUrlCallback.onFailure("Failed to get internal reporting info generator.");
        }
        try {
            this.zzdlj.zzb(new ArrayList<Uri>(Arrays.asList(uri)), ObjectWrapper.wrap((Object)this.zzaae), new zzaqf(this, updateClickUrlCallback));
            return;
        }
        catch (RemoteException remoteException) {
            String string = String.valueOf((Object)remoteException);
            updateClickUrlCallback.onFailure(new StringBuilder(16 + String.valueOf(string).length()).append("Internal error: ").append(string).toString());
            return;
        }
    }

    public final void reportTouchEvent(MotionEvent motionEvent) {
        if (this.zzdlj == null) {
            zzazw.zzfa("Failed to get internal reporting info generator.");
            return;
        }
        try {
            this.zzdlj.zzan(ObjectWrapper.wrap((Object)motionEvent));
            return;
        }
        catch (RemoteException remoteException) {
            zzazw.zzfa("Failed to call remote method.");
            return;
        }
    }
}

