/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.content.Context;
import android.net.Uri;
import android.os.Build;
import android.os.Looper;
import android.text.TextUtils;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.internal.ads.zzabt;
import com.google.android.gms.internal.ads.zzaql;
import com.google.android.gms.internal.ads.zzaqn;
import com.google.android.gms.internal.ads.zzaqo;
import com.google.android.gms.internal.ads.zzaqp;
import com.google.android.gms.internal.ads.zzaqq;
import com.google.android.gms.internal.ads.zzazm;
import com.google.android.gms.internal.ads.zzazw;
import com.google.android.gms.internal.ads.zzazz;
import com.google.android.gms.internal.ads.zzbaa;
import com.google.android.gms.internal.ads.zzdno;
import com.google.android.gms.internal.ads.zzdnp;
import com.google.android.gms.internal.ads.zzdzz;
import com.google.android.gms.internal.ads.zzvj;
import com.google.android.gms.internal.ads.zzzz;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.WeakHashMap;
import java.util.concurrent.ExecutorService;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public final class zzaqm
implements zzaqq {
    private static final Object lock = new Object();
    @VisibleForTesting
    private static zzaqq zzdlo = null;
    @VisibleForTesting
    private static zzaqq zzdlp = null;
    private final Object zzdlq = new Object();
    private final Context zzciq;
    private final WeakHashMap<Thread, Boolean> zzdlr = new WeakHashMap();
    private final ExecutorService zzyj = zzdno.zzavn().zzed(zzdnp.zzhdn);
    private final zzazz zzdls;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static zzaqq zzs(Context context) {
        Object object = lock;
        synchronized (object) {
            if (zzdlo == null) {
                zzdlo = zzabt.zzcxr.get() != false ? new zzaqm(context) : new zzaqp();
            }
        }
        return zzdlo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static zzaqq zzc(Context context, zzazz zzazz2) {
        Object object = lock;
        synchronized (object) {
            if (zzdlp == null) {
                if (zzabt.zzcxr.get().booleanValue()) {
                    zzaqm zzaqm2 = new zzaqm(context, zzazz2);
                    Thread thread = Looper.getMainLooper().getThread();
                    zzaqm zzaqm3 = zzaqm2;
                    if (thread != null) {
                        Object object2 = zzaqm3.zzdlq;
                        synchronized (object2) {
                            zzaqm3.zzdlr.put(thread, true);
                        }
                        object2 = thread.getUncaughtExceptionHandler();
                        thread.setUncaughtExceptionHandler(new zzaqn(zzaqm3, (Thread.UncaughtExceptionHandler)object2));
                    }
                    zzaqm zzaqm4 = zzaqm2;
                    Thread.UncaughtExceptionHandler uncaughtExceptionHandler = Thread.getDefaultUncaughtExceptionHandler();
                    Thread.setDefaultUncaughtExceptionHandler(new zzaqo(zzaqm4, uncaughtExceptionHandler));
                    zzdlp = zzaqm2;
                } else {
                    zzdlp = new zzaqp();
                }
            }
        }
        return zzdlp;
    }

    private zzaqm(Context context) {
        this(context, zzazz.zzyi());
    }

    private zzaqm(Context context, zzazz zzazz2) {
        this.zzciq = context.getApplicationContext() != null ? context.getApplicationContext() : context;
        this.zzdls = zzazz2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected final void zza(Thread thread, Throwable throwable) {
        Throwable throwable2;
        zzaqm zzaqm2 = this;
        if (throwable2 == null) return;
        boolean bl = false;
        boolean bl2 = false;
        for (throwable2 = throwable; throwable2 != null; throwable2 = throwable2.getCause()) {
            for (StackTraceElement stackTraceElement : throwable2.getStackTrace()) {
                if (zzazm.zzew(stackTraceElement.getClassName())) {
                    bl = true;
                }
                if (!zzaqm2.getClass().getName().equals(stackTraceElement.getClassName())) continue;
                bl2 = true;
            }
        }
        if (!bl) return;
        if (bl2) return;
        boolean bl3 = true;
        if (!bl3) return;
        throwable2 = throwable;
        String string = "";
        Throwable throwable3 = throwable2;
        this.zza(throwable2, string, 1.0f);
    }

    @Override
    public final void zza(Throwable throwable, String string) {
        this.zza(throwable, string, 1.0f);
    }

    @Override
    public final void zza(Throwable throwable, String string, float f) {
        if (zzazm.zzc(throwable) == null) {
            return;
        }
        String string2 = throwable.getClass().getName();
        StringWriter stringWriter = new StringWriter();
        zzdzz.zza((Throwable)throwable, (PrintWriter)new PrintWriter(stringWriter));
        String string3 = stringWriter.toString();
        boolean bl = Math.random() < (double)f;
        int n = f > 0.0f ? (int)(1.0f / f) : 1;
        if (bl) {
            ArrayList<String> arrayList = new ArrayList<String>();
            int n2 = n;
            String string4 = string;
            String string5 = string3;
            Object object = string2;
            arrayList.add(this.zza((String)object, string5, string4, n2).toString());
            object = arrayList;
            zzaqm zzaqm2 = this;
            ArrayList arrayList2 = (ArrayList)object;
            int n3 = arrayList2.size();
            string5 = null;
            for (int i = 0; i < n3; ++i) {
                Object e = arrayList2.get(i);
                string4 = (String)e;
                zzbaa zzbaa2 = new zzbaa();
                zzaqm2.zzyj.execute(new zzaql(zzbaa2, string4));
            }
        }
    }

    @VisibleForTesting
    private final Uri.Builder zza(String string, String string2, String string3, int n) {
        boolean bl = false;
        try {
            bl = Wrappers.packageManager((Context)this.zzciq).isCallerInstantApp();
        }
        catch (Throwable throwable) {
            zzazw.zzc("Error fetching instant app info", throwable);
        }
        String string4 = "unknown";
        try {
            string4 = this.zzciq.getPackageName();
        }
        catch (Throwable throwable) {
            zzazw.zzfc("Cannot obtain package name, proceeding.");
        }
        String string5 = Build.MANUFACTURER;
        String string6 = Build.MODEL;
        return new Uri.Builder().scheme("https").path("//pagead2.googlesyndication.com/pagead/gen_204").appendQueryParameter("is_aia", Boolean.toString(bl)).appendQueryParameter("id", "gmob-apps-report-exception").appendQueryParameter("os", Build.VERSION.RELEASE).appendQueryParameter("api", String.valueOf(Build.VERSION.SDK_INT)).appendQueryParameter("device", string6.startsWith(string5) ? string6 : new StringBuilder(1 + String.valueOf(string5).length() + String.valueOf(string6).length()).append(string5).append(" ").append(string6).toString()).appendQueryParameter("js", this.zzdls.zzbnd).appendQueryParameter("appid", string4).appendQueryParameter("exceptiontype", string).appendQueryParameter("stacktrace", string2).appendQueryParameter("eids", TextUtils.join((CharSequence)",", zzzz.zzra())).appendQueryParameter("exceptionkey", string3).appendQueryParameter("cl", "305933803").appendQueryParameter("rc", "dev").appendQueryParameter("session_id", zzvj.zzpw()).appendQueryParameter("sampling_rate", Integer.toString(n)).appendQueryParameter("pb_tm", String.valueOf(zzabt.zzcxp.get()));
    }

    static final /* synthetic */ void zza(zzbaa zzbaa2, String string) {
        zzbaa2.zzeq(string);
    }
}

