/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.content.Context;
import android.os.RemoteException;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.Nullable;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.OnPaidEventListener;
import com.google.android.gms.ads.ResponseInfo;
import com.google.android.gms.ads.VideoController;
import com.google.android.gms.ads.VideoOptions;
import com.google.android.gms.ads.doubleclick.AppEventListener;
import com.google.android.gms.ads.doubleclick.OnCustomRenderedAdLoadedListener;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.ObjectWrapper;
import com.google.android.gms.internal.ads.zzaax;
import com.google.android.gms.internal.ads.zzalm;
import com.google.android.gms.internal.ads.zzazm;
import com.google.android.gms.internal.ads.zzazw;
import com.google.android.gms.internal.ads.zzua;
import com.google.android.gms.internal.ads.zzub;
import com.google.android.gms.internal.ads.zzuf;
import com.google.android.gms.internal.ads.zzuk;
import com.google.android.gms.internal.ads.zzum;
import com.google.android.gms.internal.ads.zzuq;
import com.google.android.gms.internal.ads.zzuu;
import com.google.android.gms.internal.ads.zzuv;
import com.google.android.gms.internal.ads.zzux;
import com.google.android.gms.internal.ads.zzvb;
import com.google.android.gms.internal.ads.zzvi;
import com.google.android.gms.internal.ads.zzvj;
import com.google.android.gms.internal.ads.zzvz;
import com.google.android.gms.internal.ads.zzxg;
import com.google.android.gms.internal.ads.zzxl;
import com.google.android.gms.internal.ads.zzxt;
import com.google.android.gms.internal.ads.zzxu;
import com.google.android.gms.internal.ads.zzyz;
import com.google.android.gms.internal.ads.zzze;
import java.util.concurrent.atomic.AtomicBoolean;

public final class zzxv {
    private final zzalm zzbse = new zzalm();
    private final zzuk zzaca;
    private final AtomicBoolean zzcgx;
    private final VideoController zzcgy = new VideoController();
    @VisibleForTesting
    private final zzvi zzcgz = new zzxu(this);
    private zzub zzceb;
    private AdListener zzcee;
    private AdSize[] zzcfn;
    private AppEventListener zzblk;
    private zzvz zzbsb;
    private OnCustomRenderedAdLoadedListener zzcha;
    private VideoOptions zzblb;
    private String zzbsc;
    private ViewGroup zzchb;
    private int zzchc;
    private boolean zzbli;
    @Nullable
    private OnPaidEventListener zzchd;

    public zzxv(ViewGroup viewGroup) {
        this(viewGroup, null, false, zzuk.zzcev, 0);
    }

    public zzxv(ViewGroup viewGroup, int n) {
        this(viewGroup, null, false, zzuk.zzcev, n);
    }

    public zzxv(ViewGroup viewGroup, AttributeSet attributeSet, boolean bl) {
        this(viewGroup, attributeSet, bl, zzuk.zzcev, 0);
    }

    public zzxv(ViewGroup viewGroup, AttributeSet attributeSet, boolean bl, int n) {
        this(viewGroup, attributeSet, false, zzuk.zzcev, n);
    }

    @VisibleForTesting
    private zzxv(ViewGroup viewGroup, AttributeSet attributeSet, boolean bl, zzuk zzuk2, zzvz zzvz2, int n) {
        this.zzchb = viewGroup;
        this.zzaca = zzuk2;
        this.zzbsb = null;
        this.zzcgx = new AtomicBoolean(false);
        this.zzchc = n;
        if (attributeSet != null) {
            Context context = viewGroup.getContext();
            try {
                zzuv zzuv2 = new zzuv(context, attributeSet);
                this.zzcfn = zzuv2.zzy(bl);
                this.zzbsc = zzuv2.getAdUnitId();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                zzvj.zzpr().zza(viewGroup, new zzum(context, AdSize.BANNER), illegalArgumentException.getMessage(), illegalArgumentException.getMessage());
                return;
            }
            if (viewGroup.isInEditMode()) {
                zzum zzum2;
                zzazm zzazm2 = zzvj.zzpr();
                int n2 = this.zzchc;
                AdSize adSize = this.zzcfn[0];
                Context context2 = context;
                if (adSize.equals(AdSize.INVALID)) {
                    zzum2 = zzum.zzpk();
                } else {
                    boolean bl2;
                    zzum zzum3 = new zzum(context2, adSize);
                    new zzum(context2, adSize).zzcez = bl2 = zzxv.zzcv(n2);
                    zzum2 = zzum3;
                }
                zzazm2.zza(viewGroup, zzum2, "Ads by Google");
            }
        }
    }

    @VisibleForTesting
    private zzxv(ViewGroup viewGroup, AttributeSet attributeSet, boolean bl, zzuk zzuk2, int n) {
        this(viewGroup, attributeSet, bl, zzuk2, null, n);
    }

    public final void destroy() {
        try {
            if (this.zzbsb != null) {
                this.zzbsb.destroy();
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzazw.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    public final AdListener getAdListener() {
        return this.zzcee;
    }

    public final AdSize getAdSize() {
        try {
            zzum zzum2;
            if (this.zzbsb != null && (zzum2 = this.zzbsb.zzkg()) != null) {
                return zzum2.zzpl();
            }
        }
        catch (RemoteException remoteException) {
            zzazw.zze("#007 Could not call remote method.", remoteException);
        }
        if (this.zzcfn != null) {
            return this.zzcfn[0];
        }
        return null;
    }

    public final AdSize[] getAdSizes() {
        return this.zzcfn;
    }

    public final String getAdUnitId() {
        if (this.zzbsc == null && this.zzbsb != null) {
            try {
                this.zzbsc = this.zzbsb.getAdUnitId();
            }
            catch (RemoteException remoteException) {
                zzazw.zze("#007 Could not call remote method.", remoteException);
            }
        }
        return this.zzbsc;
    }

    public final AppEventListener getAppEventListener() {
        return this.zzblk;
    }

    public final OnCustomRenderedAdLoadedListener getOnCustomRenderedAdLoadedListener() {
        return this.zzcha;
    }

    public final void zza(zzxt zzxt2) {
        try {
            if (this.zzbsb == null) {
                zzvz zzvz2;
                zzum zzum2;
                zzxv zzxv2 = this;
                if ((zzxv2.zzcfn == null || zzxv2.zzbsc == null) && zzxv2.zzbsb == null) {
                    throw new IllegalStateException("The ad size and ad unit ID must be set before loadAd is called.");
                }
                zzxv zzxv3 = zzxv2;
                Context context = zzxv3.zzchb.getContext();
                Object object = zzum2 = zzxv.zza(context, zzxv3.zzcfn, zzxv3.zzchc);
                if ("search_v2".equals(object.zzacf)) {
                    String string = zzxv3.zzbsc;
                    zzum zzum3 = zzum2;
                    Context context2 = context;
                    object = zzvj.zzps();
                    Context context3 = context2;
                    zzvz2 = (zzvz)new zzvb((zzuu)object, context2, zzum3, string).zzd(context3, false);
                } else {
                    zzalm zzalm2 = zzxv3.zzbse;
                    String string = zzxv3.zzbsc;
                    zzum zzum4 = zzum2;
                    Context context4 = context;
                    object = zzvj.zzps();
                    Context context5 = context4;
                    zzvz2 = (zzvz)new zzux((zzuu)object, context4, zzum4, string, zzalm2).zzd(context5, false);
                }
                zzxv2.zzbsb = zzvz2;
                zzxv2.zzbsb.zza(new zzuf(zzxv2.zzcgz));
                if (zzxv2.zzceb != null) {
                    zzxv2.zzbsb.zza(new zzua(zzxv2.zzceb));
                }
                if (zzxv2.zzblk != null) {
                    zzxv2.zzbsb.zza(new zzuq(zzxv2.zzblk));
                }
                if (zzxv2.zzcha != null) {
                    zzxv2.zzbsb.zza(new zzaax(zzxv2.zzcha));
                }
                if (zzxv2.zzblb != null) {
                    zzxv2.zzbsb.zza(new zzze(zzxv2.zzblb));
                }
                zzxv2.zzbsb.zza(new zzyz(zzxv2.zzchd));
                zzxv2.zzbsb.setManualImpressionsEnabled(zzxv2.zzbli);
                zzxv zzxv4 = zzxv2;
                try {
                    IObjectWrapper iObjectWrapper = zzxv4.zzbsb.zzke();
                    if (iObjectWrapper != null) {
                        zzxv4.zzchb.addView((View)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper));
                    }
                }
                catch (RemoteException remoteException) {
                    zzazw.zze("#007 Could not call remote method.", remoteException);
                }
            }
            if (this.zzbsb.zza(zzuk.zza(this.zzchb.getContext(), zzxt2))) {
                this.zzbse.zzf(zzxt2.zzqk());
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzazw.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    public final void pause() {
        try {
            if (this.zzbsb != null) {
                this.zzbsb.pause();
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzazw.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    public final void recordManualImpression() {
        if (this.zzcgx.getAndSet(true)) {
            return;
        }
        try {
            if (this.zzbsb != null) {
                this.zzbsb.zzkf();
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzazw.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    public final void resume() {
        try {
            if (this.zzbsb != null) {
                this.zzbsb.resume();
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzazw.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    public final void setAdListener(AdListener adListener) {
        this.zzcee = adListener;
        this.zzcgz.zza(adListener);
    }

    public final void zza(zzub zzub2) {
        try {
            this.zzceb = zzub2;
            if (this.zzbsb != null) {
                this.zzbsb.zza(zzub2 != null ? new zzua(zzub2) : null);
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzazw.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    public final void setAdSizes(AdSize ... adSizeArray) {
        if (this.zzcfn != null) {
            throw new IllegalStateException("The ad size can only be set once on AdView.");
        }
        this.zza(adSizeArray);
    }

    public final void zza(AdSize ... adSizeArray) {
        this.zzcfn = adSizeArray;
        try {
            if (this.zzbsb != null) {
                this.zzbsb.zza(zzxv.zza(this.zzchb.getContext(), this.zzcfn, this.zzchc));
            }
        }
        catch (RemoteException remoteException) {
            zzazw.zze("#007 Could not call remote method.", remoteException);
        }
        this.zzchb.requestLayout();
    }

    public final void setAdUnitId(String string) {
        if (this.zzbsc != null) {
            throw new IllegalStateException("The ad unit ID can only be set once on AdView.");
        }
        this.zzbsc = string;
    }

    public final void setAppEventListener(AppEventListener appEventListener) {
        try {
            this.zzblk = appEventListener;
            if (this.zzbsb != null) {
                this.zzbsb.zza(appEventListener != null ? new zzuq(appEventListener) : null);
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzazw.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    public final void setOnCustomRenderedAdLoadedListener(OnCustomRenderedAdLoadedListener onCustomRenderedAdLoadedListener) {
        this.zzcha = onCustomRenderedAdLoadedListener;
        try {
            if (this.zzbsb != null) {
                this.zzbsb.zza(onCustomRenderedAdLoadedListener != null ? new zzaax(onCustomRenderedAdLoadedListener) : null);
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzazw.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    public final void setManualImpressionsEnabled(boolean bl) {
        this.zzbli = bl;
        try {
            if (this.zzbsb != null) {
                this.zzbsb.setManualImpressionsEnabled(this.zzbli);
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzazw.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    public final String getMediationAdapterClassName() {
        try {
            if (this.zzbsb != null) {
                return this.zzbsb.zzkh();
            }
        }
        catch (RemoteException remoteException) {
            zzazw.zze("#007 Could not call remote method.", remoteException);
        }
        return null;
    }

    public final boolean isLoading() {
        try {
            if (this.zzbsb != null) {
                return this.zzbsb.isLoading();
            }
        }
        catch (RemoteException remoteException) {
            zzazw.zze("#007 Could not call remote method.", remoteException);
        }
        return false;
    }

    @Nullable
    public final ResponseInfo getResponseInfo() {
        zzxg zzxg2 = null;
        try {
            if (this.zzbsb != null) {
                zzxg2 = this.zzbsb.zzki();
            }
        }
        catch (RemoteException remoteException) {
            zzazw.zze("#007 Could not call remote method.", remoteException);
        }
        return ResponseInfo.zza(zzxg2);
    }

    public final void setOnPaidEventListener(@Nullable OnPaidEventListener onPaidEventListener) {
        try {
            this.zzchd = onPaidEventListener;
            if (this.zzbsb != null) {
                this.zzbsb.zza(new zzyz(onPaidEventListener));
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzazw.zze("#008 Must be called on the main UI thread.", remoteException);
            return;
        }
    }

    public final VideoController getVideoController() {
        return this.zzcgy;
    }

    public final zzxl zzdu() {
        if (this.zzbsb == null) {
            return null;
        }
        try {
            return this.zzbsb.getVideoController();
        }
        catch (RemoteException remoteException) {
            zzazw.zze("#007 Could not call remote method.", remoteException);
            return null;
        }
    }

    public final void setVideoOptions(VideoOptions videoOptions) {
        this.zzblb = videoOptions;
        try {
            if (this.zzbsb != null) {
                this.zzbsb.zza(videoOptions == null ? null : new zzze(videoOptions));
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzazw.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    public final VideoOptions getVideoOptions() {
        return this.zzblb;
    }

    public final boolean zza(zzvz zzvz2) {
        IObjectWrapper iObjectWrapper;
        if (zzvz2 == null) {
            return false;
        }
        try {
            iObjectWrapper = zzvz2.zzke();
        }
        catch (RemoteException remoteException) {
            zzazw.zze("#007 Could not call remote method.", remoteException);
            return false;
        }
        if (iObjectWrapper == null) {
            return false;
        }
        if (((View)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper)).getParent() != null) {
            return false;
        }
        this.zzchb.addView((View)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper));
        this.zzbsb = zzvz2;
        return true;
    }

    private static zzum zza(Context context, AdSize[] adSizeArray, int n) {
        boolean bl;
        Object object = adSizeArray;
        int n2 = adSizeArray.length;
        for (int i = 0; i < n2; ++i) {
            if (!object[i].equals(AdSize.INVALID)) continue;
            return zzum.zzpk();
        }
        object = new zzum(context, adSizeArray);
        new zzum(context, adSizeArray).zzcez = bl = zzxv.zzcv(n);
        return object;
    }

    private static boolean zzcv(int n) {
        return n == 1;
    }

    static /* synthetic */ VideoController zza(zzxv zzxv2) {
        return zzxv2.zzcgy;
    }
}

