/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.content.Context;
import android.os.RemoteException;
import androidx.annotation.NonNull;
import com.google.android.gms.ads.RequestConfiguration;
import com.google.android.gms.ads.initialization.AdapterStatus;
import com.google.android.gms.ads.initialization.InitializationStatus;
import com.google.android.gms.ads.initialization.OnInitializationCompleteListener;
import com.google.android.gms.ads.mediation.rtb.RtbAdapter;
import com.google.android.gms.ads.reward.RewardedVideoAd;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.dynamic.ObjectWrapper;
import com.google.android.gms.internal.ads.zzaha;
import com.google.android.gms.internal.ads.zzahi;
import com.google.android.gms.internal.ads.zzahl;
import com.google.android.gms.internal.ads.zzalh;
import com.google.android.gms.internal.ads.zzalm;
import com.google.android.gms.internal.ads.zzask;
import com.google.android.gms.internal.ads.zzasv;
import com.google.android.gms.internal.ads.zzazm;
import com.google.android.gms.internal.ads.zzazw;
import com.google.android.gms.internal.ads.zzdok;
import com.google.android.gms.internal.ads.zzuu;
import com.google.android.gms.internal.ads.zzvc;
import com.google.android.gms.internal.ads.zzvh;
import com.google.android.gms.internal.ads.zzvj;
import com.google.android.gms.internal.ads.zzwp;
import com.google.android.gms.internal.ads.zzxy;
import com.google.android.gms.internal.ads.zzxz;
import com.google.android.gms.internal.ads.zzyb;
import com.google.android.gms.internal.ads.zzyd;
import com.google.android.gms.internal.ads.zzyy;
import com.google.android.gms.internal.ads.zzzz;
import java.util.HashMap;
import java.util.List;
import javax.annotation.concurrent.GuardedBy;

public final class zzxw {
    @GuardedBy(value="lock")
    private static zzxw zzche;
    private static final Object lock;
    private zzwp zzchf;
    private RewardedVideoAd zzchg;
    @NonNull
    private RequestConfiguration zzchh = new RequestConfiguration.Builder().build();
    private InitializationStatus zzchi;

    private zzxw() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static zzxw zzqq() {
        Object object = lock;
        synchronized (object) {
            if (zzche == null) {
                zzche = new zzxw();
            }
            return zzche;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zza(Context context, String string, OnInitializationCompleteListener onInitializationCompleteListener) {
        Object object = lock;
        synchronized (object) {
            if (this.zzchf != null) {
                return;
            }
            if (context == null) {
                throw new IllegalArgumentException("Context cannot be null.");
            }
            try {
                zzalh.zzte().zzc(context, string);
                Context context2 = context;
                Object object2 = zzvj.zzps();
                Context context3 = context2;
                this.zzchf = (zzwp)new zzvc((zzuu)object2, context2).zzd(context3, false);
                if (onInitializationCompleteListener != null) {
                    this.zzchf.zza(new zzyd(this, onInitializationCompleteListener, null));
                }
                this.zzchf.zza(new zzalm());
                this.zzchf.initialize();
                this.zzchf.zza(string, ObjectWrapper.wrap((Object)new zzxz(this, context)));
                if (this.zzchh.getTagForChildDirectedTreatment() != -1 || this.zzchh.getTagForUnderAgeOfConsent() != -1) {
                    this.zza(this.zzchh);
                }
                zzzz.initialize(context);
                object2 = zzzz.zzcrg;
                if (!((Boolean)zzvj.zzpv().zzd(object2)).booleanValue() && !this.getVersionString().endsWith("0")) {
                    zzazw.zzfa("Google Mobile Ads SDK initialization functionality unavailable for this session. Ad requests can be made at any time.");
                    object2 = this;
                    this.zzchi = new zzyb((zzxw)object2);
                    if (onInitializationCompleteListener != null) {
                        zzazm.zzzn.post((Runnable)new zzxy(this, onInitializationCompleteListener));
                    }
                }
            }
            catch (RemoteException remoteException) {
                zzazw.zzd("MobileAdsSettingManager initialization failed", remoteException);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final RewardedVideoAd getRewardedVideoAdInstance(Context context) {
        Object object = lock;
        synchronized (object) {
            zzalm zzalm2;
            if (this.zzchg != null) {
                return this.zzchg;
            }
            zzalm zzalm3 = zzalm2 = new zzalm();
            Context context2 = context;
            zzuu zzuu2 = zzvj.zzps();
            Context context3 = context2;
            zzask zzask2 = (zzask)new zzvh(zzuu2, context2, zzalm3).zzd(context3, false);
            this.zzchg = new zzasv(context, zzask2);
            return this.zzchg;
        }
    }

    public final void setAppVolume(float f) {
        Preconditions.checkArgument((0.0f <= f && f <= 1.0f ? 1 : 0) != 0, (Object)"The app volume must be a value between 0 and 1 inclusive.");
        Preconditions.checkState((this.zzchf != null ? 1 : 0) != 0, (Object)"MobileAds.initialize() must be called prior to setting the app volume.");
        try {
            this.zzchf.setAppVolume(f);
            return;
        }
        catch (RemoteException remoteException) {
            zzazw.zzc("Unable to set app volume.", remoteException);
            return;
        }
    }

    public final float zzqb() {
        float f = 1.0f;
        if (this.zzchf == null) {
            return 1.0f;
        }
        try {
            f = this.zzchf.zzqb();
        }
        catch (RemoteException remoteException) {
            zzazw.zzc("Unable to get app volume.", remoteException);
        }
        return f;
    }

    public final void setAppMuted(boolean bl) {
        Preconditions.checkState((this.zzchf != null ? 1 : 0) != 0, (Object)"MobileAds.initialize() must be called prior to setting app muted state.");
        try {
            this.zzchf.setAppMuted(bl);
            return;
        }
        catch (RemoteException remoteException) {
            zzazw.zzc("Unable to set app mute state.", remoteException);
            return;
        }
    }

    public final boolean zzqc() {
        boolean bl = false;
        if (this.zzchf == null) {
            return false;
        }
        try {
            bl = this.zzchf.zzqc();
        }
        catch (RemoteException remoteException) {
            zzazw.zzc("Unable to get app mute state.", remoteException);
        }
        return bl;
    }

    public final void openDebugMenu(Context context, String string) {
        Preconditions.checkState((this.zzchf != null ? 1 : 0) != 0, (Object)"MobileAds.initialize() must be called prior to opening debug menu.");
        try {
            this.zzchf.zzb(ObjectWrapper.wrap((Object)context), string);
            return;
        }
        catch (RemoteException remoteException) {
            zzazw.zzc("Unable to open debug menu.", remoteException);
            return;
        }
    }

    public final String getVersionString() {
        Preconditions.checkState((this.zzchf != null ? 1 : 0) != 0, (Object)"MobileAds.initialize() must be called prior to getting version string.");
        try {
            return zzdok.zzhe(this.zzchf.getVersionString());
        }
        catch (RemoteException remoteException) {
            zzazw.zzc("Unable to get version string.", remoteException);
            return "";
        }
    }

    public final void registerRtbAdapter(Class<? extends RtbAdapter> clazz) {
        try {
            this.zzchf.zzcg(clazz.getCanonicalName());
            return;
        }
        catch (RemoteException remoteException) {
            zzazw.zzc("Unable to register RtbAdapter", remoteException);
            return;
        }
    }

    public final InitializationStatus getInitializationStatus() {
        Preconditions.checkState((this.zzchf != null ? 1 : 0) != 0, (Object)"MobileAds.initialize() must be called prior to getting initialization status.");
        try {
            if (this.zzchi != null) {
                return this.zzchi;
            }
            return zzxw.zzc(this.zzchf.zzqd());
        }
        catch (RemoteException remoteException) {
            zzazw.zzfa("Unable to get Initialization status.");
            return null;
        }
    }

    private static InitializationStatus zzc(List<zzaha> list) {
        HashMap<String, AdapterStatus> hashMap = new HashMap<String, AdapterStatus>();
        for (zzaha zzaha2 : list) {
            hashMap.put(zzaha2.zzdbg, new zzahi(zzaha2.zzdbh ? AdapterStatus.State.READY : AdapterStatus.State.NOT_READY, zzaha2.description, zzaha2.zzdbi));
        }
        return new zzahl(hashMap);
    }

    @NonNull
    public final RequestConfiguration getRequestConfiguration() {
        return this.zzchh;
    }

    public final void setRequestConfiguration(@NonNull RequestConfiguration requestConfiguration) {
        Preconditions.checkArgument((requestConfiguration != null ? 1 : 0) != 0, (Object)"Null passed to setRequestConfiguration.");
        RequestConfiguration requestConfiguration2 = this.zzchh;
        this.zzchh = requestConfiguration;
        if (this.zzchf == null) {
            return;
        }
        if (requestConfiguration2.getTagForChildDirectedTreatment() != requestConfiguration.getTagForChildDirectedTreatment() || requestConfiguration2.getTagForUnderAgeOfConsent() != requestConfiguration.getTagForUnderAgeOfConsent()) {
            this.zza(requestConfiguration);
        }
    }

    private final void zza(@NonNull RequestConfiguration requestConfiguration) {
        try {
            this.zzchf.zza(new zzyy(requestConfiguration));
            return;
        }
        catch (RemoteException remoteException) {
            zzazw.zzc("Unable to set request configuration parcel.", remoteException);
            return;
        }
    }

    final /* synthetic */ void zza(OnInitializationCompleteListener onInitializationCompleteListener) {
        onInitializationCompleteListener.onInitializationComplete(this.zzchi);
    }

    static /* synthetic */ InitializationStatus zza(zzxw zzxw2, List list) {
        return zzxw.zzc(list);
    }

    static {
        lock = new Object();
    }
}

