/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.content.Context;
import android.os.Bundle;
import android.os.RemoteException;
import androidx.annotation.Nullable;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.OnPaidEventListener;
import com.google.android.gms.ads.ResponseInfo;
import com.google.android.gms.ads.doubleclick.AppEventListener;
import com.google.android.gms.ads.doubleclick.OnCustomRenderedAdLoadedListener;
import com.google.android.gms.ads.doubleclick.PublisherInterstitialAd;
import com.google.android.gms.ads.reward.AdMetadataListener;
import com.google.android.gms.ads.reward.RewardedVideoAdListener;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.ads.zzaax;
import com.google.android.gms.internal.ads.zzalm;
import com.google.android.gms.internal.ads.zzasu;
import com.google.android.gms.internal.ads.zzazw;
import com.google.android.gms.internal.ads.zzua;
import com.google.android.gms.internal.ads.zzub;
import com.google.android.gms.internal.ads.zzuf;
import com.google.android.gms.internal.ads.zzug;
import com.google.android.gms.internal.ads.zzuk;
import com.google.android.gms.internal.ads.zzum;
import com.google.android.gms.internal.ads.zzuq;
import com.google.android.gms.internal.ads.zzuu;
import com.google.android.gms.internal.ads.zzva;
import com.google.android.gms.internal.ads.zzvj;
import com.google.android.gms.internal.ads.zzvz;
import com.google.android.gms.internal.ads.zzxg;
import com.google.android.gms.internal.ads.zzxt;
import com.google.android.gms.internal.ads.zzyz;

public final class zzxx {
    private final zzalm zzbse = new zzalm();
    private final Context zzvf;
    private final zzuk zzaca;
    private AdListener zzcee;
    private zzub zzceb;
    private zzvz zzbsb;
    private String zzbsc;
    private AdMetadataListener zzcef;
    private AppEventListener zzblk;
    private OnCustomRenderedAdLoadedListener zzcha;
    private RewardedVideoAdListener zzchj;
    private boolean zzchk;
    private boolean zzbmf;
    @Nullable
    private OnPaidEventListener zzchd;

    public zzxx(Context context) {
        this(context, zzuk.zzcev, null);
    }

    public zzxx(Context context, PublisherInterstitialAd publisherInterstitialAd) {
        this(context, zzuk.zzcev, publisherInterstitialAd);
    }

    @VisibleForTesting
    private zzxx(Context context, zzuk zzuk2, PublisherInterstitialAd publisherInterstitialAd) {
        this.zzvf = context;
        this.zzaca = zzuk2;
    }

    public final AdListener getAdListener() {
        return this.zzcee;
    }

    public final String getAdUnitId() {
        return this.zzbsc;
    }

    public final AppEventListener getAppEventListener() {
        return this.zzblk;
    }

    public final OnCustomRenderedAdLoadedListener getOnCustomRenderedAdLoadedListener() {
        return this.zzcha;
    }

    public final boolean isLoaded() {
        try {
            if (this.zzbsb == null) {
                return false;
            }
            return this.zzbsb.isReady();
        }
        catch (RemoteException remoteException) {
            zzazw.zze("#008 Must be called on the main UI thread.", remoteException);
            return false;
        }
    }

    public final boolean isLoading() {
        try {
            if (this.zzbsb == null) {
                return false;
            }
            return this.zzbsb.isLoading();
        }
        catch (RemoteException remoteException) {
            zzazw.zze("#008 Must be called on the main UI thread.", remoteException);
            return false;
        }
    }

    public final void zza(zzxt zzxt2) {
        try {
            if (this.zzbsb == null) {
                String string = "loadAd";
                zzxx zzxx2 = this;
                if (zzxx2.zzbsc == null) {
                    zzxx2.zzcp(string);
                }
                zzum zzum2 = zzxx2.zzchk ? zzum.zzpi() : new zzum();
                zzalm zzalm2 = zzxx2.zzbse;
                String string2 = zzxx2.zzbsc;
                zzum zzum3 = zzum2;
                Context context = zzxx2.zzvf;
                zzuu zzuu2 = zzvj.zzps();
                Context context2 = context;
                zzxx2.zzbsb = (zzvz)new zzva(zzuu2, context, zzum3, string2, zzalm2).zzd(context2, false);
                if (zzxx2.zzcee != null) {
                    zzxx2.zzbsb.zza(new zzuf(zzxx2.zzcee));
                }
                if (zzxx2.zzceb != null) {
                    zzxx2.zzbsb.zza(new zzua(zzxx2.zzceb));
                }
                if (zzxx2.zzcef != null) {
                    zzxx2.zzbsb.zza(new zzug(zzxx2.zzcef));
                }
                if (zzxx2.zzblk != null) {
                    zzxx2.zzbsb.zza(new zzuq(zzxx2.zzblk));
                }
                if (zzxx2.zzcha != null) {
                    zzxx2.zzbsb.zza(new zzaax(zzxx2.zzcha));
                }
                if (zzxx2.zzchj != null) {
                    zzxx2.zzbsb.zza(new zzasu(zzxx2.zzchj));
                }
                zzxx2.zzbsb.zza(new zzyz(zzxx2.zzchd));
                zzxx2.zzbsb.setImmersiveMode(zzxx2.zzbmf);
            }
            if (this.zzbsb.zza(zzuk.zza(this.zzvf, zzxt2))) {
                this.zzbse.zzf(zzxt2.zzqk());
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzazw.zze("#008 Must be called on the main UI thread.", remoteException);
            return;
        }
    }

    public final void setAdListener(AdListener adListener) {
        try {
            this.zzcee = adListener;
            if (this.zzbsb != null) {
                this.zzbsb.zza(adListener != null ? new zzuf(adListener) : null);
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzazw.zze("#008 Must be called on the main UI thread.", remoteException);
            return;
        }
    }

    public final void zza(zzub zzub2) {
        try {
            this.zzceb = zzub2;
            if (this.zzbsb != null) {
                this.zzbsb.zza(zzub2 != null ? new zzua(zzub2) : null);
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzazw.zze("#008 Must be called on the main UI thread.", remoteException);
            return;
        }
    }

    public final void setAdUnitId(String string) {
        if (this.zzbsc != null) {
            throw new IllegalStateException("The ad unit ID can only be set once on InterstitialAd.");
        }
        this.zzbsc = string;
    }

    public final void setAdMetadataListener(AdMetadataListener adMetadataListener) {
        try {
            this.zzcef = adMetadataListener;
            if (this.zzbsb != null) {
                this.zzbsb.zza(adMetadataListener != null ? new zzug(adMetadataListener) : null);
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzazw.zze("#008 Must be called on the main UI thread.", remoteException);
            return;
        }
    }

    public final Bundle getAdMetadata() {
        try {
            if (this.zzbsb != null) {
                return this.zzbsb.getAdMetadata();
            }
        }
        catch (RemoteException remoteException) {
            zzazw.zze("#008 Must be called on the main UI thread.", remoteException);
        }
        return new Bundle();
    }

    public final void setAppEventListener(AppEventListener appEventListener) {
        try {
            this.zzblk = appEventListener;
            if (this.zzbsb != null) {
                this.zzbsb.zza(appEventListener != null ? new zzuq(appEventListener) : null);
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzazw.zze("#008 Must be called on the main UI thread.", remoteException);
            return;
        }
    }

    public final void setOnCustomRenderedAdLoadedListener(OnCustomRenderedAdLoadedListener onCustomRenderedAdLoadedListener) {
        try {
            this.zzcha = onCustomRenderedAdLoadedListener;
            if (this.zzbsb != null) {
                this.zzbsb.zza(onCustomRenderedAdLoadedListener != null ? new zzaax(onCustomRenderedAdLoadedListener) : null);
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzazw.zze("#008 Must be called on the main UI thread.", remoteException);
            return;
        }
    }

    public final void setRewardedVideoAdListener(RewardedVideoAdListener rewardedVideoAdListener) {
        try {
            this.zzchj = rewardedVideoAdListener;
            if (this.zzbsb != null) {
                this.zzbsb.zza(rewardedVideoAdListener != null ? new zzasu(rewardedVideoAdListener) : null);
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzazw.zze("#008 Must be called on the main UI thread.", remoteException);
            return;
        }
    }

    public final void zzd(boolean bl) {
        this.zzchk = true;
    }

    public final String getMediationAdapterClassName() {
        try {
            if (this.zzbsb != null) {
                return this.zzbsb.zzkh();
            }
        }
        catch (RemoteException remoteException) {
            zzazw.zze("#008 Must be called on the main UI thread.", remoteException);
        }
        return null;
    }

    public final ResponseInfo getResponseInfo() {
        zzxg zzxg2 = null;
        try {
            if (this.zzbsb != null) {
                zzxg2 = this.zzbsb.zzki();
            }
        }
        catch (RemoteException remoteException) {
            zzazw.zze("#008 Must be called on the main UI thread.", remoteException);
        }
        return ResponseInfo.zza(zzxg2);
    }

    public final void show() {
        try {
            this.zzcp("show");
            this.zzbsb.showInterstitial();
            return;
        }
        catch (RemoteException remoteException) {
            zzazw.zze("#008 Must be called on the main UI thread.", remoteException);
            return;
        }
    }

    public final void setImmersiveMode(boolean bl) {
        try {
            this.zzbmf = bl;
            if (this.zzbsb != null) {
                this.zzbsb.setImmersiveMode(bl);
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzazw.zze("#008 Must be called on the main UI thread.", remoteException);
            return;
        }
    }

    public final void setOnPaidEventListener(@Nullable OnPaidEventListener onPaidEventListener) {
        try {
            this.zzchd = onPaidEventListener;
            if (this.zzbsb != null) {
                this.zzbsb.zza(new zzyz(onPaidEventListener));
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzazw.zze("#008 Must be called on the main UI thread.", remoteException);
            return;
        }
    }

    private final void zzcp(String string) {
        if (this.zzbsb == null) {
            throw new IllegalStateException(new StringBuilder(63 + String.valueOf(string).length()).append("The ad unit ID must be set on InterstitialAd before ").append(string).append(" is called.").toString());
        }
    }
}

