/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads;

import android.content.Context;
import android.os.RemoteException;
import androidx.annotation.RecentlyNonNull;
import androidx.annotation.RequiresPermission;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.VideoOptions;
import com.google.android.gms.ads.admanager.AdManagerAdRequest;
import com.google.android.gms.ads.formats.AdManagerAdViewOptions;
import com.google.android.gms.ads.formats.NativeCustomTemplateAd;
import com.google.android.gms.ads.formats.OnAdManagerAdViewLoadedListener;
import com.google.android.gms.ads.formats.UnifiedNativeAd;
import com.google.android.gms.ads.nativead.NativeAd;
import com.google.android.gms.ads.nativead.NativeAdOptions;
import com.google.android.gms.ads.nativead.NativeCustomFormatAd;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.ads.zzaam;
import com.google.android.gms.internal.ads.zzaap;
import com.google.android.gms.internal.ads.zzacp;
import com.google.android.gms.internal.ads.zzadg;
import com.google.android.gms.internal.ads.zzadx;
import com.google.android.gms.internal.ads.zzagx;
import com.google.android.gms.internal.ads.zzajj;
import com.google.android.gms.internal.ads.zzajl;
import com.google.android.gms.internal.ads.zzajm;
import com.google.android.gms.internal.ads.zzapt;
import com.google.android.gms.internal.ads.zzato;
import com.google.android.gms.internal.ads.zzatq;
import com.google.android.gms.internal.ads.zzbbf;
import com.google.android.gms.internal.ads.zzyo;
import com.google.android.gms.internal.ads.zzyw;
import com.google.android.gms.internal.ads.zzyx;
import com.google.android.gms.internal.ads.zzzw;
import com.google.android.gms.internal.ads.zzzy;

public class AdLoader {
    private final zzyw zza;
    private final Context zzb;
    private final zzaam zzc;

    @RequiresPermission(value="android.permission.INTERNET")
    public void loadAd(@RecentlyNonNull AdRequest adRequest) {
        this.zza(adRequest.zza());
    }

    public void loadAd(@RecentlyNonNull AdManagerAdRequest adManagerAdRequest) {
        this.zza(adManagerAdRequest.zza);
    }

    @RequiresPermission(value="android.permission.INTERNET")
    public void loadAds(@RecentlyNonNull AdRequest object, int n) {
        object = ((AdRequest)object).zza();
        try {
            this.zzc.zzi(this.zza.zza(this.zzb, (zzacp)object), n);
            return;
        }
        catch (RemoteException remoteException) {
            zzbbf.zzg("Failed to load ads.", remoteException);
            return;
        }
    }

    public boolean isLoading() {
        try {
            boolean bl = this.zzc.zzg();
            return bl;
        }
        catch (RemoteException remoteException) {
            zzbbf.zzj("Failed to check if ad is loading.", remoteException);
            return false;
        }
    }

    AdLoader(Context context, zzaam zzaam2, zzyw zzyw2) {
        this.zzb = context;
        this.zzc = zzaam2;
        this.zza = zzyw2;
    }

    private final void zza(zzacp zzacp2) {
        try {
            this.zzc.zze(this.zza.zza(this.zzb, zzacp2));
            return;
        }
        catch (RemoteException remoteException) {
            zzbbf.zzg("Failed to load ad.", remoteException);
            return;
        }
    }

    public static class Builder {
        private final Context zza;
        private final zzaap zzb;

        public Builder(@RecentlyNonNull Context object, @RecentlyNonNull String string) {
            Object object2 = Preconditions.checkNotNull((Object)object, (Object)"context cannot be null");
            object2 = (Context)object2;
            zzzw zzzw2 = zzzy.zzb();
            zzapt zzapt2 = new zzapt();
            object = zzzw2.zzc((Context)object, string, zzapt2);
            this.zza = object2;
            this.zzb = object;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Deprecated
        @RecentlyNonNull
        public Builder forUnifiedNativeAd(@RecentlyNonNull UnifiedNativeAd.OnUnifiedNativeAdLoadedListener onUnifiedNativeAdLoadedListener) {
            try {
                zzaap zzaap2 = this.zzb;
                zzajm zzajm2 = new zzajm(onUnifiedNativeAdLoadedListener);
                zzaap2.zzm(zzajm2);
                return this;
            }
            catch (RemoteException remoteException) {
                zzbbf.zzj("Failed to add google native ad listener", remoteException);
                return this;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @RecentlyNonNull
        public Builder forNativeAd(@RecentlyNonNull NativeAd.OnNativeAdLoadedListener onNativeAdLoadedListener) {
            try {
                zzaap zzaap2 = this.zzb;
                zzatq zzatq2 = new zzatq(onNativeAdLoadedListener);
                zzaap2.zzm(zzatq2);
                return this;
            }
            catch (RemoteException remoteException) {
                zzbbf.zzj("Failed to add google native ad listener", remoteException);
                return this;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Deprecated
        @RecentlyNonNull
        public Builder forCustomTemplateAd(@RecentlyNonNull String string, @RecentlyNonNull NativeCustomTemplateAd.OnCustomTemplateAdLoadedListener onCustomTemplateAdLoadedListener, @RecentlyNonNull NativeCustomTemplateAd.OnCustomClickListener onCustomClickListener) {
            zzajj zzajj2 = new zzajj(onCustomTemplateAdLoadedListener, onCustomClickListener);
            try {
                this.zzb.zzi(string, zzajj2.zza(), zzajj2.zzb());
                return this;
            }
            catch (RemoteException remoteException) {
                zzbbf.zzj("Failed to add custom template ad listener", remoteException);
                return this;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @RecentlyNonNull
        public Builder forCustomFormatAd(@RecentlyNonNull String string, @RecentlyNonNull NativeCustomFormatAd.OnCustomFormatAdLoadedListener onCustomFormatAdLoadedListener, @RecentlyNonNull NativeCustomFormatAd.OnCustomClickListener onCustomClickListener) {
            zzato zzato2 = new zzato(onCustomFormatAdLoadedListener, onCustomClickListener);
            try {
                this.zzb.zzi(string, zzato2.zza(), zzato2.zzb());
                return this;
            }
            catch (RemoteException remoteException) {
                zzbbf.zzj("Failed to add custom format ad listener", remoteException);
                return this;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @RecentlyNonNull
        public Builder forAdManagerAdView(@RecentlyNonNull OnAdManagerAdViewLoadedListener onAdManagerAdViewLoadedListener, AdSize ... object) {
            Object object2;
            if (object != null && ((Object)object).length > 0) {
                try {
                    zzyx zzyx2 = new zzyx(((Builder)object2).zza, (AdSize[])object);
                    object = ((Builder)object2).zzb;
                    zzajl zzajl2 = new zzajl(onAdManagerAdViewLoadedListener);
                    object.zzk(zzajl2, zzyx2);
                    return object2;
                }
                catch (RemoteException remoteException) {
                    zzbbf.zzj("Failed to add Google Ad Manager banner ad listener", remoteException);
                    return object2;
                }
            }
            object2 = new IllegalArgumentException("The supported ad sizes must contain at least one valid ad size.");
            throw object2;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @RecentlyNonNull
        public Builder withAdListener(@RecentlyNonNull AdListener adListener) {
            try {
                zzaap zzaap2 = this.zzb;
                zzyo zzyo2 = new zzyo(adListener);
                zzaap2.zzf(zzyo2);
                return this;
            }
            catch (RemoteException remoteException) {
                zzbbf.zzj("Failed to set AdListener.", remoteException);
                return this;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Deprecated
        @RecentlyNonNull
        public Builder withNativeAdOptions(@RecentlyNonNull com.google.android.gms.ads.formats.NativeAdOptions nativeAdOptions) {
            try {
                zzaap zzaap2 = this.zzb;
                zzagx zzagx2 = new zzagx(nativeAdOptions);
                zzaap2.zzj(zzagx2);
                return this;
            }
            catch (RemoteException remoteException) {
                zzbbf.zzj("Failed to specify native ad options", remoteException);
                return this;
            }
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @RecentlyNonNull
        public Builder withNativeAdOptions(@RecentlyNonNull NativeAdOptions nativeAdOptions) {
            try {
                void var2_10;
                zzaap zzaap2 = this.zzb;
                boolean bl = nativeAdOptions.shouldReturnUrlsForImageAssets();
                boolean bl2 = nativeAdOptions.shouldRequestMultipleImages();
                int n = nativeAdOptions.getAdChoicesPlacement();
                VideoOptions videoOptions = nativeAdOptions.getVideoOptions();
                if (videoOptions != null) {
                    zzadx zzadx2 = new zzadx(nativeAdOptions.getVideoOptions());
                } else {
                    Object var2_11 = null;
                }
                zzagx zzagx2 = new zzagx(4, bl, -1, bl2, n, (zzadx)var2_10, nativeAdOptions.zza(), nativeAdOptions.getMediaAspectRatio());
                zzaap2.zzj(zzagx2);
                return this;
            }
            catch (RemoteException remoteException) {
                zzbbf.zzj("Failed to specify native ad options", remoteException);
                return this;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @RecentlyNonNull
        public Builder withAdManagerAdViewOptions(@RecentlyNonNull AdManagerAdViewOptions adManagerAdViewOptions) {
            try {
                this.zzb.zzp(adManagerAdViewOptions);
                return this;
            }
            catch (RemoteException remoteException) {
                zzbbf.zzj("Failed to specify Ad Manager banner ad options", remoteException);
                return this;
            }
        }

        @RecentlyNonNull
        public AdLoader build() {
            try {
                Context context = this.zza;
                zzaam zzaam2 = this.zzb.zze();
                AdLoader adLoader = new AdLoader(context, zzaam2, zzyw.zza);
                return adLoader;
            }
            catch (RemoteException remoteException) {
                zzbbf.zzg("Failed to build AdLoader.", remoteException);
                zzadg zzadg2 = new zzadg();
                AdLoader adLoader = new AdLoader(this.zza, zzadg2.zzb(), zzyw.zza);
                return adLoader;
            }
        }
    }
}

