/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.Nullable;
import androidx.annotation.RecentlyNonNull;
import androidx.annotation.RecentlyNullable;
import androidx.annotation.RequiresPermission;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.OnPaidEventListener;
import com.google.android.gms.ads.ResponseInfo;
import com.google.android.gms.ads.admanager.AppEventListener;
import com.google.android.gms.internal.ads.zzacr;
import com.google.android.gms.internal.ads.zzbbf;
import com.google.android.gms.internal.ads.zzyi;
import org.checkerframework.checker.initialization.qual.NotOnlyInitialized;

public abstract class BaseAdView
extends ViewGroup {
    @NotOnlyInitialized
    protected final zzacr zza;

    protected BaseAdView(@RecentlyNonNull Context object, int n) {
        super(object);
        super(this, n);
        this.zza = object;
    }

    protected BaseAdView(@RecentlyNonNull Context object, @RecentlyNonNull AttributeSet attributeSet, int n) {
        super(object, attributeSet);
        super(this, attributeSet, false, n);
        this.zza = object;
    }

    protected BaseAdView(@RecentlyNonNull Context object, @RecentlyNonNull AttributeSet attributeSet, boolean bl) {
        super(object, attributeSet);
        super(this, attributeSet, bl);
        this.zza = object;
    }

    protected BaseAdView(@RecentlyNonNull Context object, @RecentlyNonNull AttributeSet attributeSet, int n, int n2) {
        super(object, attributeSet, n);
        super(this, attributeSet, false, n2);
        this.zza = object;
    }

    protected BaseAdView(@RecentlyNonNull Context object, @RecentlyNonNull AttributeSet attributeSet, int n, int n2, boolean bl) {
        super(object, attributeSet, n);
        super(this, attributeSet, bl, n2);
        this.zza = object;
    }

    public void destroy() {
        this.zza.zza();
    }

    @RecentlyNonNull
    public AdListener getAdListener() {
        return this.zza.zzb();
    }

    @RecentlyNullable
    public AdSize getAdSize() {
        return this.zza.zzc();
    }

    @RecentlyNonNull
    public String getAdUnitId() {
        return this.zza.zze();
    }

    @RequiresPermission(value="android.permission.INTERNET")
    public void loadAd(@RecentlyNonNull AdRequest adRequest) {
        this.zza.zzg(adRequest.zza());
    }

    public void pause() {
        this.zza.zzh();
    }

    public void resume() {
        this.zza.zzj();
    }

    public boolean isLoading() {
        return this.zza.zzr();
    }

    public void setAdListener(@RecentlyNonNull AdListener adListener) {
        this.zza.zzk(adListener);
        if (adListener == null) {
            this.zza.zzl(null);
            return;
        }
        if (adListener instanceof zzyi) {
            this.zza.zzl((zzyi)((Object)adListener));
        }
        if (adListener instanceof AppEventListener) {
            this.zza.zzp((AppEventListener)((Object)adListener));
            return;
        }
    }

    public void setAdSize(@RecentlyNonNull AdSize adSize) {
        zzacr zzacr2 = ((BaseAdView)((Object)zzacr2)).zza;
        AdSize[] adSizeArray = new AdSize[]{adSize};
        zzacr2.zzm(adSizeArray);
    }

    public void setAdUnitId(@RecentlyNonNull String string) {
        this.zza.zzo(string);
    }

    /*
     * WARNING - void declaration
     */
    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        if ((this = this.getChildAt(0)) != null && this.getVisibility() != 8) {
            void var3_4;
            void var5_6;
            void var2_3;
            void var4_5;
            int n5 = this.getMeasuredWidth();
            int n6 = this.getMeasuredHeight();
            var2_3 = (var4_5 - var2_3 - n5) / 2;
            var3_4 = (var5_6 - var3_4 - n6) / 2;
            this.layout((int)var2_3, (int)var3_4, (int)(var2_3 + n5), (int)(var3_4 + n6));
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void onMeasure(int n, int n2) {
        int n3;
        int n4;
        int n5;
        Object object = this.getChildAt(0);
        if (object != null && object.getVisibility() != 8) {
            this.measureChild((View)object, n, n2);
            n5 = object.getMeasuredWidth();
            n4 = object.getMeasuredHeight();
            n3 = n5;
            n5 = n4;
        } else {
            try {
                object = this.getAdSize();
            }
            catch (NullPointerException nullPointerException) {
                zzbbf.zzg("Unable to retrieve ad size.", nullPointerException);
                object = null;
            }
            if (object != null) {
                Context context = this.getContext();
                n4 = ((AdSize)object).getWidthInPixels(context);
                n5 = ((AdSize)object).getHeightInPixels(context);
                n3 = n4;
            } else {
                n3 = 0;
                n5 = 0;
            }
        }
        n4 = this.getSuggestedMinimumWidth();
        n3 = Math.max(n3, n4);
        n4 = this.getSuggestedMinimumHeight();
        n5 = Math.max(n5, n4);
        this.setMeasuredDimension(View.resolveSize((int)n3, (int)n), View.resolveSize((int)n5, (int)n2));
    }

    @RecentlyNullable
    public ResponseInfo getResponseInfo() {
        return this.zza.zzs();
    }

    public void setOnPaidEventListener(@Nullable OnPaidEventListener onPaidEventListener) {
        this.zza.zzt(onPaidEventListener);
    }

    @RecentlyNullable
    public OnPaidEventListener getOnPaidEventListener() {
        return this.zza.zzu();
    }
}

