/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads;

import android.os.RemoteException;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RecentlyNonNull;
import androidx.annotation.RecentlyNullable;
import com.google.android.gms.ads.AdapterResponseInfo;
import com.google.android.gms.internal.ads.zzacf;
import com.google.android.gms.internal.ads.zzaep;
import com.google.android.gms.internal.ads.zzbbf;
import com.google.android.gms.internal.ads.zzzb;
import com.google.android.gms.internal.ads.zzzy;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class ResponseInfo {
    @Nullable
    private final zzacf zza;
    private final List<AdapterResponseInfo> zzb;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @RecentlyNullable
    public String getMediationAdapterClassName() {
        try {
            zzacf zzacf2 = ((ResponseInfo)((Object)zzacf2)).zza;
            if (zzacf2 == null) return null;
        }
        catch (RemoteException remoteException) {
            zzbbf.zzg("Could not forward getMediationAdapterClassName to ResponseInfo.", remoteException);
            return null;
        }
        return zzacf2.zze();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @RecentlyNullable
    public String getResponseId() {
        try {
            zzacf zzacf2 = ((ResponseInfo)((Object)zzacf2)).zza;
            if (zzacf2 == null) return null;
        }
        catch (RemoteException remoteException) {
            zzbbf.zzg("Could not forward getResponseId to ResponseInfo.", remoteException);
            return null;
        }
        return zzacf2.zzf();
    }

    @NonNull
    public List<AdapterResponseInfo> getAdapterResponses() {
        return this.zzb;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @RecentlyNonNull
    public String toString() {
        try {
            return ((ResponseInfo)this).zza().toString(2);
        }
        catch (JSONException jSONException) {
            return "Error forming toString output.";
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ResponseInfo(@Nullable zzacf object) {
        block4: {
            this.zza = object;
            object = new ArrayList();
            this.zzb = object;
            object = zzaep.zzft;
            if (((Boolean)zzzy.zze().zzb(object)).booleanValue() && (object = this.zza) != null) {
                try {
                    if ((object = object.zzg()) == null) break block4;
                    object = object.iterator();
                }
                catch (RemoteException remoteException) {
                    zzbbf.zzg("Could not forward getAdapterResponseInfo to ResponseInfo.", remoteException);
                    return;
                }
                while (object.hasNext()) {
                    AdapterResponseInfo adapterResponseInfo = AdapterResponseInfo.zza((zzzb)((Object)object.next()));
                    if (adapterResponseInfo == null) continue;
                    this.zzb.add(adapterResponseInfo);
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @RecentlyNonNull
    public final JSONObject zza() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        String string = ((ResponseInfo)((Object)iterator)).getResponseId();
        if (string == null) {
            jSONObject.put("Response ID", (Object)"null");
        } else {
            jSONObject.put("Response ID", (Object)string);
        }
        if ((string = ((ResponseInfo)((Object)iterator)).getMediationAdapterClassName()) == null) {
            jSONObject.put("Mediation Adapter Class Name", (Object)"null");
        } else {
            jSONObject.put("Mediation Adapter Class Name", (Object)string);
        }
        string = new JSONArray();
        Iterator<AdapterResponseInfo> iterator = ((ResponseInfo)((Object)iterator)).zzb.iterator();
        while (true) {
            if (!iterator.hasNext()) {
                jSONObject.put("Adapter Responses", (Object)string);
                return jSONObject;
            }
            string.put((Object)((AdapterResponseInfo)iterator.next()).zzb());
        }
    }

    @Nullable
    public static ResponseInfo zzb(@Nullable zzacf zzacf2) {
        if (zzacf2 != null) {
            ResponseInfo responseInfo = new ResponseInfo(zzacf2);
            return responseInfo;
        }
        return null;
    }

    @NonNull
    public static ResponseInfo zzc(@Nullable zzacf zzacf2) {
        ResponseInfo responseInfo = new ResponseInfo(zzacf2);
        return responseInfo;
    }
}

