/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.nativead;

import android.annotation.TargetApi;
import android.content.Context;
import android.os.RemoteException;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import androidx.annotation.Nullable;
import androidx.annotation.RecentlyNonNull;
import androidx.annotation.RecentlyNullable;
import com.google.android.gms.ads.MediaContent;
import com.google.android.gms.ads.nativead.AdChoicesView;
import com.google.android.gms.ads.nativead.MediaView;
import com.google.android.gms.ads.nativead.NativeAd;
import com.google.android.gms.ads.nativead.zzb;
import com.google.android.gms.ads.nativead.zzc;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.ObjectWrapper;
import com.google.android.gms.internal.ads.zzadb;
import com.google.android.gms.internal.ads.zzaep;
import com.google.android.gms.internal.ads.zzagu;
import com.google.android.gms.internal.ads.zzagw;
import com.google.android.gms.internal.ads.zzahn;
import com.google.android.gms.internal.ads.zzbbf;
import com.google.android.gms.internal.ads.zzzy;
import org.checkerframework.checker.initialization.qual.NotOnlyInitialized;
import org.checkerframework.checker.nullness.qual.RequiresNonNull;

public final class NativeAdView
extends FrameLayout {
    @NotOnlyInitialized
    private final FrameLayout zza;
    @NotOnlyInitialized
    @Nullable
    private final zzahn zzb;

    public NativeAdView(@RecentlyNonNull Context context) {
        super(context);
        this.zza = this.zze(context);
        this.zzb = this.zzf();
    }

    public NativeAdView(@RecentlyNonNull Context context, @RecentlyNonNull AttributeSet attributeSet) {
        super(context, attributeSet);
        this.zza = this.zze(context);
        this.zzb = this.zzf();
    }

    public NativeAdView(@RecentlyNonNull Context context, @RecentlyNonNull AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.zza = this.zze(context);
        this.zzb = this.zzf();
    }

    @TargetApi(value=21)
    public NativeAdView(@RecentlyNonNull Context context, @RecentlyNonNull AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet, n, n2);
        this.zza = this.zze(context);
        this.zzb = this.zzf();
    }

    public final void setHeadlineView(@Nullable View view) {
        this.zzd("3001", view);
    }

    public final void setCallToActionView(@Nullable View view) {
        this.zzd("3002", view);
    }

    public final void setIconView(@Nullable View view) {
        this.zzd("3003", view);
    }

    public final void setBodyView(@Nullable View view) {
        this.zzd("3004", view);
    }

    public final void setAdvertiserView(@Nullable View view) {
        this.zzd("3005", view);
    }

    public final void setStoreView(@Nullable View view) {
        this.zzd("3006", view);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void setClickConfirmingView(@Nullable View view) {
        zzahn zzahn2 = ((NativeAdView)((Object)zzahn2)).zzb;
        if (zzahn2 == null) return;
        try {
            zzahn2.zzg(ObjectWrapper.wrap((Object)view));
            return;
        }
        catch (RemoteException remoteException) {
            zzbbf.zzg("Unable to call setClickConfirmingView on delegate", remoteException);
            return;
        }
    }

    public final void setPriceView(@Nullable View view) {
        this.zzd("3007", view);
    }

    public final void setImageView(@Nullable View view) {
        this.zzd("3008", view);
    }

    public final void setStarRatingView(@Nullable View view) {
        this.zzd("3009", view);
    }

    public final void setMediaView(@Nullable MediaView mediaView) {
        this.zzd("3010", (View)mediaView);
        if (mediaView == null) {
            return;
        }
        Object object = new zzb(this);
        mediaView.zza((zzagu)object);
        object = new zzc(this);
        mediaView.zzb((zzagw)object);
    }

    public void setAdChoicesView(@Nullable AdChoicesView adChoicesView) {
        this.zzd("3011", (View)adChoicesView);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setNativeAd(@RecentlyNonNull NativeAd object) {
        zzahn zzahn2 = ((NativeAdView)((Object)zzahn2)).zzb;
        if (zzahn2 == null) return;
        try {
            object = ((NativeAd)object).zza();
            zzahn2.zzd((IObjectWrapper)object);
            return;
        }
        catch (RemoteException remoteException) {
            zzbbf.zzg("Unable to call setNativeAd on delegate", remoteException);
            return;
        }
    }

    @RecentlyNullable
    public final View getHeadlineView() {
        return this.zza("3001");
    }

    @RecentlyNullable
    public final View getCallToActionView() {
        return this.zza("3002");
    }

    @RecentlyNullable
    public final View getIconView() {
        return this.zza("3003");
    }

    @RecentlyNullable
    public final View getBodyView() {
        return this.zza("3004");
    }

    @RecentlyNullable
    public final View getStoreView() {
        return this.zza("3006");
    }

    @RecentlyNullable
    public final View getPriceView() {
        return this.zza("3007");
    }

    @RecentlyNullable
    public final View getAdvertiserView() {
        return this.zza("3005");
    }

    @RecentlyNullable
    public final View getImageView() {
        return this.zza("3008");
    }

    @RecentlyNullable
    public final View getStarRatingView() {
        return this.zza("3009");
    }

    @RecentlyNullable
    public final MediaView getMediaView() {
        if ((this = this.zza("3010")) instanceof MediaView) {
            return (MediaView)((Object)this);
        }
        if (this != null) {
            zzbbf.zzd("View is not an instance of MediaView");
        }
        return null;
    }

    @RecentlyNullable
    public AdChoicesView getAdChoicesView() {
        if ((this = this.zza("3011")) instanceof AdChoicesView) {
            return (AdChoicesView)((Object)this);
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void destroy() {
        zzahn zzahn2 = ((NativeAdView)((Object)zzahn2)).zzb;
        if (zzahn2 == null) return;
        try {
            zzahn2.zze();
            return;
        }
        catch (RemoteException remoteException) {
            zzbbf.zzg("Unable to destroy native ad view", remoteException);
            return;
        }
    }

    public final void addView(@RecentlyNonNull View view, int n, @RecentlyNonNull ViewGroup.LayoutParams layoutParams) {
        super.addView(view, n, layoutParams);
        super.bringChildToFront((View)this.zza);
    }

    public final void removeView(@RecentlyNonNull View view) {
        if (this.zza == view) {
            return;
        }
        super.removeView(view);
    }

    public final void removeAllViews() {
        super.removeAllViews();
        super.addView((View)this.zza);
    }

    public final void bringChildToFront(@RecentlyNonNull View view) {
        super.bringChildToFront(view);
        FrameLayout frameLayout = this.zza;
        if (frameLayout != view) {
            super.bringChildToFront((View)frameLayout);
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void onVisibilityChanged(@RecentlyNonNull View view, int n) {
        super.onVisibilityChanged(view, n);
        zzahn zzahn2 = ((NativeAdView)((Object)zzahn2)).zzb;
        if (zzahn2 == null) return;
        try {
            zzahn2.zzf(ObjectWrapper.wrap((Object)view), n);
            return;
        }
        catch (RemoteException remoteException) {
            zzbbf.zzg("Unable to call onVisibilityChanged on delegate", remoteException);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final boolean dispatchTouchEvent(@RecentlyNonNull MotionEvent motionEvent) {
        Object object = zzaep.zzbN;
        if (zzzy.zze().zzb(object) == false) return super.dispatchTouchEvent(motionEvent);
        object = this.zzb;
        if (object == null) return super.dispatchTouchEvent(motionEvent);
        try {
            object.zzbv(ObjectWrapper.wrap((Object)motionEvent));
            return super.dispatchTouchEvent(motionEvent);
        }
        catch (RemoteException remoteException) {
            zzbbf.zzg("Unable to call handleTouchEvent on delegate", remoteException);
            return super.dispatchTouchEvent(motionEvent);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void zzd(String string, @Nullable View view) {
        zzahn zzahn2 = ((NativeAdView)((Object)zzahn2)).zzb;
        if (zzahn2 == null) return;
        try {
            zzahn2.zzb(string, ObjectWrapper.wrap((Object)view));
            return;
        }
        catch (RemoteException remoteException) {
            zzbbf.zzg("Unable to call setAssetView on delegate", remoteException);
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @RecentlyNullable
    protected final View zza(@RecentlyNonNull String string) {
        Object object = ((NativeAdView)((Object)object)).zzb;
        if (object == null) return null;
        try {
            object = object.zzc(string);
            if (object == null) return null;
        }
        catch (RemoteException remoteException) {
            zzbbf.zzg("Unable to call getAssetView on delegate", remoteException);
            return null;
        }
        return (View)ObjectWrapper.unwrap((IObjectWrapper)object);
    }

    private final FrameLayout zze(Context context) {
        FrameLayout frameLayout = new FrameLayout(context);
        context = new FrameLayout.LayoutParams(-1, -1);
        frameLayout.setLayoutParams((ViewGroup.LayoutParams)context);
        this.addView((View)frameLayout);
        return frameLayout;
    }

    @RequiresNonNull(value={"overlayFrame"})
    @Nullable
    private final zzahn zzf() {
        if (this.isInEditMode()) {
            return null;
        }
        return zzzy.zzb().zzd(this.zza.getContext(), this, this.zza);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    final /* synthetic */ void zzb(ImageView.ScaleType scaleType) {
        zzahn zzahn2 = ((NativeAdView)((Object)zzahn2)).zzb;
        if (zzahn2 == null) {
            return;
        }
        if (scaleType == null) return;
        try {
            zzahn2.zzbu(ObjectWrapper.wrap((Object)scaleType));
            return;
        }
        catch (RemoteException remoteException) {
            zzbbf.zzg("Unable to call setMediaViewImageScaleType on delegate", remoteException);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final /* synthetic */ void zzc(MediaContent mediaContent) {
        zzahn zzahn2 = ((NativeAdView)((Object)zzahn2)).zzb;
        if (zzahn2 == null) {
            return;
        }
        try {
            boolean bl = mediaContent instanceof zzadb;
            if (bl) {
                zzahn2.zzbw(((zzadb)mediaContent).zza());
                return;
            }
            if (mediaContent == null) {
                zzahn2.zzbw(null);
                return;
            }
            zzbbf.zzd("Use MediaContent provided by NativeAd.getMediaContent");
            return;
        }
        catch (RemoteException remoteException) {
            zzbbf.zzg("Unable to call setMediaContent on delegate", remoteException);
            return;
        }
    }
}

