/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.nativead;

import android.os.RemoteException;
import android.view.View;
import androidx.annotation.RecentlyNonNull;
import com.google.android.gms.ads.nativead.NativeAd;
import com.google.android.gms.ads.nativead.NativeAdView;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.ObjectWrapper;
import com.google.android.gms.internal.ads.zzahr;
import com.google.android.gms.internal.ads.zzbbf;
import com.google.android.gms.internal.ads.zzzy;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.checkerframework.checker.initialization.qual.NotOnlyInitialized;

public final class NativeAdViewHolder {
    @NotOnlyInitialized
    private zzahr zzb;
    @RecentlyNonNull
    public static WeakHashMap<View, NativeAdViewHolder> zza;
    private WeakReference<View> zzc;

    public NativeAdViewHolder(@RecentlyNonNull View view, @RecentlyNonNull Map<String, View> map, @RecentlyNonNull Map<String, View> map2) {
        Preconditions.checkNotNull((Object)view, (Object)"ContainerView must not be null");
        if (view instanceof NativeAdView) {
            zzbbf.zzf("The provided containerView is of type of NativeAdView, which cannot be usedwith NativeAdViewHolder.");
            return;
        }
        if (zza.get(view) != null) {
            zzbbf.zzf("The provided containerView is already in use with another NativeAdViewHolder.");
            return;
        }
        zza.put(view, this);
        WeakReference<View> weakReference = new WeakReference<View>(view);
        this.zzc = weakReference;
        map = NativeAdViewHolder.zza(map);
        map2 = NativeAdViewHolder.zza(map2);
        this.zzb = zzzy.zzb().zze(view, (HashMap<String, View>)map, (HashMap<String, View>)map2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    public void setNativeAd(@RecentlyNonNull NativeAd object) {
        Object object2 = ((NativeAd)object).zza();
        object = ((NativeAdViewHolder)this).zzc;
        object = object != null ? (View)((Reference)object).get() : null;
        if (object == null) {
            zzbbf.zzi("NativeAdViewHolder.setNativeAd containerView doesn't exist, returning");
            return;
        }
        if (!zza.containsKey(object)) {
            zza.put((View)object, (NativeAdViewHolder)this);
        }
        if ((this = ((NativeAdViewHolder)this).zzb) == null) return;
        try {
            this.zzb((IObjectWrapper)object2);
            return;
        }
        catch (RemoteException remoteException) {
            zzbbf.zzg("Unable to call setNativeAd on delegate", remoteException);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void unregisterNativeAd() {
        zzahr zzahr2 = ((NativeAdViewHolder)object).zzb;
        if (zzahr2 != null) {
            try {
                zzahr2.zzc();
            }
            catch (RemoteException remoteException) {
                zzbbf.zzg("Unable to call unregisterNativeAd on delegate", remoteException);
            }
        }
        if ((object = ((NativeAdViewHolder)object).zzc) == null) return;
        Object object = (View)((Reference)object).get();
        if (object == null) return;
        zza.remove(object);
    }

    public final void setClickConfirmingView(@RecentlyNonNull View view) {
        try {
            zzahr zzahr2 = ((NativeAdViewHolder)((Object)zzahr2)).zzb;
            zzahr2.zzd(ObjectWrapper.wrap((Object)view));
            return;
        }
        catch (RemoteException remoteException) {
            zzbbf.zzg("Unable to call setClickConfirmingView on delegate", remoteException);
            return;
        }
    }

    static {
        WeakHashMap weakHashMap = new WeakHashMap();
        zza = weakHashMap;
    }

    private static final HashMap<String, View> zza(Map<String, View> hashMap) {
        if (hashMap == null) {
            hashMap = new HashMap<String, View>();
            return hashMap;
        }
        HashMap<String, View> hashMap2 = new HashMap<String, View>(hashMap);
        return hashMap2;
    }
}

