/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.query;

import androidx.annotation.RecentlyNonNull;
import com.google.android.gms.ads.query.QueryInfo;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.internal.ads.zzbbf;
import org.json.JSONException;
import org.json.JSONObject;

@KeepForSdk
public class AdInfo {
    private final QueryInfo zza;
    private final String zzb;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @KeepForSdk
    @RecentlyNonNull
    public static String getRequestId(@RecentlyNonNull String string) {
        if (string == null) {
            zzbbf.zzi("adString passed to AdInfo.getRequestId() cannot be null. Returning empty string.");
            return "";
        }
        try {
            JSONObject jSONObject = new JSONObject(string);
            return jSONObject.optString("request_id", "");
        }
        catch (JSONException jSONException) {
            zzbbf.zzi("Invalid adString passed to AdInfo.getRequestId(). Returning empty string.");
            return "";
        }
    }

    @KeepForSdk
    public AdInfo(@RecentlyNonNull QueryInfo queryInfo, @RecentlyNonNull String string) {
        this.zza = queryInfo;
        this.zzb = string;
    }

    @KeepForSdk
    @RecentlyNonNull
    public QueryInfo getQueryInfo() {
        return this.zza;
    }

    @KeepForSdk
    @RecentlyNonNull
    public String getAdString() {
        return this.zzb;
    }
}

