/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.rewarded;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RecentlyNonNull;
import androidx.annotation.RecentlyNullable;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.FullScreenContentCallback;
import com.google.android.gms.ads.OnPaidEventListener;
import com.google.android.gms.ads.OnUserEarnedRewardListener;
import com.google.android.gms.ads.ResponseInfo;
import com.google.android.gms.ads.admanager.AdManagerAdRequest;
import com.google.android.gms.ads.rewarded.OnAdMetadataChangedListener;
import com.google.android.gms.ads.rewarded.RewardItem;
import com.google.android.gms.ads.rewarded.RewardedAdLoadCallback;
import com.google.android.gms.ads.rewarded.ServerSideVerificationOptions;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.ads.zzaxp;

public abstract class RewardedAd {
    public static void load(@RecentlyNonNull Context context, @RecentlyNonNull String string, @RecentlyNonNull AdRequest adRequest, @RecentlyNonNull RewardedAdLoadCallback rewardedAdLoadCallback) {
        Preconditions.checkNotNull((Object)context, (Object)"Context cannot be null.");
        Preconditions.checkNotNull((Object)string, (Object)"AdUnitId cannot be null.");
        Preconditions.checkNotNull((Object)adRequest, (Object)"AdRequest cannot be null.");
        Preconditions.checkNotNull((Object)rewardedAdLoadCallback, (Object)"LoadCallback cannot be null.");
        zzaxp zzaxp2 = new zzaxp(context, string);
        zzaxp2.zza(adRequest.zza(), rewardedAdLoadCallback);
    }

    public static void load(@RecentlyNonNull Context context, @RecentlyNonNull String string, @RecentlyNonNull AdManagerAdRequest adManagerAdRequest, @RecentlyNonNull RewardedAdLoadCallback rewardedAdLoadCallback) {
        Preconditions.checkNotNull((Object)context, (Object)"Context cannot be null.");
        Preconditions.checkNotNull((Object)string, (Object)"AdUnitId cannot be null.");
        Preconditions.checkNotNull((Object)adManagerAdRequest, (Object)"AdManagerAdRequest cannot be null.");
        Preconditions.checkNotNull((Object)rewardedAdLoadCallback, (Object)"LoadCallback cannot be null.");
        zzaxp zzaxp2 = new zzaxp(context, string);
        zzaxp2.zza(((AdRequest)adManagerAdRequest).zza(), rewardedAdLoadCallback);
    }

    public abstract void setServerSideVerificationOptions(@Nullable ServerSideVerificationOptions var1);

    public abstract void setOnAdMetadataChangedListener(@Nullable OnAdMetadataChangedListener var1);

    @RecentlyNullable
    public abstract OnAdMetadataChangedListener getOnAdMetadataChangedListener();

    @RecentlyNonNull
    public abstract Bundle getAdMetadata();

    public abstract void show(@RecentlyNonNull Activity var1, @RecentlyNonNull OnUserEarnedRewardListener var2);

    @NonNull
    public abstract RewardItem getRewardItem();

    @NonNull
    public abstract ResponseInfo getResponseInfo();

    public abstract void setOnPaidEventListener(@Nullable OnPaidEventListener var1);

    @RecentlyNullable
    public abstract OnPaidEventListener getOnPaidEventListener();

    public abstract void setFullScreenContentCallback(@Nullable FullScreenContentCallback var1);

    @RecentlyNullable
    public abstract FullScreenContentCallback getFullScreenContentCallback();

    @NonNull
    public abstract String getAdUnitId();

    public abstract void setImmersiveMode(boolean var1);
}

