/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.search;

import android.content.Context;
import android.os.Bundle;
import androidx.annotation.RecentlyNonNull;
import androidx.annotation.RecentlyNullable;
import com.google.ads.mediation.admob.AdMobAdapter;
import com.google.android.gms.ads.mediation.MediationAdapter;
import com.google.android.gms.ads.mediation.NetworkExtras;
import com.google.android.gms.ads.mediation.customevent.CustomEvent;
import com.google.android.gms.ads.search.SearchAdRequest;
import com.google.android.gms.ads.search.zza;
import com.google.android.gms.ads.search.zzc;
import com.google.android.gms.internal.ads.zzacp;

public final class DynamicHeightSearchAdRequest {
    private final SearchAdRequest zza;

    @RecentlyNullable
    public <T extends MediationAdapter> Bundle getNetworkExtrasBundle(@RecentlyNonNull Class<T> clazz) {
        return this.zza.getNetworkExtrasBundle(clazz);
    }

    @RecentlyNullable
    public <T extends CustomEvent> Bundle getCustomEventExtrasBundle(@RecentlyNonNull Class<T> clazz) {
        return this.zza.getCustomEventExtrasBundle(clazz);
    }

    @RecentlyNonNull
    public String getQuery() {
        return this.zza.getQuery();
    }

    public boolean isTestDevice(@RecentlyNonNull Context context) {
        return this.zza.isTestDevice(context);
    }

    final zzacp zza() {
        return this.zza.zza();
    }

    /* synthetic */ DynamicHeightSearchAdRequest(Builder object, zza object2) {
        object = ((Builder)object).zza;
        this.zza = object2 = new SearchAdRequest((zzc)object, null);
    }

    public static final class Builder {
        private final zzc zza;
        private final Bundle zzb;

        public Builder() {
            zzc zzc2;
            this.zza = zzc2 = new zzc();
            this.zzb = zzc2;
        }

        @RecentlyNonNull
        public Builder addNetworkExtras(@RecentlyNonNull NetworkExtras networkExtras) {
            this.zza.zza(networkExtras);
            return this;
        }

        @RecentlyNonNull
        public Builder addNetworkExtrasBundle(@RecentlyNonNull Class<? extends MediationAdapter> clazz, @RecentlyNonNull Bundle bundle) {
            this.zza.zzb(clazz, bundle);
            return this;
        }

        @RecentlyNonNull
        public Builder addCustomEventExtrasBundle(@RecentlyNonNull Class<? extends CustomEvent> clazz, @RecentlyNonNull Bundle bundle) {
            this.zza.zzc(clazz, bundle);
            return this;
        }

        @RecentlyNonNull
        public Builder setPage(int n) {
            this.zzb.putString("csa_adPage", Integer.toString(n));
            return this;
        }

        @RecentlyNonNull
        public Builder setNumber(int n) {
            this.zzb.putString("csa_number", Integer.toString(n));
            return this;
        }

        /*
         * Enabled aggressive block sorting
         */
        @RecentlyNonNull
        public Builder setAdTest(boolean bl) {
            Bundle bundle = this.zzb;
            String string = true != bl ? "off" : "on";
            bundle.putString("csa_adtest", string);
            return this;
        }

        @RecentlyNonNull
        public Builder setChannel(@RecentlyNonNull String string) {
            this.zzb.putString("csa_channel", string);
            return this;
        }

        @RecentlyNonNull
        public Builder setHostLanguage(@RecentlyNonNull String string) {
            this.zzb.putString("csa_hl", string);
            return this;
        }

        @RecentlyNonNull
        public Builder setLocationColor(@RecentlyNonNull String string) {
            this.zzb.putString("csa_colorLocation", string);
            return this;
        }

        @RecentlyNonNull
        public Builder setLocationFontSize(int n) {
            this.zzb.putString("csa_fontSizeLocation", Integer.toString(n));
            return this;
        }

        @RecentlyNonNull
        public Builder setIsClickToCallEnabled(boolean bl) {
            this.zzb.putString("csa_clickToCall", Boolean.toString(bl));
            return this;
        }

        @RecentlyNonNull
        public Builder setIsLocationEnabled(boolean bl) {
            this.zzb.putString("csa_location", Boolean.toString(bl));
            return this;
        }

        @RecentlyNonNull
        public Builder setIsPlusOnesEnabled(boolean bl) {
            this.zzb.putString("csa_plusOnes", Boolean.toString(bl));
            return this;
        }

        @RecentlyNonNull
        public Builder setIsSellerRatingsEnabled(boolean bl) {
            this.zzb.putString("csa_sellerRatings", Boolean.toString(bl));
            return this;
        }

        @RecentlyNonNull
        public Builder setIsSiteLinksEnabled(boolean bl) {
            this.zzb.putString("csa_siteLinks", Boolean.toString(bl));
            return this;
        }

        @RecentlyNonNull
        public Builder setCssWidth(int n) {
            this.zzb.putString("csa_width", Integer.toString(n));
            return this;
        }

        @RecentlyNonNull
        public Builder setFontFamily(@RecentlyNonNull String string) {
            this.zzb.putString("csa_fontFamily", string);
            return this;
        }

        @RecentlyNonNull
        public Builder setFontFamilyAttribution(@RecentlyNonNull String string) {
            this.zzb.putString("csa_fontFamilyAttribution", string);
            return this;
        }

        @RecentlyNonNull
        public Builder setFontSizeAnnotation(int n) {
            this.zzb.putString("csa_fontSizeAnnotation", Integer.toString(n));
            return this;
        }

        @RecentlyNonNull
        public Builder setFontSizeAttribution(int n) {
            this.zzb.putString("csa_fontSizeAttribution", Integer.toString(n));
            return this;
        }

        @RecentlyNonNull
        public Builder setFontSizeDescription(int n) {
            this.zzb.putString("csa_fontSizeDescription", Integer.toString(n));
            return this;
        }

        @RecentlyNonNull
        public Builder setFontSizeDomainLink(int n) {
            this.zzb.putString("csa_fontSizeDomainLink", Integer.toString(n));
            return this;
        }

        @RecentlyNonNull
        public Builder setFontSizeTitle(int n) {
            this.zzb.putString("csa_fontSizeTitle", Integer.toString(n));
            return this;
        }

        @RecentlyNonNull
        public Builder setColorAdBorder(@RecentlyNonNull String string) {
            this.zzb.putString("csa_colorAdBorder", string);
            return this;
        }

        @RecentlyNonNull
        public Builder setColorAdSeparator(@RecentlyNonNull String string) {
            this.zzb.putString("csa_colorAdSeparator", string);
            return this;
        }

        @RecentlyNonNull
        public Builder setColorAnnotation(@RecentlyNonNull String string) {
            this.zzb.putString("csa_colorAnnotation", string);
            return this;
        }

        @RecentlyNonNull
        public Builder setColorAttribution(@RecentlyNonNull String string) {
            this.zzb.putString("csa_colorAttribution", string);
            return this;
        }

        @RecentlyNonNull
        public Builder setColorBackground(@RecentlyNonNull String string) {
            this.zzb.putString("csa_colorBackground", string);
            return this;
        }

        @RecentlyNonNull
        public Builder setColorBorder(@RecentlyNonNull String string) {
            this.zzb.putString("csa_colorBorder", string);
            return this;
        }

        @RecentlyNonNull
        public Builder setColorDomainLink(@RecentlyNonNull String string) {
            this.zzb.putString("csa_colorDomainLink", string);
            return this;
        }

        @RecentlyNonNull
        public Builder setColorText(@RecentlyNonNull String string) {
            this.zzb.putString("csa_colorText", string);
            return this;
        }

        @RecentlyNonNull
        public Builder setColorTitleLink(@RecentlyNonNull String string) {
            this.zzb.putString("csa_colorTitleLink", string);
            return this;
        }

        @RecentlyNonNull
        public Builder setAdBorderSelectors(@RecentlyNonNull String string) {
            this.zzb.putString("csa_adBorderSelectors", string);
            return this;
        }

        @RecentlyNonNull
        public Builder setAdjustableLineHeight(int n) {
            this.zzb.putString("csa_adjustableLineHeight", Integer.toString(n));
            return this;
        }

        @RecentlyNonNull
        public Builder setAttributionSpacingBelow(int n) {
            this.zzb.putString("csa_attributionSpacingBelow", Integer.toString(n));
            return this;
        }

        @RecentlyNonNull
        public Builder setBorderSelections(@RecentlyNonNull String string) {
            this.zzb.putString("csa_borderSelections", string);
            return this;
        }

        @RecentlyNonNull
        public Builder setIsTitleUnderlined(boolean bl) {
            this.zzb.putString("csa_noTitleUnderline", Boolean.toString(bl ^ true));
            return this;
        }

        @RecentlyNonNull
        public Builder setIsTitleBold(boolean bl) {
            this.zzb.putString("csa_titleBold", Boolean.toString(bl));
            return this;
        }

        @RecentlyNonNull
        public Builder setVerticalSpacing(int n) {
            this.zzb.putString("csa_verticalSpacing", Integer.toString(n));
            return this;
        }

        @RecentlyNonNull
        public Builder setDetailedAttribution(boolean bl) {
            this.zzb.putString("csa_detailedAttribution", Boolean.toString(bl));
            return this;
        }

        @RecentlyNonNull
        public Builder setLongerHeadlines(boolean bl) {
            this.zzb.putString("csa_longerHeadlines", Boolean.toString(bl));
            return this;
        }

        @RecentlyNonNull
        public Builder setStyleId(@RecentlyNonNull String string) {
            this.zzb.putString("csa_styleId", string);
            return this;
        }

        @RecentlyNonNull
        public Builder setAdvancedOptionValue(@RecentlyNonNull String string, @RecentlyNonNull String string2) {
            this.zzb.putString(string, string2);
            return this;
        }

        @RecentlyNonNull
        public DynamicHeightSearchAdRequest build() {
            this.zza.zzb(AdMobAdapter.class, this.zzb);
            DynamicHeightSearchAdRequest dynamicHeightSearchAdRequest = new DynamicHeightSearchAdRequest(this, null);
            return dynamicHeightSearchAdRequest;
        }

        @RecentlyNonNull
        public Builder setQuery(@RecentlyNonNull String string) {
            this.zza.zzd(string);
            return this;
        }
    }
}

