/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.search;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.RecentlyNonNull;
import androidx.annotation.RecentlyNullable;
import androidx.annotation.RequiresPermission;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.search.DynamicHeightSearchAdRequest;
import com.google.android.gms.ads.search.SearchAdRequest;
import com.google.android.gms.internal.ads.zzacr;
import com.google.android.gms.internal.ads.zzbbf;
import org.checkerframework.checker.initialization.qual.NotOnlyInitialized;

public final class SearchAdView
extends ViewGroup {
    @NotOnlyInitialized
    private final zzacr zza;

    public SearchAdView(@RecentlyNonNull Context object) {
        super(object);
        super(this);
        this.zza = object;
    }

    public SearchAdView(@RecentlyNonNull Context object, @RecentlyNonNull AttributeSet attributeSet) {
        super(object, attributeSet);
        super(this, attributeSet, false);
        this.zza = object;
    }

    public SearchAdView(@RecentlyNonNull Context object, @RecentlyNonNull AttributeSet attributeSet, int n) {
        super(object, attributeSet, n);
        super(this, attributeSet, false);
        this.zza = object;
    }

    public void destroy() {
        this.zza.zza();
    }

    @RecentlyNonNull
    public AdListener getAdListener() {
        return this.zza.zzb();
    }

    @RecentlyNullable
    public AdSize getAdSize() {
        return this.zza.zzc();
    }

    @RecentlyNonNull
    public String getAdUnitId() {
        return this.zza.zze();
    }

    @RequiresPermission(value="android.permission.INTERNET")
    public void loadAd(@RecentlyNonNull SearchAdRequest searchAdRequest) {
        this.zza.zzg(searchAdRequest.zza());
    }

    @RequiresPermission(value="android.permission.INTERNET")
    public void loadAd(@RecentlyNonNull DynamicHeightSearchAdRequest dynamicHeightSearchAdRequest) {
        if (!AdSize.SEARCH.equals(object.getAdSize())) {
            Object object = new IllegalStateException("You must use AdSize.SEARCH for a DynamicHeightSearchAdRequest");
            throw object;
        }
        object.zza.zzg(dynamicHeightSearchAdRequest.zza());
    }

    public void pause() {
        this.zza.zzh();
    }

    public void resume() {
        this.zza.zzj();
    }

    public void setAdListener(@RecentlyNonNull AdListener adListener) {
        this.zza.zzk(adListener);
    }

    public void setAdSize(@RecentlyNonNull AdSize adSize) {
        zzacr zzacr2 = ((SearchAdView)((Object)zzacr2)).zza;
        AdSize[] adSizeArray = new AdSize[]{adSize};
        zzacr2.zzm(adSizeArray);
    }

    public void setAdUnitId(@RecentlyNonNull String string) {
        this.zza.zzo(string);
    }

    /*
     * WARNING - void declaration
     */
    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        if ((this = this.getChildAt(0)) != null && this.getVisibility() != 8) {
            void var3_4;
            void var5_6;
            void var2_3;
            void var4_5;
            int n5 = this.getMeasuredWidth();
            int n6 = this.getMeasuredHeight();
            var2_3 = (var4_5 - var2_3 - n5) / 2;
            var3_4 = (var5_6 - var3_4 - n6) / 2;
            this.layout((int)var2_3, (int)var3_4, (int)(var2_3 + n5), (int)(var3_4 + n6));
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void onMeasure(int n, int n2) {
        int n3;
        int n4;
        int n5;
        Object object = this.getChildAt(0);
        if (object != null && object.getVisibility() != 8) {
            this.measureChild((View)object, n, n2);
            n5 = object.getMeasuredWidth();
            n4 = object.getMeasuredHeight();
            n3 = n5;
            n5 = n4;
        } else {
            try {
                object = this.getAdSize();
            }
            catch (NullPointerException nullPointerException) {
                zzbbf.zzg("Unable to retrieve ad size.", nullPointerException);
                object = null;
            }
            if (object != null) {
                Context context = this.getContext();
                n4 = ((AdSize)object).getWidthInPixels(context);
                n5 = ((AdSize)object).getHeightInPixels(context);
                n3 = n4;
            } else {
                n3 = 0;
                n5 = 0;
            }
        }
        n4 = this.getSuggestedMinimumWidth();
        n3 = Math.max(n3, n4);
        n4 = this.getSuggestedMinimumHeight();
        n5 = Math.max(n5, n4);
        this.setMeasuredDimension(View.resolveSize((int)n3, (int)n), View.resolveSize((int)n5, (int)n2));
    }
}

