/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.content.Context;
import android.os.RemoteException;
import android.webkit.WebView;
import androidx.annotation.NonNull;
import com.google.android.gms.ads.AdInspectorError;
import com.google.android.gms.ads.OnAdInspectorClosedListener;
import com.google.android.gms.ads.RequestConfiguration;
import com.google.android.gms.ads.initialization.AdapterStatus;
import com.google.android.gms.ads.initialization.InitializationStatus;
import com.google.android.gms.ads.initialization.OnInitializationCompleteListener;
import com.google.android.gms.ads.mediation.rtb.RtbAdapter;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.dynamic.ObjectWrapper;
import com.google.android.gms.internal.ads.zzabk;
import com.google.android.gms.internal.ads.zzabw;
import com.google.android.gms.internal.ads.zzacs;
import com.google.android.gms.internal.ads.zzact;
import com.google.android.gms.internal.ads.zzacv;
import com.google.android.gms.internal.ads.zzacw;
import com.google.android.gms.internal.ads.zzadr;
import com.google.android.gms.internal.ads.zzaep;
import com.google.android.gms.internal.ads.zzame;
import com.google.android.gms.internal.ads.zzaml;
import com.google.android.gms.internal.ads.zzamm;
import com.google.android.gms.internal.ads.zzamn;
import com.google.android.gms.internal.ads.zzapp;
import com.google.android.gms.internal.ads.zzapt;
import com.google.android.gms.internal.ads.zzapw;
import com.google.android.gms.internal.ads.zzauv;
import com.google.android.gms.internal.ads.zzbab;
import com.google.android.gms.internal.ads.zzbay;
import com.google.android.gms.internal.ads.zzbbf;
import com.google.android.gms.internal.ads.zzebz;
import com.google.android.gms.internal.ads.zzhw;
import com.google.android.gms.internal.ads.zzzs;
import com.google.android.gms.internal.ads.zzzw;
import com.google.android.gms.internal.ads.zzzy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;

public final class zzacx {
    private final ArrayList<OnInitializationCompleteListener> zza;
    private final Object zzb;
    @GuardedBy(value="InternalMobileAds.class")
    private static zzacx zzc;
    @GuardedBy(value="lock")
    private zzabk zzd;
    private boolean zze;
    private boolean zzf;
    @Nullable
    private OnAdInspectorClosedListener zzg;
    @NonNull
    private RequestConfiguration zzh;
    private InitializationStatus zzi;

    private zzacx() {
        ArrayList arrayList = new ArrayList();
        this.zzb = arrayList;
        this.zze = false;
        this.zzf = false;
        this.zzg = null;
        arrayList = new ArrayList();
        this.zzh = ((RequestConfiguration.Builder)((Object)arrayList)).build();
        arrayList = new ArrayList();
        this.zza = arrayList;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static zzacx zza() {
        Class<zzacx> clazz = zzacx.class;
        synchronized (clazz) {
            zzacx zzacx2 = zzc;
            if (zzacx2 != null) return zzc;
            zzc = zzacx2 = new zzacx();
            return zzc;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void zzb(Context object, @Nullable String object2, @Nullable OnInitializationCompleteListener onInitializationCompleteListener) {
        object2 = ((zzacx)object3).zzb;
        synchronized (object2) {
            block14: {
                boolean bl = ((zzacx)object3).zze;
                if (bl) {
                    if (onInitializationCompleteListener != null) {
                        zzacx.zza().zza.add(onInitializationCompleteListener);
                    }
                    return;
                }
                bl = ((zzacx)object3).zzf;
                if (bl) {
                    if (onInitializationCompleteListener != null) {
                        onInitializationCompleteListener.onInitializationComplete(((zzacx)object3).zzj());
                    }
                    return;
                }
                ((zzacx)object3).zze = true;
                if (onInitializationCompleteListener != null) {
                    zzacx.zza().zza.add(onInitializationCompleteListener);
                }
                if (object == null) {
                    Object object3 = new IllegalArgumentException("Context cannot be null.");
                    throw object3;
                }
                try {
                    zzhw zzhw2;
                    zzapp.zza().zzb((Context)object, null);
                    super.zzw((Context)object);
                    if (onInitializationCompleteListener != null) {
                        zzabk zzabk2 = ((zzacx)object3).zzd;
                        zzhw2 = new zzacw((zzacx)object3, null);
                        zzabk2.zzp((zzaml)zzhw2);
                    }
                    zzabk zzabk3 = ((zzacx)object3).zzd;
                    zzhw2 = new zzapt();
                    zzabk3.zzo((zzapw)zzhw2);
                    ((zzacx)object3).zzd.zze();
                    zzabk3 = ((zzacx)object3).zzd;
                    zzabk3.zzj(null, ObjectWrapper.wrap(null));
                    int n = ((zzacx)object3).zzh.getTagForChildDirectedTreatment();
                    if (n != -1 || (n = ((zzacx)object3).zzh.getTagForUnderAgeOfConsent()) != -1) {
                        super.zzv(((zzacx)object3).zzh);
                    }
                    zzaep.zza(object);
                    object = zzaep.zzdx;
                    boolean bl2 = (Boolean)zzzy.zze().zzb(object);
                    if (bl2 || (bl2 = ((zzacx)object3).zzh().endsWith("0"))) break block14;
                    zzbbf.zzf("Google Mobile Ads SDK initialization functionality unavailable for this session. Ad requests can be made at any time.");
                    zzact zzact2 = new zzact((zzacx)object3);
                    ((zzacx)object3).zzi = zzact2;
                    if (onInitializationCompleteListener != null) {
                        zzact2 = zzbay.zza;
                        zzacs zzacs2 = new zzacs((zzacx)object3, onInitializationCompleteListener);
                        zzact2.post(zzacs2);
                    }
                }
                catch (RemoteException remoteException) {
                    zzbbf.zzj("MobileAdsSettingManager initialization failed", remoteException);
                }
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void zzc(float f) {
        boolean bl = !(f < 0.0f) ? f <= 1.0f : false;
        Preconditions.checkArgument((boolean)bl, (Object)"The app volume must be a value between 0 and 1 inclusive.");
        Object object = this.zzb;
        synchronized (object) {
            zzabk zzabk2 = this.zzd;
            boolean bl2 = zzabk2 != null;
            Preconditions.checkState((boolean)bl2, (Object)"MobileAds.initialize() must be called prior to setting the app volume.");
            try {
                this.zzd.zzf(f);
            }
            catch (RemoteException remoteException) {
                zzbbf.zzg("Unable to set app volume.", remoteException);
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final float zzd() {
        Object object = ((zzacx)((Object)zzabk2)).zzb;
        synchronized (object) {
            zzabk zzabk2 = ((zzacx)((Object)zzabk2)).zzd;
            if (zzabk2 == null) {
                return 1.0f;
            }
            try {
                return zzabk2.zzk();
            }
            catch (RemoteException remoteException) {
                zzbbf.zzg("Unable to get app volume.", remoteException);
                return 1.0f;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void zze(boolean bl) {
        Object object = this.zzb;
        synchronized (object) {
            zzabk zzabk2 = this.zzd;
            boolean bl2 = zzabk2 != null;
            String string = "MobileAds.initialize() must be called prior to setting app muted state.";
            Preconditions.checkState((boolean)bl2, (Object)string);
            try {
                this.zzd.zzh(bl);
            }
            catch (RemoteException remoteException) {
                zzbbf.zzg("Unable to set app mute state.", remoteException);
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final boolean zzf() {
        Object object = ((zzacx)((Object)zzabk2)).zzb;
        synchronized (object) {
            zzabk zzabk2 = ((zzacx)((Object)zzabk2)).zzd;
            if (zzabk2 == null) {
                return false;
            }
            try {
                return zzabk2.zzl();
            }
            catch (RemoteException remoteException) {
                zzbbf.zzg("Unable to get app mute state.", remoteException);
                return false;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void zzg(Context context, String string) {
        Object object = ((zzacx)((Object)zzabk3)).zzb;
        synchronized (object) {
            zzabk zzabk2 = ((zzacx)((Object)zzabk3)).zzd;
            boolean bl = zzabk2 != null;
            String string2 = "MobileAds.initialize() must be called prior to opening debug menu.";
            Preconditions.checkState((boolean)bl, (Object)string2);
            try {
                zzabk zzabk3 = ((zzacx)((Object)zzabk3)).zzd;
                zzabk3.zzi(ObjectWrapper.wrap((Object)context), string);
            }
            catch (RemoteException remoteException) {
                zzbbf.zzg("Unable to open debug menu.", remoteException);
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final String zzh() {
        Object object = ((zzacx)this).zzb;
        synchronized (object) {
            zzabk zzabk2 = ((zzacx)this).zzd;
            boolean bl = zzabk2 != null;
            String string = "MobileAds.initialize() must be called prior to getting version string.";
            Preconditions.checkState((boolean)bl, (Object)string);
            try {
                return zzebz.zza(((zzacx)this).zzd.zzm());
            }
            catch (RemoteException remoteException) {
                zzbbf.zzg("Unable to get version string.", remoteException);
                return "";
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void zzi(Class<? extends RtbAdapter> clazz) {
        Object object = this.zzb;
        synchronized (object) {
            try {
                this.zzd.zzn(clazz.getCanonicalName());
            }
            catch (RemoteException remoteException) {
                zzbbf.zzg("Unable to register RtbAdapter", remoteException);
            }
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final InitializationStatus zzj() {
        Object object = this.zzb;
        synchronized (object) {
            InitializationStatus initializationStatus;
            zzabk zzabk2 = this.zzd;
            boolean bl = zzabk2 != null;
            String string = "MobileAds.initialize() must be called prior to getting initialization status.";
            Preconditions.checkState((boolean)bl, (Object)string);
            try {
                initializationStatus = this.zzi;
                if (initializationStatus == null) return zzacx.zzx(this.zzd.zzq());
            }
            catch (RemoteException remoteException) {
                zzbbf.zzf("Unable to get Initialization status.");
                return new zzact(this);
            }
            return initializationStatus;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void zzk(Context context) {
        Object object = this.zzb;
        synchronized (object) {
            this.zzw(context);
            try {
                this.zzd.zzs();
            }
            catch (RemoteException remoteException) {
                zzbbf.zzf("Unable to disable mediation adapter initialization.");
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void zzl(Context object, OnAdInspectorClosedListener onAdInspectorClosedListener) {
        Object object2 = ((zzacx)object3).zzb;
        synchronized (object2) {
            block5: {
                Object object3;
                ((zzacx)object3).zzw((Context)object);
                zzacx.zza().zzg = onAdInspectorClosedListener;
                try {
                    object3 = ((zzacx)object3).zzd;
                    object = new zzacv(null);
                    object3.zzt((zzabw)object);
                }
                catch (RemoteException remoteException) {
                    zzbbf.zzf("Unable to open the ad inspector.");
                    if (onAdInspectorClosedListener == null) break block5;
                    object3 = new AdInspectorError(0, "Ad inspector had an internal error.", "com.google.android.gms.ads");
                    onAdInspectorClosedListener.onAdInspectorClosed((AdInspectorError)object3);
                }
            }
            return;
        }
    }

    @NonNull
    public final RequestConfiguration zzm() {
        return this.zzh;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void zzn(@NonNull RequestConfiguration requestConfiguration) {
        boolean bl = requestConfiguration != null;
        Preconditions.checkArgument((boolean)bl, (Object)"Null passed to setRequestConfiguration.");
        Object object = this.zzb;
        synchronized (object) {
            int n;
            RequestConfiguration requestConfiguration2 = this.zzh;
            this.zzh = requestConfiguration;
            zzabk zzabk2 = this.zzd;
            if (zzabk2 == null) {
                return;
            }
            int n2 = requestConfiguration2.getTagForChildDirectedTreatment();
            if (n2 == (n = requestConfiguration.getTagForChildDirectedTreatment())) {
                int n3 = requestConfiguration2.getTagForUnderAgeOfConsent();
                if (n3 == (n2 = requestConfiguration.getTagForUnderAgeOfConsent())) return;
            }
            this.zzv(requestConfiguration);
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void zzo(@NonNull WebView webView) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        Object object = ((zzacx)object).zzb;
        synchronized (object) {
            if (webView == null) {
                zzbbf.zzf("The webview to be registered cannot be null.");
                return;
            }
            zzbab zzbab2 = zzauv.zza(webView.getContext());
            if (zzbab2 == null) {
                zzbbf.zzi("Internal error, query info generator is null.");
                return;
            }
            try {
                zzbab2.zzj(ObjectWrapper.wrap((Object)webView));
            }
            catch (RemoteException remoteException) {
                zzbbf.zzg("", remoteException);
            }
            return;
        }
    }

    @GuardedBy(value="lock")
    private final void zzv(@NonNull RequestConfiguration requestConfiguration) {
        try {
            zzabk zzabk2 = ((zzacx)((Object)zzabk2)).zzd;
            zzadr zzadr2 = new zzadr(requestConfiguration);
            zzabk2.zzr(zzadr2);
            return;
        }
        catch (RemoteException remoteException) {
            zzbbf.zzg("Unable to set request configuration parcel.", remoteException);
            return;
        }
    }

    @GuardedBy(value="lock")
    private final void zzw(Context context) {
        if (this.zzd == null) {
            zzzw zzzw2 = zzzy.zzb();
            zzzs zzzs2 = new zzzs(zzzw2, context);
            this.zzd = (zzabk)zzzs2.zzd(context, false);
            return;
        }
    }

    final /* synthetic */ void zzp(OnInitializationCompleteListener onInitializationCompleteListener) {
        onInitializationCompleteListener.onInitializationComplete(this.zzi);
    }

    static /* synthetic */ boolean zzq(zzacx zzacx2, boolean bl) {
        zzacx2.zze = false;
        return false;
    }

    static /* synthetic */ boolean zzr(zzacx zzacx2, boolean bl) {
        zzacx2.zzf = true;
        return true;
    }

    static /* synthetic */ InitializationStatus zzs(zzacx zzacx2, List list) {
        return zzacx.zzx(list);
    }

    static /* synthetic */ ArrayList zzt(zzacx zzacx2) {
        return zzacx2.zza;
    }

    static /* synthetic */ OnAdInspectorClosedListener zzu(zzacx zzacx2) {
        return zzacx2.zzg;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private static final InitializationStatus zzx(List<zzame> object) {
        HashMap<String, AdapterStatus> hashMap = new HashMap<String, AdapterStatus>();
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            void var0_3;
            zzame zzame2 = (zzame)((Object)iterator.next());
            String string = zzame2.zza;
            if (zzame2.zzb) {
                AdapterStatus.State state = AdapterStatus.State.READY;
            } else {
                AdapterStatus.State state = AdapterStatus.State.NOT_READY;
            }
            zzamm zzamm2 = new zzamm((AdapterStatus.State)var0_3, zzame2.zzd, zzame2.zzc);
            hashMap.put(string, zzamm2);
        }
        return new zzamn(hashMap);
    }
}

