/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.content.Context;
import android.net.Uri;
import android.os.Build;
import android.os.RemoteException;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.google.android.gms.ads.h5.OnH5AdsEventListener;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.ads.zzaeh;
import com.google.android.gms.internal.ads.zzaep;
import com.google.android.gms.internal.ads.zzali;
import com.google.android.gms.internal.ads.zzapt;
import com.google.android.gms.internal.ads.zzbbf;
import com.google.android.gms.internal.ads.zzzw;
import com.google.android.gms.internal.ads.zzzy;

@RequiresApi(api=21)
public final class zzalm {
    private final Context zza;
    private final OnH5AdsEventListener zzb;
    @Nullable
    private zzali zzc;

    /*
     * Enabled aggressive block sorting
     */
    public zzalm(Context context, OnH5AdsEventListener onH5AdsEventListener) {
        boolean bl = Build.VERSION.SDK_INT >= 21;
        Preconditions.checkState((boolean)bl, (Object)"Android version must be Lollipop or higher");
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)onH5AdsEventListener);
        this.zza = context;
        this.zzb = onH5AdsEventListener;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean zza(String string) {
        if (!zzalm.zzc(string)) {
            return false;
        }
        ((zzalm)((Object)zzali2)).zzd();
        zzali zzali2 = ((zzalm)((Object)zzali2)).zzc;
        if (zzali2 == null) return false;
        try {
            zzali2.zze(string);
            return true;
        }
        catch (RemoteException remoteException) {
            zzbbf.zzl("#007 Could not call remote method.", remoteException);
            return true;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void zzb() {
        zzaeh<Boolean> zzaeh2 = zzaep.zzgb;
        if (!zzzy.zze().zzb(zzaeh2).booleanValue()) {
            return;
        }
        ((zzalm)((Object)zzali2)).zzd();
        zzali zzali2 = ((zzalm)((Object)zzali2)).zzc;
        if (zzali2 == null) return;
        try {
            zzali2.zzf();
            return;
        }
        catch (RemoteException remoteException) {
            zzbbf.zzl("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    private final void zzd() {
        if (this.zzc != null) {
            return;
        }
        zzzw zzzw2 = zzzy.zzb();
        Context context = this.zza;
        zzapt zzapt2 = new zzapt();
        this.zzc = zzzw2.zzj(context, zzapt2, this.zzb);
    }

    public static final boolean zzc(String string) {
        zzaeh<Boolean> zzaeh2 = zzaep.zzgb;
        if (!zzzy.zze().zzb(zzaeh2).booleanValue()) {
            return false;
        }
        Preconditions.checkNotNull((Object)string);
        int n = string.length();
        zzaeh<Integer> zzaeh3 = zzaep.zzgd;
        if (n > zzzy.zze().zzb(zzaeh3)) {
            zzbbf.zzd("H5 GMSG exceeds max length");
            return false;
        }
        return "gmsg".equals((string = Uri.parse((String)string)).getScheme()) && "mobileads.google.com".equals(string.getHost()) && "/h5ads".equals(string.getPath());
    }
}

