/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads;

import android.content.Context;
import android.os.RemoteException;
import androidx.annotation.RecentlyNonNull;
import androidx.annotation.RequiresPermission;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.VideoOptions;
import com.google.android.gms.ads.admanager.AdManagerAdRequest;
import com.google.android.gms.ads.formats.AdManagerAdViewOptions;
import com.google.android.gms.ads.formats.NativeCustomTemplateAd;
import com.google.android.gms.ads.formats.OnAdManagerAdViewLoadedListener;
import com.google.android.gms.ads.formats.UnifiedNativeAd;
import com.google.android.gms.ads.nativead.NativeAd;
import com.google.android.gms.ads.nativead.NativeAdOptions;
import com.google.android.gms.ads.nativead.NativeCustomFormatAd;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.ads.zzaan;
import com.google.android.gms.internal.ads.zzaaq;
import com.google.android.gms.internal.ads.zzacq;
import com.google.android.gms.internal.ads.zzadh;
import com.google.android.gms.internal.ads.zzady;
import com.google.android.gms.internal.ads.zzagy;
import com.google.android.gms.internal.ads.zzajk;
import com.google.android.gms.internal.ads.zzajm;
import com.google.android.gms.internal.ads.zzajn;
import com.google.android.gms.internal.ads.zzapy;
import com.google.android.gms.internal.ads.zzatt;
import com.google.android.gms.internal.ads.zzatv;
import com.google.android.gms.internal.ads.zzbbk;
import com.google.android.gms.internal.ads.zzyo;
import com.google.android.gms.internal.ads.zzyw;
import com.google.android.gms.internal.ads.zzyx;
import com.google.android.gms.internal.ads.zzzw;
import com.google.android.gms.internal.ads.zzzy;

public class AdLoader {
    private final zzyw zza;
    private final Context zzb;
    private final zzaan zzc;

    @RequiresPermission(value="android.permission.INTERNET")
    public void loadAd(@RecentlyNonNull AdRequest adRequest) {
        this.zza(adRequest.zza());
    }

    public void loadAd(@RecentlyNonNull AdManagerAdRequest adManagerAdRequest) {
        this.zza(adManagerAdRequest.zza);
    }

    @RequiresPermission(value="android.permission.INTERNET")
    public void loadAds(@RecentlyNonNull AdRequest object, int n) {
        object = ((AdRequest)object).zza();
        try {
            this.zzc.zzi(this.zza.zza(this.zzb, (zzacq)object), n);
            return;
        }
        catch (RemoteException remoteException) {
            zzbbk.zzg("Failed to load ads.", remoteException);
            return;
        }
    }

    public boolean isLoading() {
        try {
            boolean bl = this.zzc.zzg();
            return bl;
        }
        catch (RemoteException remoteException) {
            zzbbk.zzj("Failed to check if ad is loading.", remoteException);
            return false;
        }
    }

    AdLoader(Context context, zzaan zzaan2, zzyw zzyw2) {
        this.zzb = context;
        this.zzc = zzaan2;
        this.zza = zzyw2;
    }

    private final void zza(zzacq zzacq2) {
        try {
            this.zzc.zze(this.zza.zza(this.zzb, zzacq2));
            return;
        }
        catch (RemoteException remoteException) {
            zzbbk.zzg("Failed to load ad.", remoteException);
            return;
        }
    }

    public static class Builder {
        private final Context zza;
        private final zzaaq zzb;

        public Builder(@RecentlyNonNull Context object, @RecentlyNonNull String string) {
            Object object2 = Preconditions.checkNotNull((Object)object, (Object)"context cannot be null");
            object2 = (Context)object2;
            zzzw zzzw2 = zzzy.zzb();
            zzapy zzapy2 = new zzapy();
            object = zzzw2.zzc((Context)object, string, zzapy2);
            this.zza = object2;
            this.zzb = object;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Deprecated
        @RecentlyNonNull
        public Builder forUnifiedNativeAd(@RecentlyNonNull UnifiedNativeAd.OnUnifiedNativeAdLoadedListener onUnifiedNativeAdLoadedListener) {
            try {
                zzaaq zzaaq2 = this.zzb;
                zzajn zzajn2 = new zzajn(onUnifiedNativeAdLoadedListener);
                zzaaq2.zzm(zzajn2);
                return this;
            }
            catch (RemoteException remoteException) {
                zzbbk.zzj("Failed to add google native ad listener", remoteException);
                return this;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @RecentlyNonNull
        public Builder forNativeAd(@RecentlyNonNull NativeAd.OnNativeAdLoadedListener onNativeAdLoadedListener) {
            try {
                zzaaq zzaaq2 = this.zzb;
                zzatv zzatv2 = new zzatv(onNativeAdLoadedListener);
                zzaaq2.zzm(zzatv2);
                return this;
            }
            catch (RemoteException remoteException) {
                zzbbk.zzj("Failed to add google native ad listener", remoteException);
                return this;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Deprecated
        @RecentlyNonNull
        public Builder forCustomTemplateAd(@RecentlyNonNull String string, @RecentlyNonNull NativeCustomTemplateAd.OnCustomTemplateAdLoadedListener onCustomTemplateAdLoadedListener, @RecentlyNonNull NativeCustomTemplateAd.OnCustomClickListener onCustomClickListener) {
            zzajk zzajk2 = new zzajk(onCustomTemplateAdLoadedListener, onCustomClickListener);
            try {
                this.zzb.zzi(string, zzajk2.zza(), zzajk2.zzb());
                return this;
            }
            catch (RemoteException remoteException) {
                zzbbk.zzj("Failed to add custom template ad listener", remoteException);
                return this;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @RecentlyNonNull
        public Builder forCustomFormatAd(@RecentlyNonNull String string, @RecentlyNonNull NativeCustomFormatAd.OnCustomFormatAdLoadedListener onCustomFormatAdLoadedListener, @RecentlyNonNull NativeCustomFormatAd.OnCustomClickListener onCustomClickListener) {
            zzatt zzatt2 = new zzatt(onCustomFormatAdLoadedListener, onCustomClickListener);
            try {
                this.zzb.zzi(string, zzatt2.zza(), zzatt2.zzb());
                return this;
            }
            catch (RemoteException remoteException) {
                zzbbk.zzj("Failed to add custom format ad listener", remoteException);
                return this;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @RecentlyNonNull
        public Builder forAdManagerAdView(@RecentlyNonNull OnAdManagerAdViewLoadedListener onAdManagerAdViewLoadedListener, AdSize ... object) {
            Object object2;
            if (object != null && ((Object)object).length > 0) {
                try {
                    zzyx zzyx2 = new zzyx(((Builder)object2).zza, (AdSize[])object);
                    object = ((Builder)object2).zzb;
                    zzajm zzajm2 = new zzajm(onAdManagerAdViewLoadedListener);
                    object.zzk(zzajm2, zzyx2);
                    return object2;
                }
                catch (RemoteException remoteException) {
                    zzbbk.zzj("Failed to add Google Ad Manager banner ad listener", remoteException);
                    return object2;
                }
            }
            object2 = new IllegalArgumentException("The supported ad sizes must contain at least one valid ad size.");
            throw object2;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @RecentlyNonNull
        public Builder withAdListener(@RecentlyNonNull AdListener adListener) {
            try {
                zzaaq zzaaq2 = this.zzb;
                zzyo zzyo2 = new zzyo(adListener);
                zzaaq2.zzf(zzyo2);
                return this;
            }
            catch (RemoteException remoteException) {
                zzbbk.zzj("Failed to set AdListener.", remoteException);
                return this;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Deprecated
        @RecentlyNonNull
        public Builder withNativeAdOptions(@RecentlyNonNull com.google.android.gms.ads.formats.NativeAdOptions nativeAdOptions) {
            try {
                zzaaq zzaaq2 = this.zzb;
                zzagy zzagy2 = new zzagy(nativeAdOptions);
                zzaaq2.zzj(zzagy2);
                return this;
            }
            catch (RemoteException remoteException) {
                zzbbk.zzj("Failed to specify native ad options", remoteException);
                return this;
            }
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @RecentlyNonNull
        public Builder withNativeAdOptions(@RecentlyNonNull NativeAdOptions nativeAdOptions) {
            try {
                void var2_10;
                zzaaq zzaaq2 = this.zzb;
                boolean bl = nativeAdOptions.shouldReturnUrlsForImageAssets();
                boolean bl2 = nativeAdOptions.shouldRequestMultipleImages();
                int n = nativeAdOptions.getAdChoicesPlacement();
                VideoOptions videoOptions = nativeAdOptions.getVideoOptions();
                if (videoOptions != null) {
                    zzady zzady2 = new zzady(nativeAdOptions.getVideoOptions());
                } else {
                    Object var2_11 = null;
                }
                zzagy zzagy2 = new zzagy(4, bl, -1, bl2, n, (zzady)var2_10, nativeAdOptions.zza(), nativeAdOptions.getMediaAspectRatio());
                zzaaq2.zzj(zzagy2);
                return this;
            }
            catch (RemoteException remoteException) {
                zzbbk.zzj("Failed to specify native ad options", remoteException);
                return this;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @RecentlyNonNull
        public Builder withAdManagerAdViewOptions(@RecentlyNonNull AdManagerAdViewOptions adManagerAdViewOptions) {
            try {
                this.zzb.zzp(adManagerAdViewOptions);
                return this;
            }
            catch (RemoteException remoteException) {
                zzbbk.zzj("Failed to specify Ad Manager banner ad options", remoteException);
                return this;
            }
        }

        @RecentlyNonNull
        public AdLoader build() {
            try {
                Context context = this.zza;
                zzaan zzaan2 = this.zzb.zze();
                AdLoader adLoader = new AdLoader(context, zzaan2, zzyw.zza);
                return adLoader;
            }
            catch (RemoteException remoteException) {
                zzbbk.zzg("Failed to build AdLoader.", remoteException);
                zzadh zzadh2 = new zzadh();
                AdLoader adLoader = new AdLoader(this.zza, zzadh2.zzb(), zzyw.zza);
                return adLoader;
            }
        }
    }
}

