/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads;

import android.content.Context;
import android.util.DisplayMetrics;
import androidx.annotation.Nullable;
import androidx.annotation.RecentlyNonNull;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.ads.zzbbd;
import com.google.android.gms.internal.ads.zzbbk;
import com.google.android.gms.internal.ads.zzyx;
import com.google.android.gms.internal.ads.zzzy;

@VisibleForTesting
public final class AdSize {
    public static final int FULL_WIDTH = -1;
    public static final int AUTO_HEIGHT = -2;
    @RecentlyNonNull
    public static final AdSize BANNER;
    @RecentlyNonNull
    public static final AdSize FULL_BANNER;
    @RecentlyNonNull
    public static final AdSize LARGE_BANNER;
    @RecentlyNonNull
    public static final AdSize LEADERBOARD;
    @RecentlyNonNull
    public static final AdSize MEDIUM_RECTANGLE;
    @RecentlyNonNull
    public static final AdSize WIDE_SKYSCRAPER;
    @Deprecated
    @RecentlyNonNull
    public static final AdSize SMART_BANNER;
    @RecentlyNonNull
    public static final AdSize FLUID;
    @RecentlyNonNull
    public static final AdSize INVALID;
    @RecentlyNonNull
    public static final AdSize SEARCH;
    @RecentlyNonNull
    public static final AdSize zza;
    private final int zzb;
    private final int zzc;
    private final String zzd;
    private boolean zze;
    private boolean zzf;
    private int zzg;
    private boolean zzh;
    private int zzi;

    /*
     * Enabled aggressive block sorting
     */
    public AdSize(int n, int n2) {
        String string = n == -1 ? "FULL" : String.valueOf(n);
        String string2 = n2 == -2 ? "AUTO" : String.valueOf(n2);
        String string3 = String.valueOf(string);
        int n3 = string3.length();
        String string4 = String.valueOf(string2);
        int n4 = string4.length();
        StringBuilder stringBuilder = new StringBuilder(n3 + 4 + n4);
        stringBuilder.append(string);
        stringBuilder.append("x");
        stringBuilder.append(string2);
        stringBuilder.append("_as");
        this(n, n2, stringBuilder.toString());
    }

    AdSize(int n, int n2, String string) {
        Object object;
        if (n >= 0 || n == -1 || n == -3) {
            if (n2 < 0 && n2 != -2 && n2 != -4) {
                StringBuilder stringBuilder = new StringBuilder(38);
                stringBuilder.append("Invalid height for AdSize: ");
                stringBuilder.append(n2);
                object = new IllegalArgumentException(stringBuilder.toString());
                throw object;
            }
        } else {
            StringBuilder stringBuilder = new StringBuilder(37);
            stringBuilder.append("Invalid width for AdSize: ");
            stringBuilder.append(n);
            object = new IllegalArgumentException(stringBuilder.toString());
            throw object;
        }
        ((AdSize)object).zzb = n;
        ((AdSize)object).zzc = n2;
        ((AdSize)object).zzd = string;
    }

    @RecentlyNonNull
    public static AdSize getPortraitAnchoredAdaptiveBannerAdSize(@RecentlyNonNull Context object, int n) {
        object = zzbbd.zzh(object, n, 50, 1);
        object.zze = true;
        return object;
    }

    @RecentlyNonNull
    public static AdSize getLandscapeAnchoredAdaptiveBannerAdSize(@RecentlyNonNull Context object, int n) {
        object = zzbbd.zzh(object, n, 50, 2);
        object.zze = true;
        return object;
    }

    @RecentlyNonNull
    public static AdSize getCurrentOrientationAnchoredAdaptiveBannerAdSize(@RecentlyNonNull Context object, int n) {
        object = zzbbd.zzh(object, n, 50, 0);
        object.zze = true;
        return object;
    }

    @RecentlyNonNull
    public static AdSize getPortraitInlineAdaptiveBannerAdSize(@RecentlyNonNull Context context, int n) {
        int n2 = zzbbd.zzj(context, 1);
        AdSize adSize = new AdSize(n, 0);
        if (n2 == -1) {
            return INVALID;
        }
        adSize.zzg = n2;
        adSize.zzf = true;
        return adSize;
    }

    @RecentlyNonNull
    public static AdSize getLandscapeInlineAdaptiveBannerAdSize(@RecentlyNonNull Context context, int n) {
        int n2 = zzbbd.zzj(context, 2);
        AdSize adSize = new AdSize(n, 0);
        if (n2 == -1) {
            return INVALID;
        }
        adSize.zzg = n2;
        adSize.zzf = true;
        return adSize;
    }

    @RecentlyNonNull
    public static AdSize getCurrentOrientationInlineAdaptiveBannerAdSize(@RecentlyNonNull Context context, int n) {
        int n2 = zzbbd.zzj(context, 0);
        if (n2 == -1) {
            return INVALID;
        }
        AdSize adSize = new AdSize(n, 0);
        adSize.zzg = n2;
        adSize.zzf = true;
        return adSize;
    }

    @RecentlyNonNull
    public static AdSize getInlineAdaptiveBannerAdSize(int n, int n2) {
        AdSize adSize = new AdSize(n, 0);
        adSize.zzg = n2;
        adSize.zzf = true;
        if (n2 < 32) {
            StringBuilder stringBuilder = new StringBuilder(129);
            stringBuilder.append("The maximum height set for the inline adaptive ad size was ");
            stringBuilder.append(n2);
            stringBuilder.append(" dp, which is below the minimum recommended value of 32 dp.");
            zzbbk.zzi(stringBuilder.toString());
        }
        return adSize;
    }

    @RecentlyNonNull
    public static AdSize getPortraitInterscrollerAdSize(@RecentlyNonNull Context context, int n) {
        return AdSize.zzj(n, zzbbd.zzj(context, 1));
    }

    @RecentlyNonNull
    public static AdSize getLandscapeInterscrollerAdSize(@RecentlyNonNull Context context, int n) {
        return AdSize.zzj(n, zzbbd.zzj(context, 2));
    }

    @RecentlyNonNull
    public static AdSize getCurrentOrientationInterscrollerAdSize(@RecentlyNonNull Context context, int n) {
        return AdSize.zzj(n, zzbbd.zzj(context, 0));
    }

    public boolean equals(@Nullable Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (!(object instanceof AdSize)) {
            return false;
        }
        object = (AdSize)object;
        return this.zzb == ((AdSize)object).zzb && this.zzc == ((AdSize)object).zzc && this.zzd.equals(((AdSize)object).zzd);
    }

    public int getHeight() {
        return this.zzc;
    }

    public int getHeightInPixels(@RecentlyNonNull Context context) {
        switch (this.zzc) {
            default: {
                zzzy.zza();
                return zzbbd.zzs(context, this.zzc);
            }
            case -2: {
                return zzyx.zza(context.getResources().getDisplayMetrics());
            }
            case -4: 
            case -3: 
        }
        return -1;
    }

    public int getWidth() {
        return this.zzb;
    }

    public int getWidthInPixels(@RecentlyNonNull Context context) {
        switch (adSize.zzb) {
            default: {
                zzzy.zza();
                return zzbbd.zzs(context, adSize.zzb);
            }
            case -1: {
                AdSize adSize = context.getResources();
                adSize = adSize.getDisplayMetrics();
                return ((DisplayMetrics)adSize).widthPixels;
            }
            case -3: 
        }
        return -1;
    }

    public int hashCode() {
        return this.zzd.hashCode();
    }

    public boolean isAutoHeight() {
        return this.zzc == -2;
    }

    public boolean isFullWidth() {
        return this.zzb == -1;
    }

    public boolean isFluid() {
        return this.zzb == -3 && this.zzc == -4;
    }

    @RecentlyNonNull
    public String toString() {
        return this.zzd;
    }

    static {
        AdSize adSize;
        BANNER = adSize = new AdSize(320, 50, "320x50_mb");
        FULL_BANNER = adSize = new AdSize(468, 60, "468x60_as");
        LARGE_BANNER = adSize = new AdSize(320, 100, "320x100_as");
        LEADERBOARD = adSize = new AdSize(728, 90, "728x90_as");
        MEDIUM_RECTANGLE = adSize = new AdSize(300, 250, "300x250_as");
        WIDE_SKYSCRAPER = adSize = new AdSize(160, 600, "160x600_as");
        SMART_BANNER = adSize = new AdSize(-1, -2, "smart_banner");
        FLUID = adSize = new AdSize(-3, -4, "fluid");
        INVALID = adSize = new AdSize(0, 0, "invalid");
        zza = adSize = new AdSize(50, 50, "50x50_mb");
        SEARCH = adSize = new AdSize(-3, 0, "search_v2");
    }

    final boolean zza() {
        return this.zze;
    }

    final boolean zzb() {
        return this.zzf;
    }

    final void zzc(boolean bl) {
        this.zzf = true;
    }

    final void zzd(int n) {
        this.zzg = n;
    }

    final int zze() {
        return this.zzg;
    }

    final boolean zzf() {
        return this.zzh;
    }

    final void zzg(boolean bl) {
        this.zzh = true;
    }

    final int zzh() {
        return this.zzi;
    }

    final void zzi(int n) {
        this.zzi = n;
    }

    private static AdSize zzj(int n, int n2) {
        if (n2 == -1) {
            return INVALID;
        }
        AdSize adSize = new AdSize(n, 0);
        adSize.zzi = n2;
        adSize.zzh = true;
        return adSize;
    }
}

