/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.appopen;

import android.app.Activity;
import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RecentlyNonNull;
import androidx.annotation.RecentlyNullable;
import com.google.android.gms.ads.AdLoadCallback;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.FullScreenContentCallback;
import com.google.android.gms.ads.OnPaidEventListener;
import com.google.android.gms.ads.ResponseInfo;
import com.google.android.gms.ads.admanager.AdManagerAdRequest;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.ads.zztj;

public abstract class AppOpenAd {
    public static final int APP_OPEN_AD_ORIENTATION_PORTRAIT = 1;
    public static final int APP_OPEN_AD_ORIENTATION_LANDSCAPE = 2;

    public static void load(@RecentlyNonNull Context context, @RecentlyNonNull String string, @RecentlyNonNull AdRequest adRequest, @AppOpenAdOrientation int n, @RecentlyNonNull AppOpenAdLoadCallback appOpenAdLoadCallback) {
        Preconditions.checkNotNull((Object)context, (Object)"Context cannot be null.");
        Preconditions.checkNotNull((Object)string, (Object)"adUnitId cannot be null.");
        Preconditions.checkNotNull((Object)adRequest, (Object)"AdRequest cannot be null.");
        zztj zztj2 = new zztj(context, string, adRequest.zza(), n, appOpenAdLoadCallback);
        zztj2.zza();
    }

    public static void load(@RecentlyNonNull Context context, @RecentlyNonNull String string, @RecentlyNonNull AdManagerAdRequest adManagerAdRequest, @AppOpenAdOrientation int n, @RecentlyNonNull AppOpenAdLoadCallback appOpenAdLoadCallback) {
        Preconditions.checkNotNull((Object)context, (Object)"Context cannot be null.");
        Preconditions.checkNotNull((Object)string, (Object)"adUnitId cannot be null.");
        Preconditions.checkNotNull((Object)adManagerAdRequest, (Object)"AdManagerAdRequest cannot be null.");
        zztj zztj2 = new zztj(context, string, ((AdRequest)adManagerAdRequest).zza(), n, appOpenAdLoadCallback);
        zztj2.zza();
    }

    public abstract void show(@RecentlyNonNull Activity var1);

    @NonNull
    public abstract ResponseInfo getResponseInfo();

    @NonNull
    public abstract String getAdUnitId();

    public abstract void setFullScreenContentCallback(@Nullable FullScreenContentCallback var1);

    @RecentlyNullable
    public abstract FullScreenContentCallback getFullScreenContentCallback();

    public abstract void setOnPaidEventListener(@Nullable OnPaidEventListener var1);

    @RecentlyNullable
    public abstract OnPaidEventListener getOnPaidEventListener();

    public abstract void setImmersiveMode(boolean var1);

    public static abstract class AppOpenAdLoadCallback
    extends AdLoadCallback<AppOpenAd> {
    }

    public static @interface AppOpenAdOrientation {
    }
}

