/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.content.Context;
import android.os.RemoteException;
import android.webkit.WebView;
import androidx.annotation.NonNull;
import com.google.android.gms.ads.AdInspectorError;
import com.google.android.gms.ads.OnAdInspectorClosedListener;
import com.google.android.gms.ads.RequestConfiguration;
import com.google.android.gms.ads.initialization.AdapterStatus;
import com.google.android.gms.ads.initialization.InitializationStatus;
import com.google.android.gms.ads.initialization.OnInitializationCompleteListener;
import com.google.android.gms.ads.mediation.rtb.RtbAdapter;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.dynamic.ObjectWrapper;
import com.google.android.gms.internal.ads.zzaaa;
import com.google.android.gms.internal.ads.zzabl;
import com.google.android.gms.internal.ads.zzabx;
import com.google.android.gms.internal.ads.zzact;
import com.google.android.gms.internal.ads.zzacu;
import com.google.android.gms.internal.ads.zzacw;
import com.google.android.gms.internal.ads.zzacx;
import com.google.android.gms.internal.ads.zzads;
import com.google.android.gms.internal.ads.zzaeq;
import com.google.android.gms.internal.ads.zzamj;
import com.google.android.gms.internal.ads.zzamq;
import com.google.android.gms.internal.ads.zzamr;
import com.google.android.gms.internal.ads.zzams;
import com.google.android.gms.internal.ads.zzapu;
import com.google.android.gms.internal.ads.zzapy;
import com.google.android.gms.internal.ads.zzaqb;
import com.google.android.gms.internal.ads.zzava;
import com.google.android.gms.internal.ads.zzbag;
import com.google.android.gms.internal.ads.zzbbd;
import com.google.android.gms.internal.ads.zzbbk;
import com.google.android.gms.internal.ads.zzecs;
import com.google.android.gms.internal.ads.zzhx;
import com.google.android.gms.internal.ads.zzzs;
import com.google.android.gms.internal.ads.zzzw;
import com.google.android.gms.internal.ads.zzzy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;

public final class zzacy {
    private final ArrayList<OnInitializationCompleteListener> zza;
    private final Object zzb;
    @GuardedBy(value="InternalMobileAds.class")
    private static zzacy zzc;
    @GuardedBy(value="lock")
    private zzabl zzd;
    private boolean zze;
    private boolean zzf;
    @Nullable
    private OnAdInspectorClosedListener zzg;
    @NonNull
    private RequestConfiguration zzh;
    private InitializationStatus zzi;

    private zzacy() {
        ArrayList arrayList = new ArrayList();
        this.zzb = arrayList;
        this.zze = false;
        this.zzf = false;
        this.zzg = null;
        arrayList = new ArrayList();
        this.zzh = ((RequestConfiguration.Builder)((Object)arrayList)).build();
        arrayList = new ArrayList();
        this.zza = arrayList;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static zzacy zza() {
        Class<zzacy> clazz = zzacy.class;
        synchronized (clazz) {
            zzacy zzacy2 = zzc;
            if (zzacy2 != null) return zzc;
            zzc = zzacy2 = new zzacy();
            return zzc;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void zzb(Context object, @Nullable String object2, @Nullable OnInitializationCompleteListener onInitializationCompleteListener) {
        object2 = ((zzacy)object3).zzb;
        synchronized (object2) {
            block14: {
                boolean bl = ((zzacy)object3).zze;
                if (bl) {
                    if (onInitializationCompleteListener != null) {
                        zzacy.zza().zza.add(onInitializationCompleteListener);
                    }
                    return;
                }
                bl = ((zzacy)object3).zzf;
                if (bl) {
                    if (onInitializationCompleteListener != null) {
                        onInitializationCompleteListener.onInitializationComplete(((zzacy)object3).zzj());
                    }
                    return;
                }
                ((zzacy)object3).zze = true;
                if (onInitializationCompleteListener != null) {
                    zzacy.zza().zza.add(onInitializationCompleteListener);
                }
                if (object == null) {
                    Object object3 = new IllegalArgumentException("Context cannot be null.");
                    throw object3;
                }
                try {
                    zzhx zzhx2;
                    zzapu.zza().zzb((Context)object, null);
                    super.zzw((Context)object);
                    if (onInitializationCompleteListener != null) {
                        zzabl zzabl2 = ((zzacy)object3).zzd;
                        zzhx2 = new zzacx((zzacy)object3, null);
                        zzabl2.zzp((zzamq)zzhx2);
                    }
                    zzabl zzabl3 = ((zzacy)object3).zzd;
                    zzhx2 = new zzapy();
                    zzabl3.zzo((zzaqb)zzhx2);
                    ((zzacy)object3).zzd.zze();
                    zzabl3 = ((zzacy)object3).zzd;
                    zzabl3.zzj(null, ObjectWrapper.wrap(null));
                    int n = ((zzacy)object3).zzh.getTagForChildDirectedTreatment();
                    if (n != -1 || (n = ((zzacy)object3).zzh.getTagForUnderAgeOfConsent()) != -1) {
                        super.zzv(((zzacy)object3).zzh);
                    }
                    zzaeq.zza(object);
                    object = zzaeq.zzdA;
                    boolean bl2 = (Boolean)zzaaa.zzc().zzb(object);
                    if (bl2 || (bl2 = ((zzacy)object3).zzh().endsWith("0"))) break block14;
                    zzbbk.zzf("Google Mobile Ads SDK initialization functionality unavailable for this session. Ad requests can be made at any time.");
                    zzacu zzacu2 = new zzacu((zzacy)object3);
                    ((zzacy)object3).zzi = zzacu2;
                    if (onInitializationCompleteListener != null) {
                        zzacu2 = zzbbd.zza;
                        zzact zzact2 = new zzact((zzacy)object3, onInitializationCompleteListener);
                        zzacu2.post(zzact2);
                    }
                }
                catch (RemoteException remoteException) {
                    zzbbk.zzj("MobileAdsSettingManager initialization failed", remoteException);
                }
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void zzc(float f) {
        boolean bl = !(f < 0.0f) ? f <= 1.0f : false;
        Preconditions.checkArgument((boolean)bl, (Object)"The app volume must be a value between 0 and 1 inclusive.");
        Object object = this.zzb;
        synchronized (object) {
            zzabl zzabl2 = this.zzd;
            boolean bl2 = zzabl2 != null;
            Preconditions.checkState((boolean)bl2, (Object)"MobileAds.initialize() must be called prior to setting the app volume.");
            try {
                this.zzd.zzf(f);
            }
            catch (RemoteException remoteException) {
                zzbbk.zzg("Unable to set app volume.", remoteException);
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final float zzd() {
        Object object = ((zzacy)((Object)zzabl2)).zzb;
        synchronized (object) {
            zzabl zzabl2 = ((zzacy)((Object)zzabl2)).zzd;
            if (zzabl2 == null) {
                return 1.0f;
            }
            try {
                return zzabl2.zzk();
            }
            catch (RemoteException remoteException) {
                zzbbk.zzg("Unable to get app volume.", remoteException);
                return 1.0f;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void zze(boolean bl) {
        Object object = this.zzb;
        synchronized (object) {
            zzabl zzabl2 = this.zzd;
            boolean bl2 = zzabl2 != null;
            String string = "MobileAds.initialize() must be called prior to setting app muted state.";
            Preconditions.checkState((boolean)bl2, (Object)string);
            try {
                this.zzd.zzh(bl);
            }
            catch (RemoteException remoteException) {
                zzbbk.zzg("Unable to set app mute state.", remoteException);
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final boolean zzf() {
        Object object = ((zzacy)((Object)zzabl2)).zzb;
        synchronized (object) {
            zzabl zzabl2 = ((zzacy)((Object)zzabl2)).zzd;
            if (zzabl2 == null) {
                return false;
            }
            try {
                return zzabl2.zzl();
            }
            catch (RemoteException remoteException) {
                zzbbk.zzg("Unable to get app mute state.", remoteException);
                return false;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void zzg(Context context, String string) {
        Object object = ((zzacy)((Object)zzabl3)).zzb;
        synchronized (object) {
            zzabl zzabl2 = ((zzacy)((Object)zzabl3)).zzd;
            boolean bl = zzabl2 != null;
            String string2 = "MobileAds.initialize() must be called prior to opening debug menu.";
            Preconditions.checkState((boolean)bl, (Object)string2);
            try {
                zzabl zzabl3 = ((zzacy)((Object)zzabl3)).zzd;
                zzabl3.zzi(ObjectWrapper.wrap((Object)context), string);
            }
            catch (RemoteException remoteException) {
                zzbbk.zzg("Unable to open debug menu.", remoteException);
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final String zzh() {
        Object object = ((zzacy)this).zzb;
        synchronized (object) {
            zzabl zzabl2 = ((zzacy)this).zzd;
            boolean bl = zzabl2 != null;
            String string = "MobileAds.initialize() must be called prior to getting version string.";
            Preconditions.checkState((boolean)bl, (Object)string);
            try {
                return zzecs.zza(((zzacy)this).zzd.zzm());
            }
            catch (RemoteException remoteException) {
                zzbbk.zzg("Unable to get version string.", remoteException);
                return "";
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void zzi(Class<? extends RtbAdapter> clazz) {
        Object object = this.zzb;
        synchronized (object) {
            try {
                this.zzd.zzn(clazz.getCanonicalName());
            }
            catch (RemoteException remoteException) {
                zzbbk.zzg("Unable to register RtbAdapter", remoteException);
            }
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final InitializationStatus zzj() {
        Object object = this.zzb;
        synchronized (object) {
            InitializationStatus initializationStatus;
            zzabl zzabl2 = this.zzd;
            boolean bl = zzabl2 != null;
            String string = "MobileAds.initialize() must be called prior to getting initialization status.";
            Preconditions.checkState((boolean)bl, (Object)string);
            try {
                initializationStatus = this.zzi;
                if (initializationStatus == null) return zzacy.zzx(this.zzd.zzq());
            }
            catch (RemoteException remoteException) {
                zzbbk.zzf("Unable to get Initialization status.");
                return new zzacu(this);
            }
            return initializationStatus;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void zzk(Context context) {
        Object object = this.zzb;
        synchronized (object) {
            this.zzw(context);
            try {
                this.zzd.zzs();
            }
            catch (RemoteException remoteException) {
                zzbbk.zzf("Unable to disable mediation adapter initialization.");
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void zzl(Context object, OnAdInspectorClosedListener onAdInspectorClosedListener) {
        Object object2 = ((zzacy)object3).zzb;
        synchronized (object2) {
            block5: {
                Object object3;
                ((zzacy)object3).zzw((Context)object);
                zzacy.zza().zzg = onAdInspectorClosedListener;
                try {
                    object3 = ((zzacy)object3).zzd;
                    object = new zzacw(null);
                    object3.zzt((zzabx)object);
                }
                catch (RemoteException remoteException) {
                    zzbbk.zzf("Unable to open the ad inspector.");
                    if (onAdInspectorClosedListener == null) break block5;
                    object3 = new AdInspectorError(0, "Ad inspector had an internal error.", "com.google.android.gms.ads");
                    onAdInspectorClosedListener.onAdInspectorClosed((AdInspectorError)object3);
                }
            }
            return;
        }
    }

    @NonNull
    public final RequestConfiguration zzm() {
        return this.zzh;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void zzn(@NonNull RequestConfiguration requestConfiguration) {
        boolean bl = requestConfiguration != null;
        Preconditions.checkArgument((boolean)bl, (Object)"Null passed to setRequestConfiguration.");
        Object object = this.zzb;
        synchronized (object) {
            int n;
            RequestConfiguration requestConfiguration2 = this.zzh;
            this.zzh = requestConfiguration;
            zzabl zzabl2 = this.zzd;
            if (zzabl2 == null) {
                return;
            }
            int n2 = requestConfiguration2.getTagForChildDirectedTreatment();
            if (n2 == (n = requestConfiguration.getTagForChildDirectedTreatment())) {
                int n3 = requestConfiguration2.getTagForUnderAgeOfConsent();
                if (n3 == (n2 = requestConfiguration.getTagForUnderAgeOfConsent())) return;
            }
            this.zzv(requestConfiguration);
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void zzo(@NonNull WebView webView) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        Object object = ((zzacy)object).zzb;
        synchronized (object) {
            if (webView == null) {
                zzbbk.zzf("The webview to be registered cannot be null.");
                return;
            }
            zzbag zzbag2 = zzava.zza(webView.getContext());
            if (zzbag2 == null) {
                zzbbk.zzi("Internal error, query info generator is null.");
                return;
            }
            try {
                zzbag2.zzj(ObjectWrapper.wrap((Object)webView));
            }
            catch (RemoteException remoteException) {
                zzbbk.zzg("", remoteException);
            }
            return;
        }
    }

    @GuardedBy(value="lock")
    private final void zzv(@NonNull RequestConfiguration requestConfiguration) {
        try {
            zzabl zzabl2 = ((zzacy)((Object)zzabl2)).zzd;
            zzads zzads2 = new zzads(requestConfiguration);
            zzabl2.zzr(zzads2);
            return;
        }
        catch (RemoteException remoteException) {
            zzbbk.zzg("Unable to set request configuration parcel.", remoteException);
            return;
        }
    }

    @GuardedBy(value="lock")
    private final void zzw(Context context) {
        if (this.zzd == null) {
            zzzw zzzw2 = zzzy.zzb();
            zzzs zzzs2 = new zzzs(zzzw2, context);
            this.zzd = (zzabl)zzzs2.zzd(context, false);
            return;
        }
    }

    final /* synthetic */ void zzp(OnInitializationCompleteListener onInitializationCompleteListener) {
        onInitializationCompleteListener.onInitializationComplete(this.zzi);
    }

    static /* synthetic */ boolean zzq(zzacy zzacy2, boolean bl) {
        zzacy2.zze = false;
        return false;
    }

    static /* synthetic */ boolean zzr(zzacy zzacy2, boolean bl) {
        zzacy2.zzf = true;
        return true;
    }

    static /* synthetic */ InitializationStatus zzs(zzacy zzacy2, List list) {
        return zzacy.zzx(list);
    }

    static /* synthetic */ ArrayList zzt(zzacy zzacy2) {
        return zzacy2.zza;
    }

    static /* synthetic */ OnAdInspectorClosedListener zzu(zzacy zzacy2) {
        return zzacy2.zzg;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private static final InitializationStatus zzx(List<zzamj> object) {
        HashMap<String, AdapterStatus> hashMap = new HashMap<String, AdapterStatus>();
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            void var0_3;
            zzamj zzamj2 = (zzamj)((Object)iterator.next());
            String string = zzamj2.zza;
            if (zzamj2.zzb) {
                AdapterStatus.State state = AdapterStatus.State.READY;
            } else {
                AdapterStatus.State state = AdapterStatus.State.NOT_READY;
            }
            zzamr zzamr2 = new zzamr((AdapterStatus.State)var0_3, zzamj2.zzd, zzamj2.zzc);
            hashMap.put(string, zzamr2);
        }
        return new zzams(hashMap);
    }
}

