/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.content.Context;
import android.net.Uri;
import android.os.Build;
import android.os.RemoteException;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.google.android.gms.ads.h5.OnH5AdsEventListener;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.ads.zzaaa;
import com.google.android.gms.internal.ads.zzaei;
import com.google.android.gms.internal.ads.zzaeq;
import com.google.android.gms.internal.ads.zzaln;
import com.google.android.gms.internal.ads.zzapy;
import com.google.android.gms.internal.ads.zzbbk;
import com.google.android.gms.internal.ads.zzzw;
import com.google.android.gms.internal.ads.zzzy;

@RequiresApi(api=21)
public final class zzalr {
    private final Context zza;
    private final OnH5AdsEventListener zzb;
    @Nullable
    private zzaln zzc;

    /*
     * Enabled aggressive block sorting
     */
    public zzalr(Context context, OnH5AdsEventListener onH5AdsEventListener) {
        boolean bl = Build.VERSION.SDK_INT >= 21;
        Preconditions.checkState((boolean)bl, (Object)"Android version must be Lollipop or higher");
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)onH5AdsEventListener);
        this.zza = context;
        this.zzb = onH5AdsEventListener;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean zza(String string) {
        if (!zzalr.zzc(string)) {
            return false;
        }
        ((zzalr)((Object)zzaln2)).zzd();
        zzaln zzaln2 = ((zzalr)((Object)zzaln2)).zzc;
        if (zzaln2 == null) return false;
        try {
            zzaln2.zze(string);
            return true;
        }
        catch (RemoteException remoteException) {
            zzbbk.zzl("#007 Could not call remote method.", remoteException);
            return true;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void zzb() {
        zzaei<Boolean> zzaei2 = zzaeq.zzgf;
        if (!zzaaa.zzc().zzb(zzaei2).booleanValue()) {
            return;
        }
        ((zzalr)((Object)zzaln2)).zzd();
        zzaln zzaln2 = ((zzalr)((Object)zzaln2)).zzc;
        if (zzaln2 == null) return;
        try {
            zzaln2.zzf();
            return;
        }
        catch (RemoteException remoteException) {
            zzbbk.zzl("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    private final void zzd() {
        if (this.zzc != null) {
            return;
        }
        zzzw zzzw2 = zzzy.zzb();
        Context context = this.zza;
        zzapy zzapy2 = new zzapy();
        this.zzc = zzzw2.zzj(context, zzapy2, this.zzb);
    }

    public static final boolean zzc(String string) {
        zzaei<Boolean> zzaei2 = zzaeq.zzgf;
        if (!zzaaa.zzc().zzb(zzaei2).booleanValue()) {
            return false;
        }
        Preconditions.checkNotNull((Object)string);
        int n = string.length();
        zzaei<Integer> zzaei3 = zzaeq.zzgh;
        if (n > zzaaa.zzc().zzb(zzaei3)) {
            zzbbk.zzd("H5 GMSG exceeds max length");
            return false;
        }
        return "gmsg".equals((string = Uri.parse((String)string)).getScheme()) && "mobileads.google.com".equals(string.getHost()) && "/h5ads".equals(string.getPath());
    }
}

