/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.content.Context;
import android.os.RemoteException;
import android.webkit.WebView;
import androidx.annotation.NonNull;
import com.google.android.gms.ads.AdInspectorError;
import com.google.android.gms.ads.OnAdInspectorClosedListener;
import com.google.android.gms.ads.RequestConfiguration;
import com.google.android.gms.ads.initialization.AdapterStatus;
import com.google.android.gms.ads.initialization.InitializationStatus;
import com.google.android.gms.ads.initialization.OnInitializationCompleteListener;
import com.google.android.gms.ads.mediation.rtb.RtbAdapter;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.dynamic.ObjectWrapper;
import com.google.android.gms.internal.ads.zzbeb;
import com.google.android.gms.internal.ads.zzbeh;
import com.google.android.gms.internal.ads.zzbej;
import com.google.android.gms.internal.ads.zzbel;
import com.google.android.gms.internal.ads.zzbfw;
import com.google.android.gms.internal.ads.zzbgi;
import com.google.android.gms.internal.ads.zzbhe;
import com.google.android.gms.internal.ads.zzbhf;
import com.google.android.gms.internal.ads.zzbhh;
import com.google.android.gms.internal.ads.zzbhi;
import com.google.android.gms.internal.ads.zzbid;
import com.google.android.gms.internal.ads.zzbjb;
import com.google.android.gms.internal.ads.zzbra;
import com.google.android.gms.internal.ads.zzbrh;
import com.google.android.gms.internal.ads.zzbri;
import com.google.android.gms.internal.ads.zzbrj;
import com.google.android.gms.internal.ads.zzbuo;
import com.google.android.gms.internal.ads.zzbus;
import com.google.android.gms.internal.ads.zzbuv;
import com.google.android.gms.internal.ads.zzbzw;
import com.google.android.gms.internal.ads.zzcfc;
import com.google.android.gms.internal.ads.zzcfz;
import com.google.android.gms.internal.ads.zzcgg;
import com.google.android.gms.internal.ads.zzflc;
import com.google.android.gms.internal.ads.zzow;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;

public final class zzbhj {
    private final ArrayList<OnInitializationCompleteListener> zza;
    private final Object zzb;
    @GuardedBy(value="InternalMobileAds.class")
    private static zzbhj zzc;
    @GuardedBy(value="lock")
    private zzbfw zzd;
    private boolean zze;
    private boolean zzf;
    @Nullable
    private OnAdInspectorClosedListener zzg;
    @NonNull
    private RequestConfiguration zzh;
    private InitializationStatus zzi;

    private zzbhj() {
        ArrayList arrayList = new ArrayList();
        this.zzb = arrayList;
        this.zze = false;
        this.zzf = false;
        this.zzg = null;
        arrayList = new ArrayList();
        this.zzh = ((RequestConfiguration.Builder)((Object)arrayList)).build();
        arrayList = new ArrayList();
        this.zza = arrayList;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static zzbhj zza() {
        Class<zzbhj> clazz = zzbhj.class;
        synchronized (clazz) {
            zzbhj zzbhj2 = zzc;
            if (zzbhj2 != null) return zzc;
            zzc = zzbhj2 = new zzbhj();
            return zzc;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void zzb(Context object, @Nullable String object2, @Nullable OnInitializationCompleteListener onInitializationCompleteListener) {
        object2 = ((zzbhj)object3).zzb;
        synchronized (object2) {
            block14: {
                boolean bl = ((zzbhj)object3).zze;
                if (bl) {
                    if (onInitializationCompleteListener != null) {
                        zzbhj.zza().zza.add(onInitializationCompleteListener);
                    }
                    return;
                }
                bl = ((zzbhj)object3).zzf;
                if (bl) {
                    if (onInitializationCompleteListener != null) {
                        onInitializationCompleteListener.onInitializationComplete(((zzbhj)object3).zzj());
                    }
                    return;
                }
                ((zzbhj)object3).zze = true;
                if (onInitializationCompleteListener != null) {
                    zzbhj.zza().zza.add(onInitializationCompleteListener);
                }
                if (object == null) {
                    Object object3 = new IllegalArgumentException("Context cannot be null.");
                    throw object3;
                }
                try {
                    zzow zzow2;
                    zzbuo.zza().zzb((Context)object, null);
                    super.zzw((Context)object);
                    if (onInitializationCompleteListener != null) {
                        zzbfw zzbfw2 = ((zzbhj)object3).zzd;
                        zzow2 = new zzbhi((zzbhj)object3, null);
                        zzbfw2.zzp((zzbrh)zzow2);
                    }
                    zzbfw zzbfw3 = ((zzbhj)object3).zzd;
                    zzow2 = new zzbus();
                    zzbfw3.zzo((zzbuv)zzow2);
                    ((zzbhj)object3).zzd.zze();
                    ((zzbhj)object3).zzd.zzj(null, ObjectWrapper.wrap(null));
                    int n = ((zzbhj)object3).zzh.getTagForChildDirectedTreatment();
                    if (n != -1 || (n = ((zzbhj)object3).zzh.getTagForUnderAgeOfConsent()) != -1) {
                        super.zzv(((zzbhj)object3).zzh);
                    }
                    zzbjb.zza(object);
                    object = zzbjb.zzdJ;
                    boolean bl2 = (Boolean)zzbel.zzc().zzb(object);
                    if (bl2 || (bl2 = ((zzbhj)object3).zzh().endsWith("0"))) break block14;
                    zzcgg.zzf("Google Mobile Ads SDK initialization functionality unavailable for this session. Ad requests can be made at any time.");
                    zzbhf zzbhf2 = new zzbhf((zzbhj)object3);
                    ((zzbhj)object3).zzi = zzbhf2;
                    if (onInitializationCompleteListener != null) {
                        zzbhf2 = zzcfz.zza;
                        zzbhe zzbhe2 = new zzbhe((zzbhj)object3, onInitializationCompleteListener);
                        zzbhf2.post(zzbhe2);
                    }
                }
                catch (RemoteException remoteException) {
                    zzcgg.zzj("MobileAdsSettingManager initialization failed", remoteException);
                }
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void zzc(float f) {
        boolean bl = !(f < 0.0f) ? f <= 1.0f : false;
        Preconditions.checkArgument((boolean)bl, (Object)"The app volume must be a value between 0 and 1 inclusive.");
        Object object = this.zzb;
        synchronized (object) {
            zzbfw zzbfw2 = this.zzd;
            boolean bl2 = zzbfw2 != null;
            Preconditions.checkState((boolean)bl2, (Object)"MobileAds.initialize() must be called prior to setting the app volume.");
            try {
                this.zzd.zzf(f);
            }
            catch (RemoteException remoteException) {
                zzcgg.zzg("Unable to set app volume.", remoteException);
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final float zzd() {
        Object object = ((zzbhj)((Object)zzbfw2)).zzb;
        synchronized (object) {
            zzbfw zzbfw2 = ((zzbhj)((Object)zzbfw2)).zzd;
            if (zzbfw2 == null) {
                return 1.0f;
            }
            try {
                return zzbfw2.zzk();
            }
            catch (RemoteException remoteException) {
                zzcgg.zzg("Unable to get app volume.", remoteException);
                return 1.0f;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void zze(boolean bl) {
        Object object = this.zzb;
        synchronized (object) {
            zzbfw zzbfw2 = this.zzd;
            boolean bl2 = zzbfw2 != null;
            Preconditions.checkState((boolean)bl2, (Object)"MobileAds.initialize() must be called prior to setting app muted state.");
            try {
                this.zzd.zzh(bl);
            }
            catch (RemoteException remoteException) {
                zzcgg.zzg("Unable to set app mute state.", remoteException);
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final boolean zzf() {
        Object object = ((zzbhj)((Object)zzbfw2)).zzb;
        synchronized (object) {
            zzbfw zzbfw2 = ((zzbhj)((Object)zzbfw2)).zzd;
            if (zzbfw2 == null) {
                return false;
            }
            try {
                return zzbfw2.zzl();
            }
            catch (RemoteException remoteException) {
                zzcgg.zzg("Unable to get app mute state.", remoteException);
                return false;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void zzg(Context context, String string) {
        Object object = this.zzb;
        synchronized (object) {
            zzbfw zzbfw2 = this.zzd;
            boolean bl = zzbfw2 != null;
            Preconditions.checkState((boolean)bl, (Object)"MobileAds.initialize() must be called prior to opening debug menu.");
            try {
                this.zzd.zzi(ObjectWrapper.wrap((Object)context), string);
            }
            catch (RemoteException remoteException) {
                zzcgg.zzg("Unable to open debug menu.", remoteException);
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final String zzh() {
        Object object = ((zzbhj)this).zzb;
        synchronized (object) {
            zzbfw zzbfw2 = ((zzbhj)this).zzd;
            boolean bl = zzbfw2 != null;
            Preconditions.checkState((boolean)bl, (Object)"MobileAds.initialize() must be called prior to getting version string.");
            try {
                return zzflc.zza(((zzbhj)this).zzd.zzm());
            }
            catch (RemoteException remoteException) {
                zzcgg.zzg("Unable to get version string.", remoteException);
                return "";
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void zzi(Class<? extends RtbAdapter> clazz) {
        Object object = this.zzb;
        synchronized (object) {
            try {
                this.zzd.zzn(clazz.getCanonicalName());
            }
            catch (RemoteException remoteException) {
                zzcgg.zzg("Unable to register RtbAdapter", remoteException);
            }
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final InitializationStatus zzj() {
        Object object = this.zzb;
        synchronized (object) {
            InitializationStatus initializationStatus;
            zzbfw zzbfw2 = this.zzd;
            boolean bl = zzbfw2 != null;
            Preconditions.checkState((boolean)bl, (Object)"MobileAds.initialize() must be called prior to getting initialization status.");
            try {
                initializationStatus = this.zzi;
                if (initializationStatus == null) return zzbhj.zzx(this.zzd.zzq());
            }
            catch (RemoteException remoteException) {
                zzcgg.zzf("Unable to get Initialization status.");
                return new zzbhf(this);
            }
            return initializationStatus;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void zzk(Context context) {
        Object object = this.zzb;
        synchronized (object) {
            this.zzw(context);
            try {
                this.zzd.zzs();
            }
            catch (RemoteException remoteException) {
                zzcgg.zzf("Unable to disable mediation adapter initialization.");
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void zzl(Context object, OnAdInspectorClosedListener onAdInspectorClosedListener) {
        Object object2 = ((zzbhj)object3).zzb;
        synchronized (object2) {
            block5: {
                Object object3;
                ((zzbhj)object3).zzw((Context)object);
                zzbhj.zza().zzg = onAdInspectorClosedListener;
                try {
                    object3 = ((zzbhj)object3).zzd;
                    object = new zzbhh(null);
                    object3.zzt((zzbgi)object);
                }
                catch (RemoteException remoteException) {
                    zzcgg.zzf("Unable to open the ad inspector.");
                    if (onAdInspectorClosedListener == null) break block5;
                    object3 = new AdInspectorError(0, "Ad inspector had an internal error.", "com.google.android.gms.ads");
                    onAdInspectorClosedListener.onAdInspectorClosed((AdInspectorError)object3);
                }
            }
            return;
        }
    }

    @NonNull
    public final RequestConfiguration zzm() {
        return this.zzh;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void zzn(@NonNull RequestConfiguration requestConfiguration) {
        boolean bl = requestConfiguration != null;
        Preconditions.checkArgument((boolean)bl, (Object)"Null passed to setRequestConfiguration.");
        Object object = this.zzb;
        synchronized (object) {
            int n;
            RequestConfiguration requestConfiguration2 = this.zzh;
            this.zzh = requestConfiguration;
            zzbfw zzbfw2 = this.zzd;
            if (zzbfw2 == null) {
                return;
            }
            int n2 = requestConfiguration2.getTagForChildDirectedTreatment();
            if (n2 == (n = requestConfiguration.getTagForChildDirectedTreatment())) {
                int n3 = requestConfiguration2.getTagForUnderAgeOfConsent();
                if (n3 == (n2 = requestConfiguration.getTagForUnderAgeOfConsent())) return;
            }
            this.zzv(requestConfiguration);
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void zzo(@NonNull WebView webView) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        Object object = ((zzbhj)object).zzb;
        synchronized (object) {
            if (webView == null) {
                zzcgg.zzf("The webview to be registered cannot be null.");
                return;
            }
            zzcfc zzcfc2 = zzbzw.zza(webView.getContext());
            if (zzcfc2 == null) {
                zzcgg.zzi("Internal error, query info generator is null.");
                return;
            }
            try {
                zzcfc2.zzj(ObjectWrapper.wrap((Object)webView));
            }
            catch (RemoteException remoteException) {
                zzcgg.zzg("", remoteException);
            }
            return;
        }
    }

    @GuardedBy(value="lock")
    private final void zzv(@NonNull RequestConfiguration requestConfiguration) {
        try {
            zzbfw zzbfw2 = ((zzbhj)((Object)zzbfw2)).zzd;
            zzbid zzbid2 = new zzbid(requestConfiguration);
            zzbfw2.zzr(zzbid2);
            return;
        }
        catch (RemoteException remoteException) {
            zzcgg.zzg("Unable to set request configuration parcel.", remoteException);
            return;
        }
    }

    @GuardedBy(value="lock")
    private final void zzw(Context context) {
        if (this.zzd == null) {
            zzbeh zzbeh2 = zzbej.zzb();
            zzbeb zzbeb2 = new zzbeb(zzbeh2, context);
            this.zzd = (zzbfw)zzbeb2.zzd(context, false);
            return;
        }
    }

    final /* synthetic */ void zzp(OnInitializationCompleteListener onInitializationCompleteListener) {
        onInitializationCompleteListener.onInitializationComplete(this.zzi);
    }

    static /* synthetic */ boolean zzq(zzbhj zzbhj2, boolean bl) {
        zzbhj2.zze = false;
        return false;
    }

    static /* synthetic */ boolean zzr(zzbhj zzbhj2, boolean bl) {
        zzbhj2.zzf = true;
        return true;
    }

    static /* synthetic */ InitializationStatus zzs(zzbhj zzbhj2, List list) {
        return zzbhj.zzx(list);
    }

    static /* synthetic */ ArrayList zzt(zzbhj zzbhj2) {
        return zzbhj2.zza;
    }

    static /* synthetic */ OnAdInspectorClosedListener zzu(zzbhj zzbhj2) {
        return zzbhj2.zzg;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private static final InitializationStatus zzx(List<zzbra> object) {
        HashMap<String, AdapterStatus> hashMap = new HashMap<String, AdapterStatus>();
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            void var0_3;
            zzbra zzbra2 = (zzbra)((Object)iterator.next());
            String string = zzbra2.zza;
            if (zzbra2.zzb) {
                AdapterStatus.State state = AdapterStatus.State.READY;
            } else {
                AdapterStatus.State state = AdapterStatus.State.NOT_READY;
            }
            zzbri zzbri2 = new zzbri((AdapterStatus.State)var0_3, zzbra2.zzd, zzbra2.zzc);
            hashMap.put(string, zzbri2);
        }
        return new zzbrj(hashMap);
    }
}

