/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.content.Context;
import android.net.Uri;
import android.os.Build;
import android.os.RemoteException;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.google.android.gms.ads.h5.OnH5AdsEventListener;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.ads.zzbeh;
import com.google.android.gms.internal.ads.zzbej;
import com.google.android.gms.internal.ads.zzbel;
import com.google.android.gms.internal.ads.zzbit;
import com.google.android.gms.internal.ads.zzbjb;
import com.google.android.gms.internal.ads.zzbqe;
import com.google.android.gms.internal.ads.zzbus;
import com.google.android.gms.internal.ads.zzcgg;

@RequiresApi(api=21)
public final class zzbqi {
    private final Context zza;
    private final OnH5AdsEventListener zzb;
    @Nullable
    private zzbqe zzc;

    /*
     * Enabled aggressive block sorting
     */
    public zzbqi(Context context, OnH5AdsEventListener onH5AdsEventListener) {
        boolean bl = Build.VERSION.SDK_INT >= 21;
        Preconditions.checkState((boolean)bl, (Object)"Android version must be Lollipop or higher");
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)onH5AdsEventListener);
        this.zza = context;
        this.zzb = onH5AdsEventListener;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean zza(String string) {
        if (!zzbqi.zzc(string)) {
            return false;
        }
        ((zzbqi)((Object)zzbqe2)).zzd();
        zzbqe zzbqe2 = ((zzbqi)((Object)zzbqe2)).zzc;
        if (zzbqe2 == null) return false;
        try {
            zzbqe2.zze(string);
            return true;
        }
        catch (RemoteException remoteException) {
            zzcgg.zzl("#007 Could not call remote method.", remoteException);
            return true;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void zzb() {
        zzbit<Boolean> zzbit2 = zzbjb.zzgz;
        if (!zzbel.zzc().zzb(zzbit2).booleanValue()) {
            return;
        }
        ((zzbqi)((Object)zzbqe2)).zzd();
        zzbqe zzbqe2 = ((zzbqi)((Object)zzbqe2)).zzc;
        if (zzbqe2 == null) return;
        try {
            zzbqe2.zzf();
            return;
        }
        catch (RemoteException remoteException) {
            zzcgg.zzl("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    private final void zzd() {
        if (this.zzc != null) {
            return;
        }
        zzbeh zzbeh2 = zzbej.zzb();
        Context context = this.zza;
        zzbus zzbus2 = new zzbus();
        this.zzc = zzbeh2.zzj(context, zzbus2, this.zzb);
    }

    public static final boolean zzc(String string) {
        zzbit<Boolean> zzbit2 = zzbjb.zzgz;
        if (!zzbel.zzc().zzb(zzbit2).booleanValue()) {
            return false;
        }
        Preconditions.checkNotNull((Object)string);
        int n = string.length();
        zzbit<Integer> zzbit3 = zzbjb.zzgB;
        if (n > zzbel.zzc().zzb(zzbit3)) {
            zzcgg.zzd("H5 GMSG exceeds max length");
            return false;
        }
        return "gmsg".equals((string = Uri.parse((String)string)).getScheme()) && "mobileads.google.com".equals(string.getHost()) && "/h5ads".equals(string.getPath());
    }
}

