/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads;

import android.content.Context;
import android.os.RemoteException;
import androidx.annotation.Nullable;
import androidx.annotation.RecentlyNonNull;
import androidx.annotation.RequiresPermission;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.VideoOptions;
import com.google.android.gms.ads.admanager.AdManagerAdRequest;
import com.google.android.gms.ads.formats.AdManagerAdViewOptions;
import com.google.android.gms.ads.formats.NativeCustomTemplateAd;
import com.google.android.gms.ads.formats.OnAdManagerAdViewLoadedListener;
import com.google.android.gms.ads.formats.UnifiedNativeAd;
import com.google.android.gms.ads.nativead.NativeAd;
import com.google.android.gms.ads.nativead.NativeAdOptions;
import com.google.android.gms.ads.nativead.NativeCustomFormatAd;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.ads.zzbey;
import com.google.android.gms.internal.ads.zzbfh;
import com.google.android.gms.internal.ads.zzbfi;
import com.google.android.gms.internal.ads.zzbgm;
import com.google.android.gms.internal.ads.zzbgo;
import com.google.android.gms.internal.ads.zzbhd;
import com.google.android.gms.internal.ads.zzbhg;
import com.google.android.gms.internal.ads.zzbjg;
import com.google.android.gms.internal.ads.zzbjz;
import com.google.android.gms.internal.ads.zzbkq;
import com.google.android.gms.internal.ads.zzbnw;
import com.google.android.gms.internal.ads.zzbqn;
import com.google.android.gms.internal.ads.zzbqp;
import com.google.android.gms.internal.ads.zzbqq;
import com.google.android.gms.internal.ads.zzbxe;
import com.google.android.gms.internal.ads.zzcba;
import com.google.android.gms.internal.ads.zzcbc;
import com.google.android.gms.internal.ads.zzciz;

public class AdLoader {
    private final zzbfh zza;
    private final Context zzb;
    private final zzbhd zzc;

    /*
     * WARNING - void declaration
     */
    @RequiresPermission(value="android.permission.INTERNET")
    public void loadAd(@RecentlyNonNull AdRequest adRequest) {
        void var1_1;
        this.zza(var1_1.zza());
    }

    /*
     * WARNING - void declaration
     */
    public void loadAd(@RecentlyNonNull AdManagerAdRequest adManagerAdRequest) {
        void var1_1;
        this.zza(var1_1.zza);
    }

    /*
     * WARNING - void declaration
     */
    @RequiresPermission(value="android.permission.INTERNET")
    public void loadAds(@RecentlyNonNull AdRequest adRequest, int maxNumberOfAds) {
        zzbjg zzbjg2 = adRequest.zza();
        try {
            void var2_3;
            this.zzc.zzh(this.zza.zza(this.zzb, zzbjg2), (int)var2_3);
            return;
        }
        catch (RemoteException remoteException) {
            zzciz.zzh("Failed to load ads.", remoteException);
            return;
        }
    }

    public boolean isLoading() {
        try {
            boolean bl = this.zzc.zzi();
            return bl;
        }
        catch (RemoteException remoteException) {
            zzciz.zzk("Failed to check if ad is loading.", remoteException);
            return false;
        }
    }

    AdLoader(Context context, zzbhd zzbhd2, zzbfh zzbfh2) {
        this.zzb = context;
        this.zzc = zzbhd2;
        this.zza = zzbfh2;
    }

    private final void zza(zzbjg zzbjg2) {
        try {
            this.zzc.zzg(this.zza.zza(this.zzb, zzbjg2));
            return;
        }
        catch (RemoteException remoteException) {
            zzciz.zzh("Failed to load ad.", remoteException);
            return;
        }
    }

    public static class Builder {
        private final Context zza;
        private final zzbhg zzb;

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @RecentlyNonNull
        public Builder forAdManagerAdView(@RecentlyNonNull OnAdManagerAdViewLoadedListener listener, AdSize ... adSizes) {
            zzbhg zzbhg2;
            if (adSizes == null || ((void)zzbhg2).length <= 0) {
                Object object = new IllegalArgumentException("The supported ad sizes must contain at least one valid ad size.");
                throw object;
            }
            try {
                void var1_1;
                zzbfi zzbfi2 = new zzbfi(((Builder)object).zza, (AdSize[])zzbhg2);
                zzbhg2 = ((Builder)object).zzb;
                zzbqp zzbqp2 = new zzbqp((OnAdManagerAdViewLoadedListener)var1_1);
                zzbhg2.zzj(zzbqp2, zzbfi2);
                return object;
            }
            catch (RemoteException remoteException) {
                zzciz.zzk("Failed to add Google Ad Manager banner ad listener", remoteException);
                return object;
            }
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @RecentlyNonNull
        public Builder forCustomFormatAd(@RecentlyNonNull String customFormatId, @RecentlyNonNull NativeCustomFormatAd.OnCustomFormatAdLoadedListener adLoadedListener, @Nullable NativeCustomFormatAd.OnCustomClickListener customClickListener) {
            void var3_4;
            void var2_3;
            zzcba zzcba2 = new zzcba((NativeCustomFormatAd.OnCustomFormatAdLoadedListener)var2_3, (NativeCustomFormatAd.OnCustomClickListener)var3_4);
            try {
                void var1_1;
                this.zzb.zzh((String)var1_1, zzcba2.zzb(), zzcba2.zza());
                return this;
            }
            catch (RemoteException remoteException) {
                zzciz.zzk("Failed to add custom format ad listener", remoteException);
                return this;
            }
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Deprecated
        @RecentlyNonNull
        public Builder forCustomTemplateAd(@RecentlyNonNull String templateId, @RecentlyNonNull NativeCustomTemplateAd.OnCustomTemplateAdLoadedListener adLoadedListener, @Nullable NativeCustomTemplateAd.OnCustomClickListener customClickListener) {
            void var3_4;
            void var2_3;
            zzbqn zzbqn2 = new zzbqn((NativeCustomTemplateAd.OnCustomTemplateAdLoadedListener)var2_3, (NativeCustomTemplateAd.OnCustomClickListener)var3_4);
            try {
                void var1_1;
                this.zzb.zzh((String)var1_1, zzbqn2.zze(), zzbqn2.zzd());
                return this;
            }
            catch (RemoteException remoteException) {
                zzciz.zzk("Failed to add custom template ad listener", remoteException);
                return this;
            }
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @RecentlyNonNull
        public Builder forNativeAd(@RecentlyNonNull NativeAd.OnNativeAdLoadedListener listener) {
            try {
                void var1_1;
                zzbhg zzbhg2 = this.zzb;
                zzcbc zzcbc2 = new zzcbc((NativeAd.OnNativeAdLoadedListener)var1_1);
                zzbhg2.zzk(zzcbc2);
                return this;
            }
            catch (RemoteException remoteException) {
                zzciz.zzk("Failed to add google native ad listener", remoteException);
                return this;
            }
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Deprecated
        @RecentlyNonNull
        public Builder forUnifiedNativeAd(@RecentlyNonNull UnifiedNativeAd.OnUnifiedNativeAdLoadedListener listener) {
            try {
                void var1_1;
                zzbhg zzbhg2 = this.zzb;
                zzbqq zzbqq2 = new zzbqq((UnifiedNativeAd.OnUnifiedNativeAdLoadedListener)var1_1);
                zzbhg2.zzk(zzbqq2);
                return this;
            }
            catch (RemoteException remoteException) {
                zzciz.zzk("Failed to add google native ad listener", remoteException);
                return this;
            }
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @RecentlyNonNull
        public Builder withAdListener(@RecentlyNonNull AdListener listener) {
            try {
                void var1_1;
                zzbhg zzbhg2 = this.zzb;
                zzbey zzbey2 = new zzbey((AdListener)var1_1);
                zzbhg2.zzl(zzbey2);
                return this;
            }
            catch (RemoteException remoteException) {
                zzciz.zzk("Failed to set AdListener.", remoteException);
                return this;
            }
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @RecentlyNonNull
        public Builder withAdManagerAdViewOptions(@RecentlyNonNull AdManagerAdViewOptions options) {
            try {
                void var1_1;
                this.zzb.zzm((AdManagerAdViewOptions)var1_1);
                return this;
            }
            catch (RemoteException remoteException) {
                zzciz.zzk("Failed to specify Ad Manager banner ad options", remoteException);
                return this;
            }
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Deprecated
        @RecentlyNonNull
        public Builder withNativeAdOptions(@RecentlyNonNull com.google.android.gms.ads.formats.NativeAdOptions options) {
            try {
                void var1_1;
                zzbhg zzbhg2 = this.zzb;
                zzbnw zzbnw2 = new zzbnw((com.google.android.gms.ads.formats.NativeAdOptions)var1_1);
                zzbhg2.zzo(zzbnw2);
                return this;
            }
            catch (RemoteException remoteException) {
                zzciz.zzk("Failed to specify native ad options", remoteException);
                return this;
            }
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @RecentlyNonNull
        public Builder withNativeAdOptions(@RecentlyNonNull NativeAdOptions options) {
            try {
                void var2_10;
                void var1_1;
                zzbhg zzbhg2 = this.zzb;
                boolean bl = var1_1.shouldReturnUrlsForImageAssets();
                boolean bl2 = var1_1.shouldRequestMultipleImages();
                int n = var1_1.getAdChoicesPlacement();
                VideoOptions videoOptions = var1_1.getVideoOptions();
                if (videoOptions != null) {
                    zzbkq zzbkq2 = new zzbkq(var1_1.getVideoOptions());
                } else {
                    Object var2_11 = null;
                }
                zzbnw zzbnw2 = new zzbnw(4, bl, -1, bl2, n, (zzbkq)var2_10, var1_1.zza(), var1_1.getMediaAspectRatio());
                zzbhg2.zzo(zzbnw2);
                return this;
            }
            catch (RemoteException remoteException) {
                zzciz.zzk("Failed to specify native ad options", remoteException);
                return this;
            }
        }

        @RecentlyNonNull
        public AdLoader build() {
            try {
                Context context = this.zza;
                zzbhd zzbhd2 = this.zzb.zze();
                AdLoader adLoader = new AdLoader(context, zzbhd2, zzbfh.zza);
                return adLoader;
            }
            catch (RemoteException remoteException) {
                zzciz.zzh("Failed to build AdLoader.", remoteException);
                zzbjz zzbjz2 = new zzbjz();
                AdLoader adLoader = new AdLoader(this.zza, zzbjz2.zzc(), zzbfh.zza);
                return adLoader;
            }
        }

        /*
         * WARNING - void declaration
         */
        public Builder(@RecentlyNonNull Context context, @RecentlyNonNull String adUnitID) {
            void var2_2;
            zzbhg zzbhg2;
            Object object = Preconditions.checkNotNull((Object)context, (Object)"context cannot be null");
            object = (Context)object;
            zzbgm zzbgm2 = zzbgo.zza();
            zzbxe zzbxe2 = new zzbxe();
            zzbhg2 = zzbgm2.zzc((Context)zzbhg2, (String)var2_2, zzbxe2);
            this.zza = object;
            this.zzb = zzbhg2;
        }
    }
}

