/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads;

import android.content.Context;
import android.util.DisplayMetrics;
import androidx.annotation.Nullable;
import androidx.annotation.RecentlyNonNull;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.ads.zzbfi;
import com.google.android.gms.internal.ads.zzbgo;
import com.google.android.gms.internal.ads.zzcis;
import com.google.android.gms.internal.ads.zzciz;

@VisibleForTesting
public final class AdSize {
    public static final int FULL_WIDTH = -1;
    public static final int AUTO_HEIGHT = -2;
    @RecentlyNonNull
    public static final AdSize BANNER;
    @RecentlyNonNull
    public static final AdSize FULL_BANNER;
    @RecentlyNonNull
    public static final AdSize LARGE_BANNER;
    @RecentlyNonNull
    public static final AdSize LEADERBOARD;
    @RecentlyNonNull
    public static final AdSize MEDIUM_RECTANGLE;
    @RecentlyNonNull
    public static final AdSize WIDE_SKYSCRAPER;
    @Deprecated
    @RecentlyNonNull
    public static final AdSize SMART_BANNER;
    @RecentlyNonNull
    public static final AdSize FLUID;
    @RecentlyNonNull
    public static final AdSize INVALID;
    @RecentlyNonNull
    public static final AdSize SEARCH;
    @RecentlyNonNull
    public static final AdSize zza;
    private final int zzb;
    private final int zzc;
    private final String zzd;
    private boolean zze;
    private boolean zzf;
    private int zzg;
    private boolean zzh;
    private int zzi;

    public int getHeight() {
        return this.zzc;
    }

    /*
     * WARNING - void declaration
     */
    public int getHeightInPixels(@RecentlyNonNull Context context) {
        switch (this.zzc) {
            default: {
                void var1_1;
                zzbgo.zzb();
                return zzcis.zzs((Context)var1_1, this.zzc);
            }
            case -2: {
                void var1_1;
                return zzbfi.zza(var1_1.getResources().getDisplayMetrics());
            }
            case -4: 
            case -3: 
        }
        return -1;
    }

    public int getWidth() {
        return this.zzb;
    }

    /*
     * WARNING - void declaration
     */
    public int getWidthInPixels(@RecentlyNonNull Context context) {
        switch (this_.zzb) {
            default: {
                void var1_1;
                zzbgo.zzb();
                return zzcis.zzs((Context)var1_1, this_.zzb);
            }
            case -1: {
                void var1_1;
                AdSize this_ = var1_1.getResources();
                this_ = this_.getDisplayMetrics();
                return ((DisplayMetrics)this_).widthPixels;
            }
            case -3: 
        }
        return -1;
    }

    public int hashCode() {
        return this.zzd.hashCode();
    }

    /*
     * WARNING - void declaration
     */
    @RecentlyNonNull
    public static AdSize getCurrentOrientationAnchoredAdaptiveBannerAdSize(@RecentlyNonNull Context context, int width) {
        void var1_1;
        Object object = zzcis.zzc(context, (int)var1_1, 50, 0);
        object.zze = true;
        return object;
    }

    /*
     * WARNING - void declaration
     */
    @RecentlyNonNull
    public static AdSize getCurrentOrientationInlineAdaptiveBannerAdSize(@RecentlyNonNull Context context, int width) {
        void var1_2;
        int n = zzcis.zza(context, 0);
        if (n == -1) {
            return INVALID;
        }
        AdSize adSize = new AdSize((int)var1_2, 0);
        adSize.zzg = n;
        adSize.zzf = true;
        return adSize;
    }

    @RecentlyNonNull
    public static AdSize getCurrentOrientationInterscrollerAdSize(@RecentlyNonNull Context context, int width) {
        Context context2;
        return AdSize.zzj(width, zzcis.zza(context2, 0));
    }

    /*
     * WARNING - void declaration
     */
    @RecentlyNonNull
    public static AdSize getInlineAdaptiveBannerAdSize(int width, int maxHeight) {
        void var1_2;
        int n;
        AdSize adSize = new AdSize(n, 0);
        adSize.zzg = var1_2;
        adSize.zzf = true;
        if (var1_2 < 32) {
            StringBuilder stringBuilder = new StringBuilder(129);
            stringBuilder.append("The maximum height set for the inline adaptive ad size was ");
            stringBuilder.append((int)var1_2);
            stringBuilder.append(" dp, which is below the minimum recommended value of 32 dp.");
            zzciz.zzj(stringBuilder.toString());
        }
        return adSize;
    }

    /*
     * WARNING - void declaration
     */
    @RecentlyNonNull
    public static AdSize getLandscapeAnchoredAdaptiveBannerAdSize(@RecentlyNonNull Context context, int width) {
        void var1_1;
        Object object = zzcis.zzc(context, (int)var1_1, 50, 2);
        object.zze = true;
        return object;
    }

    /*
     * WARNING - void declaration
     */
    @RecentlyNonNull
    public static AdSize getLandscapeInlineAdaptiveBannerAdSize(@RecentlyNonNull Context context, int width) {
        void var1_2;
        int n = zzcis.zza(context, 2);
        AdSize adSize = new AdSize((int)var1_2, 0);
        if (n == -1) {
            return INVALID;
        }
        adSize.zzg = n;
        adSize.zzf = true;
        return adSize;
    }

    @RecentlyNonNull
    public static AdSize getLandscapeInterscrollerAdSize(@RecentlyNonNull Context context, int width) {
        Context context2;
        return AdSize.zzj(width, zzcis.zza(context2, 2));
    }

    /*
     * WARNING - void declaration
     */
    @RecentlyNonNull
    public static AdSize getPortraitAnchoredAdaptiveBannerAdSize(@RecentlyNonNull Context context, int width) {
        void var1_1;
        Object object = zzcis.zzc(context, (int)var1_1, 50, 1);
        object.zze = true;
        return object;
    }

    /*
     * WARNING - void declaration
     */
    @RecentlyNonNull
    public static AdSize getPortraitInlineAdaptiveBannerAdSize(@RecentlyNonNull Context context, int width) {
        void var1_2;
        int n = zzcis.zza(context, 1);
        AdSize adSize = new AdSize((int)var1_2, 0);
        if (n == -1) {
            return INVALID;
        }
        adSize.zzg = n;
        adSize.zzf = true;
        return adSize;
    }

    @RecentlyNonNull
    public static AdSize getPortraitInterscrollerAdSize(@RecentlyNonNull Context context, int width) {
        Context context2;
        return AdSize.zzj(width, zzcis.zza(context2, 1));
    }

    @RecentlyNonNull
    public String toString() {
        return this.zzd;
    }

    static {
        AdSize adSize;
        BANNER = adSize = new AdSize(320, 50, "320x50_mb");
        FULL_BANNER = adSize = new AdSize(468, 60, "468x60_as");
        LARGE_BANNER = adSize = new AdSize(320, 100, "320x100_as");
        LEADERBOARD = adSize = new AdSize(728, 90, "728x90_as");
        MEDIUM_RECTANGLE = adSize = new AdSize(300, 250, "300x250_as");
        WIDE_SKYSCRAPER = adSize = new AdSize(160, 600, "160x600_as");
        SMART_BANNER = adSize = new AdSize(-1, -2, "smart_banner");
        FLUID = adSize = new AdSize(-3, -4, "fluid");
        INVALID = adSize = new AdSize(0, 0, "invalid");
        zza = adSize = new AdSize(50, 50, "50x50_mb");
        SEARCH = adSize = new AdSize(-3, 0, "search_v2");
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public AdSize(int width, int height) {
        void var2_2;
        void var1_1;
        String string = width == -1 ? "FULL" : String.valueOf((int)var1_1);
        String string2 = var2_2 == -2 ? "AUTO" : String.valueOf((int)var2_2);
        String string3 = String.valueOf(string);
        int n = string3.length();
        String string4 = String.valueOf(string2);
        int n2 = string4.length();
        StringBuilder stringBuilder = new StringBuilder(n + 4 + n2);
        stringBuilder.append(string);
        stringBuilder.append("x");
        stringBuilder.append(string2);
        stringBuilder.append("_as");
        this((int)var1_1, (int)var2_2, stringBuilder.toString());
    }

    AdSize(int n, int n2, String string) {
        Object object;
        if (n >= 0 || n == -1 || n == -3) {
            if (n2 < 0 && n2 != -2 && n2 != -4) {
                StringBuilder stringBuilder = new StringBuilder(38);
                stringBuilder.append("Invalid height for AdSize: ");
                stringBuilder.append(n2);
                object = new IllegalArgumentException(stringBuilder.toString());
                throw object;
            }
        } else {
            StringBuilder stringBuilder = new StringBuilder(37);
            stringBuilder.append("Invalid width for AdSize: ");
            stringBuilder.append(n);
            object = new IllegalArgumentException(stringBuilder.toString());
            throw object;
        }
        ((AdSize)object).zzb = n;
        ((AdSize)object).zzc = n2;
        ((AdSize)object).zzd = string;
    }

    public boolean equals(@Nullable Object other) {
        AdSize adSize;
        if (other == null) {
            return false;
        }
        if (adSize == this) {
            return true;
        }
        if (!(adSize instanceof AdSize)) {
            return false;
        }
        adSize = adSize;
        return this.zzb == adSize.zzb && this.zzc == adSize.zzc && this.zzd.equals(adSize.zzd);
    }

    public boolean isAutoHeight() {
        return this.zzc == -2;
    }

    public boolean isFluid() {
        return this.zzb == -3 && this.zzc == -4;
    }

    public boolean isFullWidth() {
        return this.zzb == -1;
    }

    final int zza() {
        return this.zzi;
    }

    final int zzb() {
        return this.zzg;
    }

    private static AdSize zzj(int n, int n2) {
        if (n2 == -1) {
            return INVALID;
        }
        AdSize adSize = new AdSize(n, 0);
        adSize.zzi = n2;
        adSize.zzh = true;
        return adSize;
    }

    final void zzc(int n) {
        this.zzg = n;
    }

    final void zzd(int n) {
        this.zzi = n;
    }

    final void zze(boolean bl) {
        this.zzf = true;
    }

    final void zzf(boolean bl) {
        this.zzh = true;
    }

    final boolean zzg() {
        return this.zze;
    }

    final boolean zzh() {
        return this.zzf;
    }

    final boolean zzi() {
        return this.zzh;
    }
}

