/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads;

import android.os.RemoteException;
import androidx.annotation.Nullable;
import androidx.annotation.RecentlyNullable;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.internal.ads.zzbiz;
import com.google.android.gms.internal.ads.zzbjc;
import com.google.android.gms.internal.ads.zzbkp;
import com.google.android.gms.internal.ads.zzciz;
import javax.annotation.concurrent.GuardedBy;

public final class VideoController {
    @KeepForSdk
    public static final int PLAYBACK_STATE_UNKNOWN = 0;
    @KeepForSdk
    public static final int PLAYBACK_STATE_PLAYING = 1;
    @KeepForSdk
    public static final int PLAYBACK_STATE_PAUSED = 2;
    @KeepForSdk
    public static final int PLAYBACK_STATE_ENDED = 3;
    @KeepForSdk
    public static final int PLAYBACK_STATE_READY = 5;
    private final Object zza;
    @GuardedBy(value="lock")
    @Nullable
    private zzbiz zzb;
    @GuardedBy(value="lock")
    @Nullable
    private VideoLifecycleCallbacks zzc;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @KeepForSdk
    public int getPlaybackState() {
        Object object = ((VideoController)((Object)this_)).zza;
        synchronized (object) {
            zzbiz this_ = ((VideoController)((Object)this_)).zzb;
            if (this_ == null) {
                return 0;
            }
            try {
                return this_.zzh();
            }
            catch (RemoteException remoteException) {
                String string = "Unable to call getPlaybackState on video controller.";
                zzciz.zzh(string, remoteException);
                return 0;
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @RecentlyNullable
    public VideoLifecycleCallbacks getVideoLifecycleCallbacks() {
        Object object = ((VideoController)this_).zza;
        synchronized (object) {
            return ((VideoController)this_).zzc;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    public VideoController() {
        Object object;
        this.zza = object = new Object();
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void mute(boolean mute) {
        var2_4 = this.zza;
        synchronized (var2_4) {
            this = this.zzb;
            if (this == null) ** GOTO lbl7
            try {
                block5: {
                    break block5;
lbl7:
                    // 1 sources

                    return;
                }
                this.zzj((boolean)var1_2);
            }
            catch (RemoteException var0_1) {
                var1_3 = "Unable to call mute on video controller.";
                zzciz.zzh(var1_3, var0_1);
            }
            return;
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void pause() {
        var1_2 = this.zza;
        synchronized (var1_2) {
            this = this.zzb;
            if (this == null) ** GOTO lbl7
            try {
                block5: {
                    break block5;
lbl7:
                    // 1 sources

                    return;
                }
                this.zzk();
            }
            catch (RemoteException var0_1) {
                var2_3 = "Unable to call pause on video controller.";
                zzciz.zzh(var2_3, var0_1);
            }
            return;
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void play() {
        var1_2 = this.zza;
        synchronized (var1_2) {
            this = this.zzb;
            if (this == null) ** GOTO lbl7
            try {
                block5: {
                    break block5;
lbl7:
                    // 1 sources

                    return;
                }
                this.zzl();
            }
            catch (RemoteException var0_1) {
                var2_3 = "Unable to call play on video controller.";
                zzciz.zzh(var2_3, var0_1);
            }
            return;
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setVideoLifecycleCallbacks(@Nullable VideoLifecycleCallbacks callbacks) {
        var2_3 = this.zza;
        synchronized (var2_3) {
            block5: {
                this.zzc = var1_2;
                var3_4 = this.zzb;
                if (var3_4 == null) ** GOTO lbl13
                if (var1_2 != null) ** GOTO lbl-1000
                this = null;
                ** try [egrp 1[TRYBLOCK] [1 : 27->52)] { 
lbl9:
                // 1 sources

                ** GOTO lbl11
lbl-1000:
                // 1 sources

                {
                    this = new zzbkp((VideoLifecycleCallbacks)var1_2);
lbl11:
                    // 2 sources

                    var3_4.zzm((zzbjc)this);
                    break block5;
lbl13:
                    // 1 sources

                    return;
                }
lbl14:
                // 1 sources

                catch (RemoteException var0_1) {
                    var1_2 = "Unable to call setVideoLifecycleCallbacks on video controller.";
                    zzciz.zzh(var1_2, var0_1);
                }
            }
            return;
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void stop() {
        var1_2 = this.zza;
        synchronized (var1_2) {
            this = this.zzb;
            if (this == null) ** GOTO lbl7
            try {
                block5: {
                    break block5;
lbl7:
                    // 1 sources

                    return;
                }
                this.zzn();
            }
            catch (RemoteException var0_1) {
                var2_3 = "Unable to call stop on video controller.";
                zzciz.zzh(var2_3, var0_1);
            }
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean hasVideoContent() {
        Object object = ((VideoController)((Object)this_)).zza;
        synchronized (object) {
            zzbiz this_ = ((VideoController)((Object)this_)).zzb;
            if (this_ == null) return false;
            return true;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isClickToExpandEnabled() {
        Object object = ((VideoController)((Object)this_)).zza;
        synchronized (object) {
            zzbiz this_ = ((VideoController)((Object)this_)).zzb;
            if (this_ == null) {
                return false;
            }
            try {
                return this_.zzo();
            }
            catch (RemoteException remoteException) {
                String string = "Unable to call isClickToExpandEnabled.";
                zzciz.zzh(string, remoteException);
                return false;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isCustomControlsEnabled() {
        Object object = ((VideoController)((Object)this_)).zza;
        synchronized (object) {
            zzbiz this_ = ((VideoController)((Object)this_)).zzb;
            if (this_ == null) {
                return false;
            }
            try {
                return this_.zzp();
            }
            catch (RemoteException remoteException) {
                String string = "Unable to call isUsingCustomPlayerControls.";
                zzciz.zzh(string, remoteException);
                return false;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isMuted() {
        Object object = ((VideoController)((Object)this_)).zza;
        synchronized (object) {
            zzbiz this_ = ((VideoController)((Object)this_)).zzb;
            if (this_ == null) {
                return true;
            }
            try {
                return this_.zzq();
            }
            catch (RemoteException remoteException) {
                String string = "Unable to call isMuted on video controller.";
                zzciz.zzh(string, remoteException);
                return true;
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public final zzbiz zza() {
        Object object = ((VideoController)zzbiz2).zza;
        synchronized (object) {
            return ((VideoController)zzbiz2).zzb;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void zzb(@Nullable zzbiz object) {
        Object object2 = this.zza;
        synchronized (object2) {
            this.zzb = object;
            object = this.zzc;
            if (object == null) return;
            this.setVideoLifecycleCallbacks((VideoLifecycleCallbacks)object);
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    public static abstract class VideoLifecycleCallbacks {
        public void onVideoEnd() {
        }

        public void onVideoMute(boolean bl) {
        }

        public void onVideoPause() {
        }

        public void onVideoPlay() {
        }

        public void onVideoStart() {
        }
    }
}

