/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.util;

import android.content.Context;
import androidx.annotation.RecentlyNonNull;
import androidx.work.Configuration;
import androidx.work.Constraints;
import androidx.work.Data;
import androidx.work.NetworkType;
import androidx.work.OneTimeWorkRequest;
import androidx.work.WorkManager;
import androidx.work.WorkRequest;
import com.google.android.apps.common.proguard.UsedByReflection;
import com.google.android.gms.ads.internal.offline.buffering.OfflineNotificationPoster;
import com.google.android.gms.ads.internal.offline.buffering.OfflinePingSender;
import com.google.android.gms.ads.internal.util.zzbu;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.ObjectWrapper;
import com.google.android.gms.internal.ads.zzciz;

@KeepForSdk
public class WorkManagerUtil
extends zzbu {
    @UsedByReflection(value="This class must be instantiated reflectively so that the default class loader can be used.")
    public WorkManagerUtil() {
    }

    private static void zzb(Context context) {
        try {
            context = context.getApplicationContext();
            Configuration.Builder builder = new Configuration.Builder();
            WorkManager.initialize((Context)context, (Configuration)builder.build());
            return;
        }
        catch (IllegalStateException illegalStateException) {
            return;
        }
    }

    @Override
    public final void zze(@RecentlyNonNull IObjectWrapper iObjectWrapper) {
        WorkManagerUtil workManagerUtil = (Context)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper);
        WorkManagerUtil.zzb((Context)workManagerUtil);
        try {
            workManagerUtil = WorkManager.getInstance((Context)workManagerUtil);
        }
        catch (IllegalStateException illegalStateException) {
            zzciz.zzk("Failed to instantiate WorkManager.", illegalStateException);
            return;
        }
        workManagerUtil.cancelAllWorkByTag("offline_ping_sender_work");
        iObjectWrapper = new Constraints.Builder();
        NetworkType networkType = NetworkType.CONNECTED;
        iObjectWrapper = iObjectWrapper.setRequiredNetworkType(networkType);
        iObjectWrapper = iObjectWrapper.build();
        networkType = new OneTimeWorkRequest.Builder(OfflinePingSender.class);
        workManagerUtil.enqueue((WorkRequest)((OneTimeWorkRequest)((OneTimeWorkRequest.Builder)((OneTimeWorkRequest.Builder)networkType.setConstraints((Constraints)iObjectWrapper)).addTag("offline_ping_sender_work")).build()));
    }

    @Override
    public final boolean zzf(@RecentlyNonNull IObjectWrapper iObjectWrapper, @RecentlyNonNull String string, @RecentlyNonNull String string2) {
        WorkManagerUtil workManagerUtil = (Context)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper);
        WorkManagerUtil.zzb((Context)workManagerUtil);
        iObjectWrapper = new Constraints.Builder();
        NetworkType networkType = NetworkType.CONNECTED;
        iObjectWrapper = iObjectWrapper.setRequiredNetworkType(networkType);
        iObjectWrapper = iObjectWrapper.build();
        networkType = new Data.Builder();
        string = networkType.putString("uri", string);
        string = string.putString("gws_query_id", string2);
        string = string.build();
        string2 = new OneTimeWorkRequest.Builder(OfflineNotificationPoster.class);
        iObjectWrapper = (OneTimeWorkRequest)((OneTimeWorkRequest.Builder)((OneTimeWorkRequest.Builder)((OneTimeWorkRequest.Builder)string2.setConstraints((Constraints)iObjectWrapper)).setInputData((Data)string)).addTag("offline_notification_work")).build();
        try {
            workManagerUtil = WorkManager.getInstance((Context)workManagerUtil);
        }
        catch (IllegalStateException illegalStateException) {
            zzciz.zzk("Failed to instantiate WorkManager.", illegalStateException);
            return false;
        }
        workManagerUtil.enqueue((WorkRequest)iObjectWrapper);
        return true;
    }
}

