/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.nativead;

import android.os.RemoteException;
import android.view.View;
import androidx.annotation.RecentlyNonNull;
import com.google.android.gms.ads.nativead.NativeAd;
import com.google.android.gms.ads.nativead.NativeAdView;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.ObjectWrapper;
import com.google.android.gms.internal.ads.zzbgo;
import com.google.android.gms.internal.ads.zzbos;
import com.google.android.gms.internal.ads.zzciz;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.checkerframework.checker.initialization.qual.NotOnlyInitialized;

public final class NativeAdViewHolder {
    @RecentlyNonNull
    public static WeakHashMap<View, NativeAdViewHolder> zza;
    @NotOnlyInitialized
    private zzbos zzb;
    private WeakReference<View> zzc;

    static {
        WeakHashMap weakHashMap = new WeakHashMap();
        zza = weakHashMap;
    }

    /*
     * WARNING - void declaration
     */
    public NativeAdViewHolder(@RecentlyNonNull View containerView, @RecentlyNonNull Map<String, View> clickableAssetViews, @RecentlyNonNull Map<String, View> nonclickableAssetViews) {
        HashMap<String, View> hashMap;
        HashMap<String, View> hashMap2;
        void var1_1;
        Preconditions.checkNotNull((Object)var1_1, (Object)"ContainerView must not be null");
        if (var1_1 instanceof NativeAdView) {
            zzciz.zzg("The provided containerView is of type of NativeAdView, which cannot be usedwith NativeAdViewHolder.");
            return;
        }
        if (zza.get(var1_1) != null) {
            zzciz.zzg("The provided containerView is already in use with another NativeAdViewHolder.");
            return;
        }
        zza.put((View)var1_1, this);
        WeakReference<void> weakReference = new WeakReference<void>(var1_1);
        this.zzc = weakReference;
        hashMap2 = NativeAdViewHolder.zza((Map<String, View>)hashMap2);
        hashMap = NativeAdViewHolder.zza((Map<String, View>)hashMap);
        this.zzb = zzbgo.zza().zzh((View)var1_1, hashMap2, hashMap);
    }

    /*
     * WARNING - void declaration
     */
    public final void setClickConfirmingView(@RecentlyNonNull View view) {
        try {
            void var1_2;
            this.zzb.zzb(ObjectWrapper.wrap((Object)var1_2));
            return;
        }
        catch (RemoteException remoteException) {
            zzciz.zzh("Unable to call setClickConfirmingView on delegate", remoteException);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    public void setNativeAd(@RecentlyNonNull NativeAd ad) {
        Object object = ad.zza();
        Object object2 = ((NativeAdViewHolder)this).zzc;
        object2 = object2 != null ? (View)object2.get() : null;
        if (object2 == null) {
            zzciz.zzj("NativeAdViewHolder.setNativeAd containerView doesn't exist, returning");
            return;
        }
        if (!zza.containsKey(object2)) {
            zza.put((View)object2, (NativeAdViewHolder)this);
        }
        if ((this = ((NativeAdViewHolder)this).zzb) == null) return;
        try {
            this.zzc((IObjectWrapper)object);
            return;
        }
        catch (RemoteException remoteException) {
            zzciz.zzh("Unable to call setNativeAd on delegate", remoteException);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void unregisterNativeAd() {
        zzbos zzbos2 = ((NativeAdViewHolder)this_).zzb;
        if (zzbos2 != null) {
            try {
                zzbos2.zzd();
            }
            catch (RemoteException remoteException) {
                zzciz.zzh("Unable to call unregisterNativeAd on delegate", remoteException);
            }
        }
        if ((this_ = ((NativeAdViewHolder)this_).zzc) == null) return;
        Object this_ = (View)((Reference)this_).get();
        if (this_ == null) return;
        zza.remove(this_);
    }

    private static final HashMap<String, View> zza(Map<String, View> hashMap) {
        if (hashMap == null) {
            hashMap = new HashMap<String, View>();
            return hashMap;
        }
        HashMap<String, View> hashMap2 = new HashMap<String, View>(hashMap);
        return hashMap2;
    }
}

