/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.content.Context;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.WindowManager;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.zza;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.util.PlatformVersion;
import com.google.android.gms.internal.ads.zzbfj;
import com.google.android.gms.internal.ads.zzbgo;
import com.google.android.gms.internal.ads.zzcis;

@SafeParcelable.Reserved(value={1})
@SafeParcelable.Class(creator="AdSizeParcelCreator")
public final class zzbfi
extends AbstractSafeParcelable {
    public static final Parcelable.Creator<zzbfi> CREATOR;
    @SafeParcelable.Field(id=2)
    public final String zza;
    @SafeParcelable.Field(id=3)
    public final int zzb;
    @SafeParcelable.Field(id=4)
    public final int zzc;
    @SafeParcelable.Field(id=5)
    public final boolean zzd;
    @SafeParcelable.Field(id=6)
    public final int zze;
    @SafeParcelable.Field(id=7)
    public final int zzf;
    @SafeParcelable.Field(id=8)
    public final zzbfi[] zzg;
    @SafeParcelable.Field(id=9)
    public final boolean zzh;
    @SafeParcelable.Field(id=10)
    public final boolean zzi;
    @SafeParcelable.Field(id=11)
    public boolean zzj;
    @SafeParcelable.Field(id=12)
    public boolean zzk;
    @SafeParcelable.Field(id=13)
    public boolean zzl;
    @SafeParcelable.Field(id=14)
    public boolean zzm;
    @SafeParcelable.Field(id=15)
    public boolean zzn;
    @SafeParcelable.Field(id=16)
    public boolean zzo;

    private static int zzf(DisplayMetrics displayMetrics) {
        int n = (int)((float)displayMetrics.heightPixels / displayMetrics.density);
        if (n <= 400) {
            return 32;
        }
        if (n <= 720) {
            return 50;
        }
        return 90;
    }

    public static int zza(DisplayMetrics displayMetrics) {
        return (int)((float)zzbfi.zzf(displayMetrics) * displayMetrics.density);
    }

    public static zzbfi zzb() {
        zzbfi zzbfi2 = new zzbfi("interstitial_mb", 0, 0, false, 0, 0, null, false, false, false, false, true, false, false, false);
        return zzbfi2;
    }

    public static zzbfi zzc() {
        zzbfi zzbfi2 = new zzbfi("320x50_mb", 0, 0, false, 0, 0, null, true, false, false, false, false, false, false, false);
        return zzbfi2;
    }

    public static zzbfi zzd() {
        zzbfi zzbfi2 = new zzbfi("reward_mb", 0, 0, true, 0, 0, null, false, false, false, false, false, false, false, false);
        return zzbfi2;
    }

    public static zzbfi zze() {
        zzbfi zzbfi2 = new zzbfi("invalid", 0, 0, false, 0, 0, null, false, false, false, true, false, false, false, false);
        return zzbfi2;
    }

    static {
        zzbfj zzbfj2;
        CREATOR = zzbfj2 = new zzbfj();
    }

    public zzbfi() {
        this("interstitial_mb", 0, 0, true, 0, 0, null, false, false, false, false, false, false, false, false);
    }

    public zzbfi(Context context, AdSize adSize) {
        AdSize[] adSizeArray = new AdSize[]{adSize};
        this(context, adSizeArray);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public zzbfi(Context context, AdSize[] adSizeArray) {
        int n;
        int n2;
        int n3;
        DisplayMetrics displayMetrics;
        int n4;
        int n5;
        AdSize adSize;
        block22: {
            double d;
            block21: {
                block20: {
                    block19: {
                        adSize = adSizeArray[0];
                        this.zzd = false;
                        this.zzi = adSize.isFluid();
                        this.zzm = com.google.android.gms.ads.zza.zzf(adSize);
                        this.zzn = com.google.android.gms.ads.zza.zzg(adSize);
                        this.zzo = n5 = com.google.android.gms.ads.zza.zzh(adSize);
                        if (this.zzi) {
                            this.zze = AdSize.BANNER.getWidth();
                            this.zzb = n5 = AdSize.BANNER.getHeight();
                        } else if (this.zzn) {
                            this.zze = adSize.getWidth();
                            this.zzb = n5 = com.google.android.gms.ads.zza.zza(adSize);
                        } else if (n5 != 0) {
                            this.zze = adSize.getWidth();
                            this.zzb = n5 = com.google.android.gms.ads.zza.zzb(adSize);
                        } else {
                            this.zze = adSize.getWidth();
                            this.zzb = n5 = adSize.getHeight();
                        }
                        n4 = this.zze;
                        displayMetrics = context.getResources().getDisplayMetrics();
                        if (n4 != -1) break block19;
                        zzbgo.zzb();
                        if (context.getResources().getConfiguration().orientation != 2) break block20;
                        Object object = context.getResources().getDisplayMetrics();
                        if ((int)((float)((DisplayMetrics)object).heightPixels / ((DisplayMetrics)object).density) >= 600) break block20;
                        zzbgo.zzb();
                        DisplayMetrics displayMetrics2 = context.getResources().getDisplayMetrics();
                        object = (WindowManager)context.getSystemService("window");
                        if (object == null) break block20;
                        Display display = object.getDefaultDisplay();
                        if (PlatformVersion.isAtLeastJellyBeanMR1()) {
                            display.getRealMetrics(displayMetrics2);
                            n3 = displayMetrics2.heightPixels;
                            n2 = displayMetrics2.widthPixels;
                        } else {
                            object = (Integer)Display.class.getMethod("getRawHeight", new Class[0]).invoke((Object)display, new Object[0]);
                            Integer n6 = (Integer)Display.class.getMethod("getRawWidth", new Class[0]).invoke((Object)display, new Object[0]);
                            n3 = object == null ? 0 : (Integer)object;
                            if (n6 != null) {
                                n2 = n6;
                            }
                            n2 = 0;
                        }
                        display.getMetrics(displayMetrics2);
                        int n7 = displayMetrics2.heightPixels;
                        int n8 = displayMetrics2.widthPixels;
                        if (n7 != n3 || n8 != n2) break block20;
                        n2 = displayMetrics.widthPixels;
                        zzbgo.zzb();
                        n3 = context.getResources().getIdentifier("navigation_bar_width", "dimen", "android");
                        n3 = n3 > 0 ? context.getResources().getDimensionPixelSize(n3) : 0;
                        this.zzf = n3 = n2 - n3;
                        break block21;
                    }
                    n3 = this.zze;
                    zzbgo.zzb();
                    this.zzf = zzcis.zzk(displayMetrics, this.zze);
                    break block22;
                    catch (Exception exception) {}
                }
                this.zzf = n3 = displayMetrics.widthPixels;
            }
            if ((d = (double)((float)n3 / displayMetrics.density)) - (double)(n3 = (int)d) >= 0.01) {
                ++n3;
            }
        }
        n2 = n5 == -2 ? zzbfi.zzf(displayMetrics) : this.zzb;
        zzbgo.zzb();
        this.zzc = zzcis.zzk(displayMetrics, n2);
        if (n4 == -1 || n5 == -2) {
            StringBuilder stringBuilder = new StringBuilder(26);
            stringBuilder.append(n3);
            stringBuilder.append("x");
            stringBuilder.append(n2);
            stringBuilder.append("_as");
            this.zza = stringBuilder.toString();
        } else if (this.zzn || this.zzo) {
            n5 = this.zze;
            n3 = this.zzb;
            StringBuilder stringBuilder = new StringBuilder(26);
            stringBuilder.append(n5);
            stringBuilder.append("x");
            stringBuilder.append(n3);
            stringBuilder.append("_as");
            this.zza = stringBuilder.toString();
        } else {
            this.zza = this.zzi ? "320x50_mb" : adSize.toString();
        }
        if ((n = adSizeArray.length) > 1) {
            this.zzg = new zzbfi[n];
            for (n = 0; n < adSizeArray.length; ++n) {
                zzbfi zzbfi2;
                zzbfi[] zzbfiArray = this.zzg;
                zzbfiArray[n] = zzbfi2 = new zzbfi(context, adSizeArray[n]);
            }
        } else {
            this.zzg = null;
        }
        this.zzh = false;
        this.zzj = false;
    }

    @SafeParcelable.Constructor
    zzbfi(@SafeParcelable.Param(id=2) String string, @SafeParcelable.Param(id=3) int n, @SafeParcelable.Param(id=4) int n2, @SafeParcelable.Param(id=5) boolean bl, @SafeParcelable.Param(id=6) int n3, @SafeParcelable.Param(id=7) int n4, @SafeParcelable.Param(id=8) zzbfi[] zzbfiArray, @SafeParcelable.Param(id=9) boolean bl2, @SafeParcelable.Param(id=10) boolean bl3, @SafeParcelable.Param(id=11) boolean bl4, @SafeParcelable.Param(id=12) boolean bl5, @SafeParcelable.Param(id=13) boolean bl6, @SafeParcelable.Param(id=14) boolean bl7, @SafeParcelable.Param(id=15) boolean bl8, @SafeParcelable.Param(id=16) boolean bl9) {
        this.zza = string;
        this.zzb = n;
        this.zzc = n2;
        this.zzd = bl;
        this.zze = n3;
        this.zzf = n4;
        this.zzg = zzbfiArray;
        this.zzh = bl2;
        this.zzi = bl3;
        this.zzj = bl4;
        this.zzk = bl5;
        this.zzl = bl6;
        this.zzm = bl7;
        this.zzn = bl8;
        this.zzo = bl9;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel);
        SafeParcelWriter.writeString((Parcel)parcel, (int)2, (String)this.zza, (boolean)false);
        SafeParcelWriter.writeInt((Parcel)parcel, (int)3, (int)this.zzb);
        SafeParcelWriter.writeInt((Parcel)parcel, (int)4, (int)this.zzc);
        SafeParcelWriter.writeBoolean((Parcel)parcel, (int)5, (boolean)this.zzd);
        SafeParcelWriter.writeInt((Parcel)parcel, (int)6, (int)this.zze);
        SafeParcelWriter.writeInt((Parcel)parcel, (int)7, (int)this.zzf);
        SafeParcelWriter.writeTypedArray((Parcel)parcel, (int)8, (Parcelable[])this.zzg, (int)n, (boolean)false);
        SafeParcelWriter.writeBoolean((Parcel)parcel, (int)9, (boolean)this.zzh);
        SafeParcelWriter.writeBoolean((Parcel)parcel, (int)10, (boolean)this.zzi);
        SafeParcelWriter.writeBoolean((Parcel)parcel, (int)11, (boolean)this.zzj);
        SafeParcelWriter.writeBoolean((Parcel)parcel, (int)12, (boolean)this.zzk);
        SafeParcelWriter.writeBoolean((Parcel)parcel, (int)13, (boolean)this.zzl);
        SafeParcelWriter.writeBoolean((Parcel)parcel, (int)14, (boolean)this.zzm);
        SafeParcelWriter.writeBoolean((Parcel)parcel, (int)15, (boolean)this.zzn);
        SafeParcelWriter.writeBoolean((Parcel)parcel, (int)16, (boolean)this.zzo);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel, (int)n2);
    }
}

