/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.content.ContentResolver;
import android.content.Context;
import android.os.Build;
import android.provider.Settings;
import android.util.JsonWriter;
import androidx.annotation.GuardedBy;
import androidx.annotation.Nullable;
import com.google.android.gms.common.util.Base64Utils;
import com.google.android.gms.common.util.Clock;
import com.google.android.gms.common.util.DefaultClock;
import com.google.android.gms.internal.ads.zzbmu;
import com.google.android.gms.internal.ads.zzcit;
import com.google.android.gms.internal.ads.zzciu;
import com.google.android.gms.internal.ads.zzciv;
import com.google.android.gms.internal.ads.zzciw;
import com.google.android.gms.internal.ads.zzcix;
import com.google.android.gms.internal.ads.zzciz;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public final class zzciy {
    private static final Object zzb;
    @GuardedBy(value="lock")
    private static boolean zzc;
    @GuardedBy(value="lock")
    private static boolean zzd;
    private static final Clock zze;
    private static final Set<String> zzf;
    private final List<String> zzg;
    public static final /* synthetic */ int zza;

    static {
        HashSet<String> hashSet = new HashSet<String>();
        zzb = hashSet;
        zzc = false;
        zzd = false;
        zze = DefaultClock.getInstance();
        hashSet = new HashSet<String>(Arrays.asList(new String[0]));
        zzf = hashSet;
    }

    public zzciy() {
        this(null);
    }

    /*
     * Enabled aggressive block sorting
     */
    public zzciy(@Nullable String object) {
        if (!zzciy.zzl()) {
            object = new Object();
        } else {
            object = UUID.randomUUID();
            object = ((UUID)object).toString();
            String[] stringArray = new String[1];
            object = String.valueOf(object);
            String string = "network_request_";
            object = ((String)object).length() != 0 ? string.concat((String)object) : new Object(string);
            stringArray[0] = object;
            object = Arrays.asList(stringArray);
        }
        this.zzg = object;
    }

    static /* synthetic */ void zza(String string, String string2, Map map, byte[] byArray, JsonWriter jsonWriter) throws IOException {
        jsonWriter.name("params").beginObject();
        jsonWriter.name("firstline").beginObject();
        jsonWriter.name("uri").value(string);
        jsonWriter.name("verb").value(string2);
        jsonWriter.endObject();
        zzciy.zzs(jsonWriter, map);
        if (byArray != null) {
            jsonWriter.name("body").value(Base64Utils.encode((byte[])byArray));
        }
        jsonWriter.endObject();
    }

    static /* synthetic */ void zzb(int n, Map map, JsonWriter jsonWriter) throws IOException {
        jsonWriter.name("params").beginObject();
        jsonWriter.name("firstline").beginObject();
        jsonWriter.name("code").value((long)n);
        jsonWriter.endObject();
        zzciy.zzs(jsonWriter, map);
        jsonWriter.endObject();
    }

    /*
     * Enabled aggressive block sorting
     */
    private static synchronized void zzn(String string) {
        zzciz.zzi("GMA Debug BEGIN");
        int n = 0;
        while (true) {
            if (n >= string.length()) {
                zzciz.zzi("GMA Debug FINISH");
                return;
            }
            int n2 = n + 4000;
            String string2 = String.valueOf(string.substring(n, Math.min(n2, string.length())));
            String string3 = "GMA Debug CONTENT ";
            string2 = string2.length() != 0 ? string3.concat(string2) : new String(string3);
            zzciz.zzi(string2);
            n = n2;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void zzo(String string, zzcix zzcix2) {
        StringWriter stringWriter = new StringWriter();
        JsonWriter jsonWriter = new JsonWriter((Writer)stringWriter);
        try {
            boolean bl;
            jsonWriter.beginObject();
            jsonWriter.name("timestamp").value(zze.currentTimeMillis());
            jsonWriter.name("event").value(string);
            jsonWriter.name("components").beginArray();
            Iterator<String> iterator = ((zzciy)((Object)iterator)).zzg.iterator();
            while (bl = iterator.hasNext()) {
                jsonWriter.value((String)iterator.next());
            }
            jsonWriter.endArray();
            zzcix2.zza(jsonWriter);
            jsonWriter.endObject();
            jsonWriter.flush();
            jsonWriter.close();
        }
        catch (IOException iOException) {
            zzciz.zzh("unable to log", iOException);
        }
        zzciy.zzn(stringWriter.toString());
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void zzc(HttpURLConnection httpURLConnection, @Nullable byte[] byArray) {
        if (!zzciy.zzl()) {
            return;
        }
        HashMap<String, List<String>> hashMap = httpURLConnection.getRequestProperties() == null ? null : new HashMap<String, List<String>>(httpURLConnection.getRequestProperties());
        String string = new String(httpURLConnection.getURL().toString());
        String string2 = new String(httpURLConnection.getRequestMethod());
        this.zzq(string, string2, hashMap, byArray);
    }

    public final void zzd(String string, String string2, @Nullable Map<String, ?> map, @Nullable byte[] byArray) {
        if (!zzciy.zzl()) {
            return;
        }
        this.zzq(string, "GET", map, byArray);
    }

    private final void zzp(@Nullable String string) {
        zzciu zzciu2 = new zzciu(string);
        this.zzo("onNetworkRequestError", zzciu2);
    }

    private final void zzq(String string, String string2, @Nullable Map<String, ?> map, @Nullable byte[] byArray) {
        zzciv zzciv2 = new zzciv(string, string2, map, byArray);
        this.zzo("onNetworkRequest", zzciv2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void zze(HttpURLConnection object, int n) {
        if (!zzciy.zzl()) {
            return;
        }
        HashMap<String, List<String>> hashMap = ((URLConnection)object).getHeaderFields() == null ? null : new HashMap<String, List<String>>(((URLConnection)object).getHeaderFields());
        this.zzr(hashMap, n);
        if (n >= 200 && n < 300) {
            return;
        }
        try {
            object = ((HttpURLConnection)object).getResponseMessage();
        }
        catch (IOException iOException) {
            object = String.valueOf(iOException.getMessage());
            String string = "Can not get error message from error HttpURLConnection\n";
            object = ((String)object).length() != 0 ? string.concat((String)object) : new String(string);
            zzciz.zzj((String)object);
            object = null;
        }
        this.zzp((String)object);
    }

    public final void zzf(@Nullable Map<String, ?> map, int n) {
        if (!zzciy.zzl()) {
            return;
        }
        this.zzr(map, n);
        if (n < 200 || n >= 300) {
            this.zzp(null);
            return;
        }
    }

    public final void zzg(@Nullable String string) {
        if (!zzciy.zzl()) {
            return;
        }
        if (string == null) {
            return;
        }
        this.zzh(string.getBytes());
    }

    public final void zzh(byte[] byArray) {
        zzciw zzciw2 = new zzciw(byArray);
        this.zzo("onNetworkResponseBody", zzciw2);
    }

    private final void zzr(@Nullable Map<String, ?> map, int n) {
        zzcit zzcit2 = new zzcit(n, map);
        this.zzo("onNetworkResponse", zzcit2);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void zzi() {
        Object object = zzb;
        synchronized (object) {
            zzc = false;
            zzd = false;
            String string = "Ad debug logging enablement is out of date.";
            zzciz.zzj(string);
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void zzj(boolean bl) {
        Object object = zzb;
        synchronized (object) {
            zzc = true;
            zzd = bl;
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    private static void zzs(JsonWriter jsonWriter, @Nullable Map<String, ?> object) throws IOException {
        if (object == null) {
            return;
        }
        jsonWriter.name("headers").beginArray();
        for (Map.Entry entry : object.entrySet()) {
            String string = (String)entry.getKey();
            if (zzf.contains(string)) continue;
            if (entry.getValue() instanceof List) {
                for (Object object2 : (List)entry.getValue()) {
                    object2 = (String)object2;
                    jsonWriter.beginObject();
                    jsonWriter.name("name").value(string);
                    jsonWriter.name("value").value(object2);
                    jsonWriter.endObject();
                }
                continue;
            }
            if (entry.getValue() instanceof String) {
                jsonWriter.beginObject();
                jsonWriter.name("name").value(string);
                jsonWriter.name("value").value((String)entry.getValue());
                jsonWriter.endObject();
                continue;
            }
            zzciz.zzg("Connection headers should be either Map<String, String> or Map<String, List<String>>");
            break;
        }
        jsonWriter.endArray();
    }

    public static boolean zzk(Context context) {
        if (Build.VERSION.SDK_INT < 17) {
            return false;
        }
        if (!zzbmu.zza.zze().booleanValue()) {
            return false;
        }
        try {
            int n = Settings.Global.getInt((ContentResolver)context.getContentResolver(), (String)"development_settings_enabled", (int)0);
            return n != 0;
        }
        catch (Exception exception) {
            zzciz.zzk("Fail to determine debug setting.", exception);
            return false;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean zzl() {
        Object object = zzb;
        synchronized (object) {
            boolean bl = zzc;
            if (!bl) return false;
            bl = zzd;
            if (!bl) return false;
            return true;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean zzm() {
        Object object = zzb;
        synchronized (object) {
            return zzc;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }
}

