/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads;

import android.content.Context;
import android.os.RemoteException;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresPermission;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.VideoOptions;
import com.google.android.gms.ads.admanager.AdManagerAdRequest;
import com.google.android.gms.ads.formats.AdManagerAdViewOptions;
import com.google.android.gms.ads.formats.OnAdManagerAdViewLoadedListener;
import com.google.android.gms.ads.formats.zzf;
import com.google.android.gms.ads.formats.zzg;
import com.google.android.gms.ads.formats.zzi;
import com.google.android.gms.ads.internal.client.zzay;
import com.google.android.gms.ads.internal.client.zzba;
import com.google.android.gms.ads.internal.client.zzbn;
import com.google.android.gms.ads.internal.client.zzbq;
import com.google.android.gms.ads.internal.client.zzdx;
import com.google.android.gms.ads.internal.client.zzeu;
import com.google.android.gms.ads.internal.client.zzfk;
import com.google.android.gms.ads.internal.client.zzp;
import com.google.android.gms.ads.internal.client.zzq;
import com.google.android.gms.ads.internal.util.client.zzb;
import com.google.android.gms.ads.internal.util.client.zzm;
import com.google.android.gms.ads.nativead.NativeAd;
import com.google.android.gms.ads.nativead.NativeAdOptions;
import com.google.android.gms.ads.nativead.NativeCustomFormatAd;
import com.google.android.gms.ads.zza;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.ads.zzbeg;
import com.google.android.gms.internal.ads.zzbep;
import com.google.android.gms.internal.ads.zzbgi;
import com.google.android.gms.internal.ads.zzbhk;
import com.google.android.gms.internal.ads.zzbka;
import com.google.android.gms.internal.ads.zzbkc;
import com.google.android.gms.internal.ads.zzbkd;
import com.google.android.gms.internal.ads.zzbrb;
import com.google.android.gms.internal.ads.zzbut;
import com.google.android.gms.internal.ads.zzbuv;

public class AdLoader {
    private final zzp zza;
    private final Context zzb;
    private final zzbn zzc;

    /*
     * WARNING - void declaration
     */
    @RequiresPermission(value="android.permission.INTERNET")
    public void loadAd(@NonNull AdRequest adRequest) {
        void var1_1;
        this.zzb(var1_1.zza);
    }

    /*
     * WARNING - void declaration
     */
    public void loadAd(@NonNull AdManagerAdRequest adManagerAdRequest) {
        void var1_1;
        this.zzb(var1_1.zza);
    }

    /*
     * WARNING - void declaration
     */
    @RequiresPermission(value="android.permission.INTERNET")
    public void loadAds(@NonNull AdRequest adRequest, int maxNumberOfAds) {
        zzdx zzdx2 = adRequest.zza;
        try {
            void var2_3;
            this.zzc.zzh(this.zza.zza(this.zzb, zzdx2), (int)var2_3);
            return;
        }
        catch (RemoteException remoteException) {
            zzm.zzh("Failed to load ads.", remoteException);
            return;
        }
    }

    public boolean isLoading() {
        try {
            boolean bl = this.zzc.zzi();
            return bl;
        }
        catch (RemoteException remoteException) {
            zzm.zzk("Failed to check if ad is loading.", remoteException);
            return false;
        }
    }

    AdLoader(Context context, zzbn zzbn2, zzp zzp2) {
        this.zzb = context;
        this.zzc = zzbn2;
        this.zza = zzp2;
    }

    final /* synthetic */ void zza(zzdx zzdx2) {
        try {
            this.zzc.zzg(this.zza.zza(this.zzb, zzdx2));
            return;
        }
        catch (RemoteException remoteException) {
            zzm.zzh("Failed to load ad.", remoteException);
            return;
        }
    }

    private final void zzb(zzdx zzdx2) {
        block5: {
            block4: {
                zzbep.zza(this.zzb);
                if (!((Boolean)zzbgi.zzc.zze()).booleanValue()) break block4;
                zzbeg zzbeg2 = zzbep.zzlg;
                if (((Boolean)zzba.zzc().zza(zzbeg2)).booleanValue()) break block5;
            }
            try {
                this.zzc.zzg(this.zza.zza(this.zzb, zzdx2));
                return;
            }
            catch (RemoteException remoteException) {
                zzm.zzh("Failed to load ad.", remoteException);
                return;
            }
        }
        com.google.android.gms.ads.internal.util.client.zzb.zzb.execute(new zza(this, zzdx2));
    }

    public static class Builder {
        private final Context zza;
        private final zzbq zzb;

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @NonNull
        public Builder forAdManagerAdView(@NonNull OnAdManagerAdViewLoadedListener listener, AdSize ... adSizes) {
            zzbq zzbq2;
            if (adSizes == null || ((void)zzbq2).length <= 0) {
                throw new IllegalArgumentException("The supported ad sizes must contain at least one valid ad size.");
            }
            try {
                void var1_1;
                zzq zzq2 = new zzq(this.zza, (AdSize[])zzbq2);
                zzbq2 = this.zzb;
                zzbq2.zzj(new zzbkc((OnAdManagerAdViewLoadedListener)var1_1), zzq2);
                return this;
            }
            catch (RemoteException remoteException) {
                zzm.zzk("Failed to add Google Ad Manager banner ad listener", remoteException);
                return this;
            }
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @NonNull
        public Builder forCustomFormatAd(@NonNull String customFormatId, @NonNull NativeCustomFormatAd.OnCustomFormatAdLoadedListener adLoadedListener, @Nullable NativeCustomFormatAd.OnCustomClickListener customClickListener) {
            void var3_4;
            void var2_3;
            zzbut zzbut2 = new zzbut((NativeCustomFormatAd.OnCustomFormatAdLoadedListener)var2_3, (NativeCustomFormatAd.OnCustomClickListener)var3_4);
            try {
                void var1_1;
                this.zzb.zzh((String)var1_1, zzbut2.zzb(), zzbut2.zza());
                return this;
            }
            catch (RemoteException remoteException) {
                zzm.zzk("Failed to add custom format ad listener", remoteException);
                return this;
            }
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @NonNull
        public Builder forNativeAd(@NonNull NativeAd.OnNativeAdLoadedListener listener) {
            try {
                void var1_1;
                zzbq zzbq2 = this.zzb;
                zzbq2.zzk(new zzbuv((NativeAd.OnNativeAdLoadedListener)var1_1));
                return this;
            }
            catch (RemoteException remoteException) {
                zzm.zzk("Failed to add google native ad listener", remoteException);
                return this;
            }
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @NonNull
        public Builder withAdListener(@NonNull AdListener listener) {
            try {
                void var1_1;
                zzbq zzbq2 = this.zzb;
                zzbq2.zzl(new com.google.android.gms.ads.internal.client.zzg((AdListener)var1_1));
                return this;
            }
            catch (RemoteException remoteException) {
                zzm.zzk("Failed to set AdListener.", remoteException);
                return this;
            }
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @NonNull
        public Builder withAdManagerAdViewOptions(@NonNull AdManagerAdViewOptions options) {
            try {
                void var1_1;
                this.zzb.zzm((AdManagerAdViewOptions)var1_1);
                return this;
            }
            catch (RemoteException remoteException) {
                zzm.zzk("Failed to specify Ad Manager banner ad options", remoteException);
                return this;
            }
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * WARNING - void declaration
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @NonNull
        public Builder withNativeAdOptions(@NonNull NativeAdOptions options) {
            int n;
            boolean bl;
            int n2;
            int n3;
            boolean bl2;
            int n4;
            boolean bl3;
            boolean bl4;
            zzbq zzbq2;
            try {
                void var1_1;
                zzbq2 = this.zzb;
                bl4 = var1_1.shouldReturnUrlsForImageAssets();
                bl3 = var1_1.shouldRequestMultipleImages();
                n4 = var1_1.getAdChoicesPlacement();
                VideoOptions videoOptions = var1_1.getVideoOptions();
                if (videoOptions != null) {
                    zzfk zzfk2 = new zzfk(var1_1.getVideoOptions());
                } else {
                    Object var2_12 = null;
                }
                bl2 = var1_1.zzc();
                n3 = var1_1.getMediaAspectRatio();
                n2 = var1_1.zza();
                bl = var1_1.zzb();
                n = var1_1.zzd();
            }
            catch (RemoteException remoteException) {
                zzm.zzk("Failed to specify native ad options", remoteException);
                return this;
            }
            {
                void var2_11;
                zzbhk zzbhk2 = new zzbhk(4, bl4, -1, bl3, n4, (zzfk)var2_11, bl2, n3, n2, bl, --n);
                zzbq2.zzo(zzbhk2);
                return this;
            }
        }

        @NonNull
        public AdLoader build() {
            try {
                Context context = builder.zza;
                zzbn zzbn2 = builder.zzb.zze();
                AdLoader adLoader = new AdLoader(context, zzbn2, zzp.zza);
                return adLoader;
            }
            catch (RemoteException remoteException) {
                zzm.zzh("Failed to build AdLoader.", remoteException);
                zzeu zzeu2 = new zzeu();
                Builder builder = builder.zza;
                return new AdLoader((Context)builder, zzeu2.zzc(), zzp.zza);
            }
        }

        /*
         * WARNING - void declaration
         */
        public Builder(@NonNull Context context, @NonNull String adUnitID) {
            void var2_2;
            void var1_1;
            Context context2 = (Context)Preconditions.checkNotNull((Object)context, (Object)"context cannot be null");
            zzbq zzbq2 = zzay.zza().zzc((Context)var1_1, (String)var2_2, new zzbrb());
            this.zza = context2;
            this.zzb = zzbq2;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Deprecated
        public final Builder zza(String string, zzg zzg2, @Nullable zzf zzf2) {
            zzbka zzbka2 = new zzbka(zzg2, zzf2);
            try {
                this.zzb.zzh(string, zzbka2.zzd(), zzbka2.zzc());
                return this;
            }
            catch (RemoteException remoteException) {
                zzm.zzk("Failed to add custom template ad listener", remoteException);
                return this;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Deprecated
        public final Builder zzb(zzi zzi2) {
            try {
                zzbq zzbq2 = this.zzb;
                zzbq2.zzk(new zzbkd(zzi2));
                return this;
            }
            catch (RemoteException remoteException) {
                zzm.zzk("Failed to add google native ad listener", remoteException);
                return this;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Deprecated
        @NonNull
        public final Builder zzc(@NonNull com.google.android.gms.ads.formats.NativeAdOptions nativeAdOptions) {
            try {
                this.zzb.zzo(new zzbhk(nativeAdOptions));
                return this;
            }
            catch (RemoteException remoteException) {
                zzm.zzk("Failed to specify native ad options", remoteException);
                return this;
            }
        }
    }
}

