/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.admanager;

import android.content.Context;
import android.util.AttributeSet;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresPermission;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.BaseAdView;
import com.google.android.gms.ads.VideoController;
import com.google.android.gms.ads.VideoOptions;
import com.google.android.gms.ads.admanager.AdManagerAdRequest;
import com.google.android.gms.ads.admanager.AppEventListener;
import com.google.android.gms.ads.admanager.zzb;
import com.google.android.gms.ads.internal.client.zzba;
import com.google.android.gms.ads.internal.client.zzbu;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.ads.zzbeg;
import com.google.android.gms.internal.ads.zzbep;
import com.google.android.gms.internal.ads.zzbgi;
import com.google.android.gms.internal.ads.zzbwj;

public final class AdManagerAdView
extends BaseAdView {
    @NonNull
    public VideoController getVideoController() {
        return this.zza.zzf();
    }

    @Nullable
    public VideoOptions getVideoOptions() {
        return this.zza.zzg();
    }

    @Nullable
    public AppEventListener getAppEventListener() {
        return this.zza.zzh();
    }

    /*
     * WARNING - void declaration
     */
    public AdManagerAdView(@NonNull Context context) {
        super((Context)var1_1, 0);
        void var1_1;
        Preconditions.checkNotNull((Object)var1_1, (Object)"Context cannot be null");
    }

    /*
     * WARNING - void declaration
     */
    public AdManagerAdView(@NonNull Context context, @NonNull AttributeSet attrs) {
        super((Context)var1_1, (AttributeSet)var2_2, true);
        void var2_2;
        void var1_1;
        Preconditions.checkNotNull((Object)var1_1, (Object)"Context cannot be null");
    }

    /*
     * WARNING - void declaration
     */
    public AdManagerAdView(@NonNull Context context, @NonNull AttributeSet attrs, int defStyle) {
        super((Context)var1_1, (AttributeSet)var2_2, (int)var3_3, 0, true);
        void var3_3;
        void var2_2;
        void var1_1;
        Preconditions.checkNotNull((Object)var1_1, (Object)"Context cannot be null");
    }

    /*
     * WARNING - void declaration
     */
    @RequiresPermission(value="android.permission.INTERNET")
    public void loadAd(@NonNull AdManagerAdRequest adManagerAdRequest) {
        void var1_1;
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzbep.zza(this.getContext());
        if (((Boolean)zzbgi.zzf.zze()).booleanValue()) {
            zzbeg zzbeg2 = zzbep.zzlg;
            if (((Boolean)zzba.zzc().zza(zzbeg2)).booleanValue()) {
                com.google.android.gms.ads.internal.util.client.zzb.zzb.execute(new zzb(this, (AdManagerAdRequest)var1_1));
                return;
            }
        }
        this.zza.zzm(var1_1.zza());
    }

    public void recordManualImpression() {
        this.zza.zzo();
    }

    /*
     * WARNING - void declaration
     */
    public void setAdSizes(AdSize ... adSizes) {
        void var1_1;
        if (adSizes == null || ((void)var1_1).length <= 0) {
            throw new IllegalArgumentException("The supported ad sizes must contain at least one valid ad size.");
        }
        this.zza.zzt((AdSize[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setAppEventListener(@Nullable AppEventListener appEventListener) {
        void var1_1;
        this.zza.zzv((AppEventListener)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setManualImpressionsEnabled(boolean manualImpressionsEnabled) {
        void var1_1;
        this.zza.zzw((boolean)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setVideoOptions(@NonNull VideoOptions videoOptions) {
        void var1_1;
        this.zza.zzy((VideoOptions)var1_1);
    }

    @Nullable
    public AdSize[] getAdSizes() {
        return this.zza.zzC();
    }

    final /* synthetic */ void zza(AdManagerAdRequest adManagerAdRequest) {
        try {
            this.zza.zzm(adManagerAdRequest.zza());
            return;
        }
        catch (IllegalStateException illegalStateException) {
            zzbwj.zza(this.getContext()).zzh(illegalStateException, "AdManagerAdView.loadAd");
            return;
        }
    }

    public final boolean zzb(zzbu zzbu2) {
        return this.zza.zzz(zzbu2);
    }
}

