/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.nativead;

import android.annotation.TargetApi;
import android.content.Context;
import android.os.RemoteException;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.ads.MediaContent;
import com.google.android.gms.ads.internal.client.zzay;
import com.google.android.gms.ads.internal.client.zzba;
import com.google.android.gms.ads.internal.client.zzep;
import com.google.android.gms.ads.internal.util.client.zzm;
import com.google.android.gms.ads.nativead.AdChoicesView;
import com.google.android.gms.ads.nativead.MediaView;
import com.google.android.gms.ads.nativead.NativeAd;
import com.google.android.gms.ads.nativead.zzb;
import com.google.android.gms.ads.nativead.zzc;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.ObjectWrapper;
import com.google.android.gms.internal.ads.zzbeg;
import com.google.android.gms.internal.ads.zzbep;
import com.google.android.gms.internal.ads.zzbhz;
import org.checkerframework.checker.initialization.qual.NotOnlyInitialized;
import org.checkerframework.checker.nullness.qual.RequiresNonNull;

public final class NativeAdView
extends FrameLayout {
    @NotOnlyInitialized
    private final FrameLayout zza;
    @NotOnlyInitialized
    @Nullable
    private final zzbhz zzb;

    @Nullable
    public final View getAdvertiserView() {
        return this.zza("3005");
    }

    @Nullable
    public final View getBodyView() {
        return this.zza("3004");
    }

    @Nullable
    public final View getCallToActionView() {
        return this.zza("3002");
    }

    @Nullable
    public final View getHeadlineView() {
        return this.zza("3001");
    }

    @Nullable
    public final View getIconView() {
        return this.zza("3003");
    }

    @Nullable
    public final View getImageView() {
        return this.zza("3008");
    }

    @Nullable
    public final View getPriceView() {
        return this.zza("3007");
    }

    @Nullable
    public final View getStarRatingView() {
        return this.zza("3009");
    }

    @Nullable
    public final View getStoreView() {
        return this.zza("3006");
    }

    @Nullable
    public AdChoicesView getAdChoicesView() {
        if ((this = this.zza("3011")) instanceof AdChoicesView) {
            return (AdChoicesView)((Object)this);
        }
        return null;
    }

    @Nullable
    public final MediaView getMediaView() {
        if ((this = this.zza("3010")) instanceof MediaView) {
            return (MediaView)((Object)this);
        }
        if (this != null) {
            zzm.zze("View is not an instance of MediaView");
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public NativeAdView(@NonNull Context context) {
        super((Context)var1_1);
        void var1_1;
        this.zza = this.zzd((Context)var1_1);
        this.zzb = this.zze();
    }

    /*
     * WARNING - void declaration
     */
    public NativeAdView(@NonNull Context context, @NonNull AttributeSet attrs) {
        super((Context)var1_1, (AttributeSet)var2_2);
        void var2_2;
        void var1_1;
        this.zza = this.zzd((Context)var1_1);
        this.zzb = this.zze();
    }

    /*
     * WARNING - void declaration
     */
    public NativeAdView(@NonNull Context context, @NonNull AttributeSet attrs, int defStyleAttr) {
        super((Context)var1_1, (AttributeSet)var2_2, (int)var3_3);
        void var3_3;
        void var2_2;
        void var1_1;
        this.zza = this.zzd((Context)var1_1);
        this.zzb = this.zze();
    }

    /*
     * WARNING - void declaration
     */
    @TargetApi(value=21)
    public NativeAdView(@NonNull Context context, @NonNull AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super((Context)var1_1, (AttributeSet)var2_2, (int)var3_3, (int)var4_4);
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        this.zza = this.zzd((Context)var1_1);
        this.zzb = this.zze();
    }

    public final void addView(@NonNull View view, int n, @NonNull ViewGroup.LayoutParams layoutParams) {
        super.addView(view, n, layoutParams);
        NativeAdView nativeAdView = this;
        super.bringChildToFront((View)nativeAdView.zza);
    }

    public final void bringChildToFront(@NonNull View view) {
        super.bringChildToFront(view);
        FrameLayout frameLayout = this.zza;
        if (frameLayout != view) {
            super.bringChildToFront((View)frameLayout);
            return;
        }
    }

    public void destroy() {
        zzbhz this_ = ((NativeAdView)((Object)this_)).zzb;
        if (this_ == null) {
            return;
        }
        try {
            this_.zzc();
            return;
        }
        catch (RemoteException remoteException) {
            zzm.zzh("Unable to destroy native ad view", remoteException);
            return;
        }
    }

    public final void onVisibilityChanged(@NonNull View view, int n) {
        super.onVisibilityChanged(view, n);
        zzbhz zzbhz2 = ((NativeAdView)((Object)zzbhz2)).zzb;
        if (zzbhz2 == null) {
            return;
        }
        try {
            zzbhz2.zze(ObjectWrapper.wrap((Object)view), n);
            return;
        }
        catch (RemoteException remoteException) {
            zzm.zzh("Unable to call onVisibilityChanged on delegate", remoteException);
            return;
        }
    }

    public final void removeAllViews() {
        super.removeAllViews();
        NativeAdView nativeAdView = this;
        super.addView((View)nativeAdView.zza);
    }

    public final void removeView(@NonNull View view) {
        if (this.zza == view) {
            return;
        }
        super.removeView(view);
    }

    /*
     * WARNING - void declaration
     */
    public void setAdChoicesView(@Nullable AdChoicesView adChoicesView) {
        void var1_1;
        this.zzf("3011", (View)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final void setAdvertiserView(@Nullable View view) {
        void var1_1;
        this.zzf("3005", (View)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final void setBodyView(@Nullable View view) {
        void var1_1;
        this.zzf("3004", (View)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final void setCallToActionView(@Nullable View view) {
        void var1_1;
        this.zzf("3002", (View)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final void setClickConfirmingView(@Nullable View view) {
        zzbhz this_ = ((NativeAdView)((Object)this_)).zzb;
        if (this_ == null) {
            return;
        }
        try {
            void var1_2;
            this_.zzdw(ObjectWrapper.wrap((Object)var1_2));
            return;
        }
        catch (RemoteException remoteException) {
            zzm.zzh("Unable to call setClickConfirmingView on delegate", remoteException);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void setHeadlineView(@Nullable View view) {
        void var1_1;
        this.zzf("3001", (View)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final void setIconView(@Nullable View view) {
        void var1_1;
        this.zzf("3003", (View)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final void setImageView(@Nullable View view) {
        void var1_1;
        this.zzf("3008", (View)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final void setMediaView(@Nullable MediaView view) {
        void var1_1;
        this.zzf("3010", (View)var1_1);
        if (var1_1 == null) {
            return;
        }
        var1_1.zza(new zzb(this));
        var1_1.zzb(new zzc(this));
    }

    public void setNativeAd(@NonNull NativeAd ad) {
        zzbhz this_ = ((NativeAdView)((Object)this_)).zzb;
        if (this_ == null) {
            return;
        }
        try {
            Object object;
            object = ((NativeAd)object).zza();
            this_.zzdz((IObjectWrapper)object);
            return;
        }
        catch (RemoteException remoteException) {
            zzm.zzh("Unable to call setNativeAd on delegate", remoteException);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void setPriceView(@Nullable View view) {
        void var1_1;
        this.zzf("3007", (View)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final void setStarRatingView(@Nullable View view) {
        void var1_1;
        this.zzf("3009", (View)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final void setStoreView(@Nullable View view) {
        void var1_1;
        this.zzf("3006", (View)var1_1);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final boolean dispatchTouchEvent(@NonNull MotionEvent motionEvent) {
        if (this.zzb == null) return super.dispatchTouchEvent(motionEvent);
        zzbeg zzbeg2 = zzbep.zzlA;
        if ((Boolean)zzba.zzc().zza(zzbeg2) == false) return super.dispatchTouchEvent(motionEvent);
        try {
            this.zzb.zzd(ObjectWrapper.wrap((Object)motionEvent));
            return super.dispatchTouchEvent(motionEvent);
        }
        catch (RemoteException remoteException) {
            zzm.zzh("Unable to call handleTouchEvent on delegate", remoteException);
            return super.dispatchTouchEvent(motionEvent);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    protected final View zza(@NonNull String string) {
        Object object = ((NativeAdView)((Object)object)).zzb;
        if (object == null) return null;
        try {
            object = object.zzb(string);
            if (object == null) return null;
        }
        catch (RemoteException remoteException) {
            zzm.zzh("Unable to call getAssetView on delegate", remoteException);
            return null;
        }
        return (View)ObjectWrapper.unwrap((IObjectWrapper)object);
    }

    private final FrameLayout zzd(Context context) {
        FrameLayout frameLayout = new FrameLayout(context);
        frameLayout.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        this.addView((View)frameLayout);
        return frameLayout;
    }

    @RequiresNonNull(value={"overlayFrame"})
    @Nullable
    private final zzbhz zze() {
        if (this.isInEditMode()) {
            return null;
        }
        FrameLayout frameLayout = this.zza;
        return zzay.zza().zzh(frameLayout.getContext(), this, frameLayout);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final /* synthetic */ void zzb(MediaContent mediaContent) {
        zzbhz zzbhz2 = this.zzb;
        if (zzbhz2 == null) {
            return;
        }
        try {
            void var1_4;
            boolean bl = var1_4 instanceof zzep;
            if (bl) {
                zzbhz2.zzdx(((zzep)var1_4).zzc());
                return;
            }
            if (var1_4 == null) {
                zzbhz2.zzdx(null);
                return;
            }
            String string = "Use MediaContent provided by NativeAd.getMediaContent";
            zzm.zze(string);
            return;
        }
        catch (RemoteException remoteException) {
            zzm.zzh("Unable to call setMediaContent on delegate", remoteException);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final /* synthetic */ void zzc(ImageView.ScaleType scaleType) {
        zzbhz zzbhz2 = ((NativeAdView)((Object)zzbhz2)).zzb;
        if (zzbhz2 == null || scaleType == null) {
            return;
        }
        try {
            zzbhz2.zzdy(ObjectWrapper.wrap((Object)scaleType));
            return;
        }
        catch (RemoteException remoteException) {
            zzm.zzh("Unable to call setMediaViewImageScaleType on delegate", remoteException);
            return;
        }
    }

    private final void zzf(String string, @Nullable View view) {
        zzbhz zzbhz2 = ((NativeAdView)((Object)zzbhz2)).zzb;
        if (zzbhz2 == null) {
            return;
        }
        try {
            zzbhz2.zzdv(string, ObjectWrapper.wrap((Object)view));
            return;
        }
        catch (RemoteException remoteException) {
            zzm.zzh("Unable to call setAssetView on delegate", remoteException);
            return;
        }
    }
}

