/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.rewarded;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.FullScreenContentCallback;
import com.google.android.gms.ads.OnPaidEventListener;
import com.google.android.gms.ads.OnUserEarnedRewardListener;
import com.google.android.gms.ads.ResponseInfo;
import com.google.android.gms.ads.admanager.AdManagerAdRequest;
import com.google.android.gms.ads.internal.client.zzba;
import com.google.android.gms.ads.internal.util.client.zzm;
import com.google.android.gms.ads.rewarded.OnAdMetadataChangedListener;
import com.google.android.gms.ads.rewarded.RewardItem;
import com.google.android.gms.ads.rewarded.RewardedAdLoadCallback;
import com.google.android.gms.ads.rewarded.ServerSideVerificationOptions;
import com.google.android.gms.ads.rewarded.zzb;
import com.google.android.gms.ads.rewarded.zzc;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.ads.zzbeg;
import com.google.android.gms.internal.ads.zzbep;
import com.google.android.gms.internal.ads.zzbgi;
import com.google.android.gms.internal.ads.zzbzj;

public abstract class RewardedAd {
    @NonNull
    public abstract Bundle getAdMetadata();

    @Nullable
    public abstract FullScreenContentCallback getFullScreenContentCallback();

    @Nullable
    public abstract OnPaidEventListener getOnPaidEventListener();

    @NonNull
    public abstract ResponseInfo getResponseInfo();

    @Nullable
    public abstract OnAdMetadataChangedListener getOnAdMetadataChangedListener();

    @NonNull
    public abstract RewardItem getRewardItem();

    @NonNull
    public abstract String getAdUnitId();

    /*
     * WARNING - void declaration
     */
    public static void load(@NonNull Context context, @NonNull String adUnitId, @NonNull AdRequest adRequest, @NonNull RewardedAdLoadCallback loadCallback) {
        Context context2;
        void var3_3;
        void var2_2;
        void var1_1;
        Preconditions.checkNotNull((Object)context, (Object)"Context cannot be null.");
        Preconditions.checkNotNull((Object)var1_1, (Object)"AdUnitId cannot be null.");
        Preconditions.checkNotNull((Object)var2_2, (Object)"AdRequest cannot be null.");
        Preconditions.checkNotNull((Object)var3_3, (Object)"LoadCallback cannot be null.");
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzbep.zza(context2);
        if (((Boolean)zzbgi.zzl.zze()).booleanValue()) {
            zzbeg zzbeg2 = zzbep.zzlg;
            if (((Boolean)zzba.zzc().zza(zzbeg2)).booleanValue()) {
                com.google.android.gms.ads.internal.util.client.zzb.zzb.execute(new zzc(context2, (String)var1_1, (AdRequest)var2_2, (RewardedAdLoadCallback)var3_3));
                return;
            }
        }
        zzm.zze("Loading on UI thread");
        new zzbzj(context2, (String)var1_1).zza(var2_2.zza(), (RewardedAdLoadCallback)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public static void load(@NonNull Context context, @NonNull String adUnitId, @NonNull AdManagerAdRequest adManagerAdRequest, @NonNull RewardedAdLoadCallback loadCallback) {
        Context context2;
        void var3_3;
        void var2_2;
        void var1_1;
        Preconditions.checkNotNull((Object)context, (Object)"Context cannot be null.");
        Preconditions.checkNotNull((Object)var1_1, (Object)"AdUnitId cannot be null.");
        Preconditions.checkNotNull((Object)var2_2, (Object)"AdManagerAdRequest cannot be null.");
        Preconditions.checkNotNull((Object)var3_3, (Object)"LoadCallback cannot be null.");
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzbep.zza(context2);
        if (((Boolean)zzbgi.zzl.zze()).booleanValue()) {
            zzbeg zzbeg2 = zzbep.zzlg;
            if (((Boolean)zzba.zzc().zza(zzbeg2)).booleanValue()) {
                zzm.zze("Loading on background thread");
                com.google.android.gms.ads.internal.util.client.zzb.zzb.execute(new zzb(context2, (String)var1_1, (AdManagerAdRequest)var2_2, (RewardedAdLoadCallback)var3_3));
                return;
            }
        }
        zzm.zze("Loading on UI thread");
        new zzbzj(context2, (String)var1_1).zza(var2_2.zza(), (RewardedAdLoadCallback)var3_3);
    }

    public abstract void setFullScreenContentCallback(@Nullable FullScreenContentCallback var1);

    public abstract void setImmersiveMode(boolean var1);

    public abstract void setOnAdMetadataChangedListener(@Nullable OnAdMetadataChangedListener var1);

    public abstract void setOnPaidEventListener(@Nullable OnPaidEventListener var1);

    public abstract void setServerSideVerificationOptions(@Nullable ServerSideVerificationOptions var1);

    public abstract void show(@NonNull Activity var1, @NonNull OnUserEarnedRewardListener var2);
}

