/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.client;

import android.content.Context;
import android.text.TextUtils;
import android.util.AttributeSet;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.R;

public final class zzy {
    private final AdSize[] zza;
    private final String zzb;

    public final String zza() {
        return this.zzb;
    }

    /*
     * Enabled aggressive block sorting
     */
    public zzy(Context context, AttributeSet object) {
        boolean bl;
        block7: {
            block6: {
                boolean bl2;
                String string;
                block5: {
                    context = context.getResources().obtainAttributes(object, R.styleable.AdsAttrs);
                    String string2 = context.getString(R.styleable.AdsAttrs_adSize);
                    string = context.getString(R.styleable.AdsAttrs_adSizes);
                    bl = TextUtils.isEmpty((CharSequence)string2) ^ true;
                    bl2 = TextUtils.isEmpty((CharSequence)string) ^ true;
                    if (!bl || bl2) break block5;
                    this.zza = zzy.zzc(string2);
                    break block6;
                }
                if (bl || !bl2) break block7;
                this.zza = zzy.zzc(string);
            }
            this.zzb = context.getString(R.styleable.AdsAttrs_adUnitId);
            context.recycle();
            if (TextUtils.isEmpty((CharSequence)this.zzb)) {
                throw new IllegalArgumentException("Required XML attribute \"adUnitId\" was missing.");
            }
            return;
        }
        if (!bl) {
            context.recycle();
            throw new IllegalArgumentException("Required XML attribute \"adSize\" was missing.");
        }
        context.recycle();
        throw new IllegalArgumentException("Either XML attribute \"adSize\" or XML attribute \"supportedAdSizes\" should be specified, but not both.");
    }

    public final AdSize[] zzb(boolean bl) {
        if (!bl && this.zza.length != 1) {
            throw new IllegalArgumentException("The adSizes XML attribute is only allowed on PublisherAdViews.");
        }
        return this.zza;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static AdSize[] zzc(String string) {
        String string2;
        String[] stringArray = string.split("\\s*,\\s*");
        AdSize[] adSizeArray = new AdSize[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            string2 = stringArray[i].trim();
            if (string2.matches("^(\\d+|FULL_WIDTH)\\s*[xX]\\s*(\\d+|AUTO_HEIGHT)$")) {
                int n;
                String[] stringArray2 = string2.split("[xX]");
                stringArray2[0] = stringArray2[0].trim();
                stringArray2[1] = stringArray2[1].trim();
                int n2 = "FULL_WIDTH".equals(stringArray2[0]);
                n2 = n2 != 0 ? -1 : Integer.parseInt(stringArray2[0]);
                boolean bl = "AUTO_HEIGHT".equals(stringArray2[1]);
                if (!bl) {
                    n = Integer.parseInt(stringArray2[1]);
                }
                n = -2;
                adSizeArray[i] = new AdSize(n2, n);
                continue;
            }
            if ("BANNER".equals(string2)) {
                adSizeArray[i] = AdSize.BANNER;
                continue;
            }
            if ("LARGE_BANNER".equals(string2)) {
                adSizeArray[i] = AdSize.LARGE_BANNER;
                continue;
            }
            if ("FULL_BANNER".equals(string2)) {
                adSizeArray[i] = AdSize.FULL_BANNER;
                continue;
            }
            if ("LEADERBOARD".equals(string2)) {
                adSizeArray[i] = AdSize.LEADERBOARD;
                continue;
            }
            if ("MEDIUM_RECTANGLE".equals(string2)) {
                adSizeArray[i] = AdSize.MEDIUM_RECTANGLE;
                continue;
            }
            if ("SMART_BANNER".equals(string2)) {
                adSizeArray[i] = AdSize.SMART_BANNER;
                continue;
            }
            if ("WIDE_SKYSCRAPER".equals(string2)) {
                adSizeArray[i] = AdSize.WIDE_SKYSCRAPER;
                continue;
            }
            if ("FLUID".equals(string2)) {
                adSizeArray[i] = AdSize.FLUID;
                continue;
            }
            if (!"ICON".equals(string2)) {
                string = String.valueOf(string2);
                String string3 = "Could not parse XML attribute \"adSize\": ";
                throw new IllegalArgumentException(string3.concat(string));
            }
            adSizeArray[i] = AdSize.zza;
        }
        if (adSizeArray.length != 0) return adSizeArray;
        string = String.valueOf(string);
        String string4 = "Could not parse XML attribute \"adSize\": ";
        throw new IllegalArgumentException(string4.concat(string));
        catch (NumberFormatException numberFormatException) {
            string = String.valueOf(string2);
            String string5 = "Could not parse XML attribute \"adSize\": ";
            throw new IllegalArgumentException(string5.concat(string));
        }
    }
}

