/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads;

import android.content.Context;
import android.os.RemoteException;
import android.text.TextUtils;
import android.webkit.WebView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresPermission;
import androidx.browser.customtabs.CustomTabsCallback;
import androidx.browser.customtabs.CustomTabsClient;
import androidx.browser.customtabs.CustomTabsSession;
import com.google.android.gms.ads.OnAdInspectorClosedListener;
import com.google.android.gms.ads.RequestConfiguration;
import com.google.android.gms.ads.VersionInfo;
import com.google.android.gms.ads.initialization.InitializationStatus;
import com.google.android.gms.ads.initialization.OnInitializationCompleteListener;
import com.google.android.gms.ads.internal.client.zzex;
import com.google.android.gms.ads.internal.util.client.zzo;
import com.google.android.gms.ads.mediation.rtb.RtbAdapter;
import com.google.android.gms.ads.preload.PreloadCallback;
import com.google.android.gms.ads.preload.PreloadConfiguration;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.ObjectWrapper;
import com.google.android.gms.internal.ads.zzbtv;
import com.google.android.gms.internal.ads.zzbyu;
import java.util.List;

public class MobileAds {
    @NonNull
    public static final String ERROR_DOMAIN = "com.google.android.gms.ads";

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static CustomTabsSession registerCustomTabsSession(@NonNull Context context, @NonNull CustomTabsClient client, @NonNull String origin, @Nullable CustomTabsCallback callback) {
        Context context2;
        zzex.zzf();
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzbyu zzbyu2 = zzbtv.zza(context2);
        if (zzbyu2 == null) {
            zzo.zzg("Internal error, query info generator is null.");
            return null;
        }
        try {
            void var3_4;
            void var2_3;
            void var1_2;
            return (CustomTabsSession)ObjectWrapper.unwrap((IObjectWrapper)zzbyu2.zze(ObjectWrapper.wrap((Object)context2), ObjectWrapper.wrap((Object)var1_2), (String)var2_3, ObjectWrapper.wrap((Object)var3_4)));
        }
        catch (RemoteException | IllegalArgumentException throwable) {
            zzo.zzh("Unable to register custom tabs session. Error: ", throwable);
            return null;
        }
    }

    @NonNull
    public static RequestConfiguration getRequestConfiguration() {
        return zzex.zzf().zzc();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NonNull
    public static VersionInfo getVersion() {
        void var0_2;
        zzex.zzf();
        String[] stringArray = TextUtils.split((String)"23.6.0", (String)"\\.");
        if (stringArray.length != 3) {
            VersionInfo versionInfo = new VersionInfo(0, 0, 0);
            return var0_2;
        }
        try {
            VersionInfo versionInfo;
            VersionInfo versionInfo2 = versionInfo = new VersionInfo(Integer.parseInt(stringArray[0]), Integer.parseInt(stringArray[1]), Integer.parseInt(stringArray[2]));
            return var0_2;
        }
        catch (NumberFormatException numberFormatException) {
            VersionInfo versionInfo = new VersionInfo(0, 0, 0);
            return var0_2;
        }
    }

    @Nullable
    public static InitializationStatus getInitializationStatus() {
        return zzex.zzf().zze();
    }

    @KeepForSdk
    private static String getInternalVersion() {
        return zzex.zzf().zzi();
    }

    private MobileAds() {
    }

    public static void disableMediationAdapterInitialization(@NonNull Context context) {
        Context context2;
        zzex.zzf().zzn(context2);
    }

    @RequiresPermission(value="android.permission.INTERNET")
    public static void initialize(@NonNull Context context) {
        Context context2;
        zzex.zzf().zzo(context2, null, null);
    }

    /*
     * WARNING - void declaration
     */
    public static void initialize(@NonNull Context context, @NonNull OnInitializationCompleteListener listener) {
        void var1_1;
        Context context2;
        zzex.zzf().zzo(context2, null, (OnInitializationCompleteListener)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static void openAdInspector(@NonNull Context context, @NonNull OnAdInspectorClosedListener listener) {
        void var1_1;
        Context context2;
        zzex.zzf().zzr(context2, (OnAdInspectorClosedListener)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static void openDebugMenu(@NonNull Context context, @NonNull String adUnitId) {
        void var1_1;
        Context context2;
        zzex.zzf().zzs(context2, (String)var1_1);
    }

    @KeepForSdk
    public static void registerRtbAdapter(@NonNull Class<? extends RtbAdapter> adapterClass) {
        Class<? extends RtbAdapter> clazz;
        zzex.zzf().zzt(clazz);
    }

    public static void registerWebView(@NonNull WebView webview) {
        WebView webView;
        zzex.zzf();
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        if (webView == null) {
            zzo.zzg("The webview to be registered cannot be null.");
            return;
        }
        zzbyu zzbyu2 = zzbtv.zza(webView.getContext());
        if (zzbyu2 == null) {
            zzo.zzg("Internal error, query info generator is null.");
            return;
        }
        try {
            zzbyu2.zzj(ObjectWrapper.wrap((Object)webView));
            return;
        }
        catch (RemoteException remoteException) {
            zzo.zzh("", remoteException);
            return;
        }
    }

    public static void setAppMuted(boolean muted) {
        boolean bl;
        zzex.zzf().zzu(bl);
    }

    public static void setAppVolume(float volume) {
        float f;
        zzex.zzf().zzv(f);
    }

    @KeepForSdk
    private static void setPlugin(String plugin) {
        String string;
        zzex.zzf().zzw(string);
    }

    public static void setRequestConfiguration(@NonNull RequestConfiguration requestConfiguration) {
        RequestConfiguration requestConfiguration2;
        zzex.zzf().zzx(requestConfiguration2);
    }

    /*
     * WARNING - void declaration
     */
    public static void startPreload(@NonNull Context context, @NonNull List<PreloadConfiguration> preloadConfigurations, @NonNull PreloadCallback preloadCallback) {
        void var2_2;
        void var1_1;
        Context context2;
        zzex.zzf().zzg(context2, (List)var1_1, (PreloadCallback)var2_2);
    }

    public static boolean putPublisherFirstPartyIdEnabled(boolean enabled) {
        boolean bl;
        return zzex.zzf().zzz(bl);
    }
}

