/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.appopen;

import android.app.Activity;
import android.content.Context;
import android.os.RemoteException;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.ads.AdLoadCallback;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.FullScreenContentCallback;
import com.google.android.gms.ads.OnPaidEventListener;
import com.google.android.gms.ads.ResponseInfo;
import com.google.android.gms.ads.admanager.AdManagerAdRequest;
import com.google.android.gms.ads.appopen.zza;
import com.google.android.gms.ads.appopen.zzc;
import com.google.android.gms.ads.internal.client.zzbe;
import com.google.android.gms.ads.internal.util.client.zzo;
import com.google.android.gms.ads.zzb;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.ads.zzazz;
import com.google.android.gms.internal.ads.zzbad;
import com.google.android.gms.internal.ads.zzbal;
import com.google.android.gms.internal.ads.zzbcc;
import com.google.android.gms.internal.ads.zzbcl;
import com.google.android.gms.internal.ads.zzbej;

public abstract class AppOpenAd {
    public static final int APP_OPEN_AD_ORIENTATION_PORTRAIT = 1;
    public static final int APP_OPEN_AD_ORIENTATION_LANDSCAPE = 2;

    @Nullable
    public abstract FullScreenContentCallback getFullScreenContentCallback();

    @Nullable
    public abstract OnPaidEventListener getOnPaidEventListener();

    @NonNull
    public abstract ResponseInfo getResponseInfo();

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static AppOpenAd pollAd(@NonNull Context context, @NonNull String adUnitId) {
        Object object;
        void var1_2;
        block4: {
            try {
                object = zzb.zza(context).zze((String)var1_2);
                if (object != null) break block4;
            }
            catch (RemoteException remoteException) {
                zzo.zzl("#007 Could not call remote method.", remoteException);
                return null;
            }
            object = "Failed to obtain an App Open ad from the preloader.";
            zzo.zzl((String)object, null);
            return null;
        }
        zzazz zzazz2 = new zzazz((zzbad)object, (String)var1_2);
        return zzazz2;
    }

    @NonNull
    public abstract String getAdUnitId();

    /*
     * WARNING - void declaration
     */
    public static void load(@NonNull Context context, @NonNull String adUnitId, @NonNull AdRequest adRequest, @NonNull AppOpenAdLoadCallback loadCallback) {
        void var3_3;
        Context context2;
        void var2_2;
        void var1_1;
        Preconditions.checkNotNull((Object)context, (Object)"Context cannot be null.");
        Preconditions.checkNotNull((Object)var1_1, (Object)"adUnitId cannot be null.");
        Preconditions.checkNotNull((Object)var2_2, (Object)"AdRequest cannot be null.");
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzbcl.zza(context2);
        if (((Boolean)zzbej.zzd.zze()).booleanValue()) {
            zzbcc zzbcc2 = zzbcl.zzla;
            if (((Boolean)zzbe.zzc().zza(zzbcc2)).booleanValue()) {
                com.google.android.gms.ads.internal.util.client.zzb.zzb.execute(new zza(context2, (String)var1_1, (AdRequest)var2_2, (AppOpenAdLoadCallback)var3_3));
                return;
            }
        }
        new zzbal(context2, (String)var1_1, var2_2.zza(), 3, (AppOpenAdLoadCallback)var3_3).zza();
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static void load(@NonNull Context context, @NonNull String adUnitId, @NonNull AdRequest adRequest, @AppOpenAdOrientation int orientation, @NonNull AppOpenAdLoadCallback loadCallback) {
        void var4_4;
        void var3_3;
        Context context2;
        void var2_2;
        void var1_1;
        Preconditions.checkNotNull((Object)context, (Object)"Context cannot be null.");
        Preconditions.checkNotNull((Object)var1_1, (Object)"adUnitId cannot be null.");
        Preconditions.checkNotNull((Object)var2_2, (Object)"AdRequest cannot be null.");
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzbcl.zza(context2);
        if (((Boolean)zzbej.zzd.zze()).booleanValue()) {
            zzbcc zzbcc2 = zzbcl.zzla;
            if (((Boolean)zzbe.zzc().zza(zzbcc2)).booleanValue()) {
                com.google.android.gms.ads.internal.util.client.zzb.zzb.execute(new com.google.android.gms.ads.appopen.zzb(context2, (String)var1_1, (AdRequest)var2_2, (int)var3_3, (AppOpenAdLoadCallback)var4_4));
                return;
            }
        }
        new zzbal(context2, (String)var1_1, var2_2.zza(), (int)var3_3, (AppOpenAdLoadCallback)var4_4).zza();
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static void load(@NonNull Context context, @NonNull String adUnitId, @NonNull AdManagerAdRequest adManagerAdRequest, @AppOpenAdOrientation int orientation, @NonNull AppOpenAdLoadCallback loadCallback) {
        void var4_4;
        void var3_3;
        Context context2;
        void var2_2;
        void var1_1;
        Preconditions.checkNotNull((Object)context, (Object)"Context cannot be null.");
        Preconditions.checkNotNull((Object)var1_1, (Object)"adUnitId cannot be null.");
        Preconditions.checkNotNull((Object)var2_2, (Object)"AdManagerAdRequest cannot be null.");
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzbcl.zza(context2);
        if (((Boolean)zzbej.zzd.zze()).booleanValue()) {
            zzbcc zzbcc2 = zzbcl.zzla;
            if (((Boolean)zzbe.zzc().zza(zzbcc2)).booleanValue()) {
                com.google.android.gms.ads.internal.util.client.zzb.zzb.execute(new zzc(context2, (String)var1_1, (AdManagerAdRequest)var2_2, (int)var3_3, (AppOpenAdLoadCallback)var4_4));
                return;
            }
        }
        new zzbal(context2, (String)var1_1, var2_2.zza(), (int)var3_3, (AppOpenAdLoadCallback)var4_4).zza();
    }

    public abstract void setFullScreenContentCallback(@Nullable FullScreenContentCallback var1);

    public abstract void setImmersiveMode(boolean var1);

    public abstract void setOnPaidEventListener(@Nullable OnPaidEventListener var1);

    public abstract void show(@NonNull Activity var1);

    /*
     * WARNING - void declaration
     */
    public static boolean isAdAvailable(@NonNull Context context, @NonNull String adUnitId) {
        try {
            void var1_3;
            boolean bl = zzb.zza(context).zzj((String)var1_3);
            return bl;
        }
        catch (RemoteException remoteException) {
            zzo.zzl("#007 Could not call remote method.", remoteException);
            return false;
        }
    }

    public static abstract class AppOpenAdLoadCallback
    extends AdLoadCallback<AppOpenAd> {
    }

    public static @interface AppOpenAdOrientation {
    }
}

