/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads;

import android.content.Context;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.RequiresPermission;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.Correlator;
import com.google.android.gms.ads.doubleclick.PublisherAdRequest;
import com.google.android.gms.ads.formats.NativeAdOptions;
import com.google.android.gms.ads.formats.NativeAppInstallAd;
import com.google.android.gms.ads.formats.NativeContentAd;
import com.google.android.gms.ads.formats.NativeCustomTemplateAd;
import com.google.android.gms.ads.internal.client.zzad;
import com.google.android.gms.ads.internal.client.zzc;
import com.google.android.gms.ads.internal.client.zzh;
import com.google.android.gms.ads.internal.client.zzm;
import com.google.android.gms.ads.internal.client.zzr;
import com.google.android.gms.ads.internal.client.zzs;
import com.google.android.gms.ads.internal.formats.NativeAdOptionsParcel;
import com.google.android.gms.ads.internal.util.client.zzb;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.internal.zzdy;
import com.google.android.gms.internal.zzdz;
import com.google.android.gms.internal.zzea;
import com.google.android.gms.internal.zzeb;
import com.google.android.gms.internal.zzfz;

public class AdLoader {
    private final zzh zzpd;
    private final Context mContext;
    private final zzr zzpe;

    AdLoader(Context context, zzr zzr2) {
        this(context, zzr2, zzh.zzdB());
    }

    AdLoader(Context context, zzr zzr2, zzh zzh2) {
        this.mContext = context;
        this.zzpe = zzr2;
        this.zzpd = zzh2;
    }

    private void zza(zzad zzad2) {
        try {
            this.zzpe.zzf(this.zzpd.zza(this.mContext, zzad2));
        }
        catch (RemoteException remoteException) {
            zzb.zzb("Failed to load ad.", remoteException);
        }
    }

    @RequiresPermission(value="android.permission.INTERNET")
    public void loadAd(AdRequest adRequest) {
        this.zza(adRequest.zzaX());
    }

    public void loadAd(PublisherAdRequest publisherAdRequest) {
        this.zza(publisherAdRequest.zzaX());
    }

    public String getMediationAdapterClassName() {
        try {
            return this.zzpe.getMediationAdapterClassName();
        }
        catch (RemoteException remoteException) {
            zzb.zzd("Failed to get the mediation adapter class name.", remoteException);
            return null;
        }
    }

    public boolean isLoading() {
        try {
            return this.zzpe.isLoading();
        }
        catch (RemoteException remoteException) {
            zzb.zzd("Failed to check if ad is loading.", remoteException);
            return false;
        }
    }

    public static class Builder {
        private final Context mContext;
        private final zzs zzpf;

        public Builder(Context context, String string) {
            this((Context)zzaa.zzb((Object)context, (Object)"context cannot be null"), zzm.zzdR().zzb(context, string, new zzfz()));
        }

        Builder(Context context, zzs zzs2) {
            this.mContext = context;
            this.zzpf = zzs2;
        }

        public Builder forContentAd(NativeContentAd.OnContentAdLoadedListener onContentAdLoadedListener) {
            try {
                this.zzpf.zza(new zzdz(onContentAdLoadedListener));
            }
            catch (RemoteException remoteException) {
                zzb.zzd("Failed to add content ad listener", remoteException);
            }
            return this;
        }

        public Builder forAppInstallAd(NativeAppInstallAd.OnAppInstallAdLoadedListener onAppInstallAdLoadedListener) {
            try {
                this.zzpf.zza(new zzdy(onAppInstallAdLoadedListener));
            }
            catch (RemoteException remoteException) {
                zzb.zzd("Failed to add app install ad listener", remoteException);
            }
            return this;
        }

        public Builder forCustomTemplateAd(String string, NativeCustomTemplateAd.OnCustomTemplateAdLoadedListener onCustomTemplateAdLoadedListener, NativeCustomTemplateAd.OnCustomClickListener onCustomClickListener) {
            try {
                this.zzpf.zza(string, new zzeb(onCustomTemplateAdLoadedListener), onCustomClickListener == null ? null : new zzea(onCustomClickListener));
            }
            catch (RemoteException remoteException) {
                zzb.zzd("Failed to add custom template ad listener", remoteException);
            }
            return this;
        }

        public Builder withAdListener(AdListener adListener) {
            try {
                this.zzpf.zzb(new zzc(adListener));
            }
            catch (RemoteException remoteException) {
                zzb.zzd("Failed to set AdListener.", remoteException);
            }
            return this;
        }

        public Builder withNativeAdOptions(NativeAdOptions nativeAdOptions) {
            try {
                this.zzpf.zza(new NativeAdOptionsParcel(nativeAdOptions));
            }
            catch (RemoteException remoteException) {
                zzb.zzd("Failed to specify native ad options", remoteException);
            }
            return this;
        }

        public Builder withCorrelator(@NonNull Correlator correlator) {
            zzaa.zzz((Object)correlator);
            try {
                this.zzpf.zzb(correlator.zzaY());
            }
            catch (RemoteException remoteException) {
                zzb.zzd("Failed to set correlator.", remoteException);
            }
            return this;
        }

        public AdLoader build() {
            try {
                return new AdLoader(this.mContext, this.zzpf.zzbM());
            }
            catch (RemoteException remoteException) {
                zzb.zzb("Failed to build AdLoader.", remoteException);
                return null;
            }
        }
    }
}

