/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads;

import android.content.Context;
import android.support.annotation.RequiresPermission;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.internal.client.zza;
import com.google.android.gms.ads.internal.client.zzae;
import com.google.android.gms.ads.purchase.InAppPurchaseListener;
import com.google.android.gms.ads.purchase.PlayStorePurchaseListener;

class BaseAdView
extends ViewGroup {
    protected final zzae zzpl;

    public BaseAdView(Context context, int n) {
        super(context);
        this.zzpl = new zzae(this, BaseAdView.zze(n));
    }

    public BaseAdView(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet);
        this.zzpl = new zzae(this, attributeSet, false, BaseAdView.zze(n));
    }

    public BaseAdView(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet, n);
        this.zzpl = new zzae(this, attributeSet, false, BaseAdView.zze(n2));
    }

    public void destroy() {
        this.zzpl.destroy();
    }

    public AdListener getAdListener() {
        return this.zzpl.getAdListener();
    }

    public AdSize getAdSize() {
        return this.zzpl.getAdSize();
    }

    public String getAdUnitId() {
        return this.zzpl.getAdUnitId();
    }

    public InAppPurchaseListener getInAppPurchaseListener() {
        return this.zzpl.getInAppPurchaseListener();
    }

    @RequiresPermission(value="android.permission.INTERNET")
    public void loadAd(AdRequest adRequest) {
        this.zzpl.zza(adRequest.zzaX());
    }

    public void pause() {
        this.zzpl.pause();
    }

    public void resume() {
        this.zzpl.resume();
    }

    public boolean isLoading() {
        return this.zzpl.isLoading();
    }

    public void setAdListener(AdListener adListener) {
        this.zzpl.setAdListener(adListener);
        if (adListener != null && adListener instanceof zza) {
            this.zzpl.zza((zza)((Object)adListener));
        } else if (adListener == null) {
            this.zzpl.zza((zza)null);
        }
    }

    public void setAdSize(AdSize adSize) {
        this.zzpl.setAdSizes(adSize);
    }

    public void setAdUnitId(String string) {
        this.zzpl.setAdUnitId(string);
    }

    public void setInAppPurchaseListener(InAppPurchaseListener inAppPurchaseListener) {
        this.zzpl.setInAppPurchaseListener(inAppPurchaseListener);
    }

    public void setPlayStorePurchaseParams(PlayStorePurchaseListener playStorePurchaseListener, String string) {
        this.zzpl.setPlayStorePurchaseParams(playStorePurchaseListener, string);
    }

    public String getMediationAdapterClassName() {
        return this.zzpl.getMediationAdapterClassName();
    }

    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        View view = this.getChildAt(0);
        if (view != null && view.getVisibility() != 8) {
            int n5 = view.getMeasuredWidth();
            int n6 = view.getMeasuredHeight();
            int n7 = (n3 - n - n5) / 2;
            int n8 = (n4 - n2 - n6) / 2;
            view.layout(n7, n8, n7 + n5, n8 + n6);
        }
    }

    protected void onMeasure(int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        View view = this.getChildAt(0);
        if (view != null && view.getVisibility() != 8) {
            this.measureChild(view, n, n2);
            n3 = view.getMeasuredWidth();
            n4 = view.getMeasuredHeight();
        } else {
            AdSize adSize = this.getAdSize();
            if (adSize != null) {
                Context context = this.getContext();
                n3 = adSize.getWidthInPixels(context);
                n4 = adSize.getHeightInPixels(context);
            }
        }
        n3 = Math.max(n3, this.getSuggestedMinimumWidth());
        n4 = Math.max(n4, this.getSuggestedMinimumHeight());
        this.setMeasuredDimension(View.resolveSize((int)n3, (int)n), View.resolveSize((int)n4, (int)n2));
    }

    private static boolean zze(int n) {
        return n == 2;
    }
}

