/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.client;

import android.content.Context;
import android.os.RemoteException;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.Correlator;
import com.google.android.gms.ads.VideoController;
import com.google.android.gms.ads.VideoOptions;
import com.google.android.gms.ads.doubleclick.AppEventListener;
import com.google.android.gms.ads.doubleclick.OnCustomRenderedAdLoadedListener;
import com.google.android.gms.ads.internal.client.AdSizeParcel;
import com.google.android.gms.ads.internal.client.VideoOptionsParcel;
import com.google.android.gms.ads.internal.client.zza;
import com.google.android.gms.ads.internal.client.zzab;
import com.google.android.gms.ads.internal.client.zzad;
import com.google.android.gms.ads.internal.client.zzb;
import com.google.android.gms.ads.internal.client.zzc;
import com.google.android.gms.ads.internal.client.zzh;
import com.google.android.gms.ads.internal.client.zzj;
import com.google.android.gms.ads.internal.client.zzk;
import com.google.android.gms.ads.internal.client.zzm;
import com.google.android.gms.ads.internal.client.zzo;
import com.google.android.gms.ads.internal.client.zzu;
import com.google.android.gms.ads.purchase.InAppPurchaseListener;
import com.google.android.gms.ads.purchase.PlayStorePurchaseListener;
import com.google.android.gms.dynamic.zzd;
import com.google.android.gms.dynamic.zze;
import com.google.android.gms.internal.zzdh;
import com.google.android.gms.internal.zzfz;
import com.google.android.gms.internal.zzhm;
import com.google.android.gms.internal.zzhq;
import com.google.android.gms.internal.zzig;
import java.util.concurrent.atomic.AtomicBoolean;

@zzig
public class zzae {
    private final zzfz zzwc = new zzfz();
    private final zzh zzpd;
    private final AtomicBoolean zzwd;
    private final VideoController zzwe = new VideoController();
    final zzo zzwf = new zzo(){

        @Override
        public void onAdLoaded() {
            zzae.this.zzwe.zza(zzae.this.zzee());
            super.onAdLoaded();
        }

        @Override
        public void onAdFailedToLoad(int n) {
            zzae.this.zzwe.zza(zzae.this.zzee());
            super.onAdFailedToLoad(n);
        }
    };
    private zza zzuL;
    private AdListener zzuM;
    private AdSize[] zzvz;
    private AppEventListener zzvy;
    private Correlator zzwg;
    private zzu zzwh;
    private InAppPurchaseListener zzwi;
    private OnCustomRenderedAdLoadedListener zzwj;
    private PlayStorePurchaseListener zzwk;
    private VideoOptions zzwl;
    private String zzqO;
    private String zzwm;
    private ViewGroup zzwn;
    private boolean zzwo;
    private boolean zzqs;

    public zzae(ViewGroup viewGroup) {
        this(viewGroup, null, false, zzh.zzdB(), false);
    }

    public zzae(ViewGroup viewGroup, boolean bl) {
        this(viewGroup, null, false, zzh.zzdB(), bl);
    }

    public zzae(ViewGroup viewGroup, AttributeSet attributeSet, boolean bl) {
        this(viewGroup, attributeSet, bl, zzh.zzdB(), false);
    }

    public zzae(ViewGroup viewGroup, AttributeSet attributeSet, boolean bl, boolean bl2) {
        this(viewGroup, attributeSet, bl, zzh.zzdB(), bl2);
    }

    zzae(ViewGroup viewGroup, AttributeSet attributeSet, boolean bl, zzh zzh2, zzu zzu2, boolean bl2) {
        this.zzwn = viewGroup;
        this.zzpd = zzh2;
        this.zzwh = zzu2;
        this.zzwd = new AtomicBoolean(false);
        this.zzwo = bl2;
        if (attributeSet != null) {
            Context context = viewGroup.getContext();
            try {
                zzk zzk2 = new zzk(context, attributeSet);
                this.zzvz = zzk2.zzk(bl);
                this.zzqO = zzk2.getAdUnitId();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                zzm.zzdQ().zza(viewGroup, new AdSizeParcel(context, AdSize.BANNER), illegalArgumentException.getMessage(), illegalArgumentException.getMessage());
                return;
            }
            if (viewGroup.isInEditMode()) {
                zzm.zzdQ().zza(viewGroup, zzae.zza(context, this.zzvz[0], this.zzwo), "Ads by Google");
            }
        }
    }

    zzae(ViewGroup viewGroup, AttributeSet attributeSet, boolean bl, zzh zzh2, boolean bl2) {
        this(viewGroup, attributeSet, bl, zzh2, null, bl2);
    }

    public void destroy() {
        try {
            if (this.zzwh != null) {
                this.zzwh.destroy();
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to destroy AdView.", remoteException);
        }
    }

    public AdListener getAdListener() {
        return this.zzuM;
    }

    public AdSize getAdSize() {
        try {
            AdSizeParcel adSizeParcel;
            if (this.zzwh != null && (adSizeParcel = this.zzwh.zzbi()) != null) {
                return adSizeParcel.zzdD();
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to get the current AdSize.", remoteException);
        }
        return this.zzvz != null ? this.zzvz[0] : null;
    }

    public AdSize[] getAdSizes() {
        return this.zzvz;
    }

    public String getAdUnitId() {
        return this.zzqO;
    }

    public AppEventListener getAppEventListener() {
        return this.zzvy;
    }

    public InAppPurchaseListener getInAppPurchaseListener() {
        return this.zzwi;
    }

    public OnCustomRenderedAdLoadedListener getOnCustomRenderedAdLoadedListener() {
        return this.zzwj;
    }

    public void zza(zzad zzad2) {
        try {
            if (this.zzwh == null) {
                this.zzeg();
            }
            if (this.zzwh.zzb(this.zzpd.zza(this.zzwn.getContext(), zzad2))) {
                this.zzwc.zzh(zzad2.zzea());
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to load ad.", remoteException);
        }
    }

    public void pause() {
        try {
            if (this.zzwh != null) {
                this.zzwh.pause();
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to call pause.", remoteException);
        }
    }

    public void recordManualImpression() {
        if (this.zzwd.getAndSet(true)) {
            return;
        }
        try {
            if (this.zzwh != null) {
                this.zzwh.zzbk();
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to record impression.", remoteException);
        }
    }

    public void resume() {
        try {
            if (this.zzwh != null) {
                this.zzwh.resume();
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to call resume.", remoteException);
        }
    }

    public void setAdListener(AdListener adListener) {
        this.zzuM = adListener;
        this.zzwf.zza(adListener);
    }

    public void zza(zza zza2) {
        try {
            this.zzuL = zza2;
            if (this.zzwh != null) {
                this.zzwh.zza(zza2 != null ? new zzb(zza2) : null);
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to set the AdClickListener.", remoteException);
        }
    }

    public void setAdSizes(AdSize ... adSizeArray) {
        if (this.zzvz != null) {
            throw new IllegalStateException("The ad size can only be set once on AdView.");
        }
        this.zza(adSizeArray);
    }

    public void zza(AdSize ... adSizeArray) {
        this.zzvz = adSizeArray;
        try {
            if (this.zzwh != null) {
                this.zzwh.zza(zzae.zza(this.zzwn.getContext(), this.zzvz, this.zzwo));
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to set the ad size.", remoteException);
        }
        this.zzwn.requestLayout();
    }

    public void setAdUnitId(String string) {
        if (this.zzqO != null) {
            throw new IllegalStateException("The ad unit ID can only be set once on AdView.");
        }
        this.zzqO = string;
    }

    public void setAppEventListener(AppEventListener appEventListener) {
        try {
            this.zzvy = appEventListener;
            if (this.zzwh != null) {
                this.zzwh.zza(appEventListener != null ? new zzj(appEventListener) : null);
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to set the AppEventListener.", remoteException);
        }
    }

    public void setInAppPurchaseListener(InAppPurchaseListener inAppPurchaseListener) {
        if (this.zzwk != null) {
            throw new IllegalStateException("Play store purchase parameter has already been set.");
        }
        try {
            this.zzwi = inAppPurchaseListener;
            if (this.zzwh != null) {
                this.zzwh.zza(inAppPurchaseListener != null ? new zzhm(inAppPurchaseListener) : null);
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to set the InAppPurchaseListener.", remoteException);
        }
    }

    public void setOnCustomRenderedAdLoadedListener(OnCustomRenderedAdLoadedListener onCustomRenderedAdLoadedListener) {
        this.zzwj = onCustomRenderedAdLoadedListener;
        try {
            if (this.zzwh != null) {
                this.zzwh.zza(onCustomRenderedAdLoadedListener != null ? new zzdh(onCustomRenderedAdLoadedListener) : null);
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to set the onCustomRenderedAdLoadedListener.", remoteException);
        }
    }

    public void setPlayStorePurchaseParams(PlayStorePurchaseListener playStorePurchaseListener, String string) {
        if (this.zzwi != null) {
            throw new IllegalStateException("InAppPurchaseListener has already been set.");
        }
        try {
            this.zzwk = playStorePurchaseListener;
            this.zzwm = string;
            if (this.zzwh != null) {
                this.zzwh.zza(playStorePurchaseListener != null ? new zzhq(playStorePurchaseListener) : null, string);
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to set the play store purchase parameter.", remoteException);
        }
    }

    public void setManualImpressionsEnabled(boolean bl) {
        this.zzqs = bl;
        try {
            if (this.zzwh != null) {
                this.zzwh.setManualImpressionsEnabled(this.zzqs);
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to set manual impressions.", remoteException);
        }
    }

    public void setCorrelator(Correlator correlator) {
        this.zzwg = correlator;
        try {
            if (this.zzwh != null) {
                this.zzwh.zza(this.zzwg == null ? null : this.zzwg.zzaY());
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to set correlator.", remoteException);
        }
    }

    public String getMediationAdapterClassName() {
        try {
            if (this.zzwh != null) {
                return this.zzwh.getMediationAdapterClassName();
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to get the mediation adapter class name.", remoteException);
        }
        return null;
    }

    public boolean isLoading() {
        try {
            if (this.zzwh != null) {
                return this.zzwh.isLoading();
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to check if ad is loading.", remoteException);
        }
        return false;
    }

    public VideoController getVideoController() {
        return this.zzwe;
    }

    public zzab zzee() {
        if (this.zzwh == null) {
            return null;
        }
        try {
            return this.zzwh.zzbl();
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to retrieve VideoController.", remoteException);
            return null;
        }
    }

    public void setVideoOptions(VideoOptions videoOptions) {
        this.zzwl = videoOptions;
        try {
            if (this.zzwh != null) {
                this.zzwh.zza(videoOptions == null ? null : new VideoOptionsParcel(videoOptions));
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to set video options.", remoteException);
        }
    }

    public VideoOptions getVideoOptions() {
        return this.zzwl;
    }

    private void zzef() {
        try {
            zzd zzd2 = this.zzwh.zzbh();
            if (zzd2 == null) {
                return;
            }
            this.zzwn.addView((View)zze.zzx((zzd)zzd2));
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to get an ad frame.", remoteException);
        }
    }

    void zzeg() throws RemoteException {
        if ((this.zzvz == null || this.zzqO == null) && this.zzwh == null) {
            throw new IllegalStateException("The ad size and ad unit ID must be set before loadAd is called.");
        }
        this.zzwh = this.zzeh();
        this.zzwh.zza(new zzc(this.zzwf));
        if (this.zzuL != null) {
            this.zzwh.zza(new zzb(this.zzuL));
        }
        if (this.zzvy != null) {
            this.zzwh.zza(new zzj(this.zzvy));
        }
        if (this.zzwi != null) {
            this.zzwh.zza(new zzhm(this.zzwi));
        }
        if (this.zzwk != null) {
            this.zzwh.zza(new zzhq(this.zzwk), this.zzwm);
        }
        if (this.zzwj != null) {
            this.zzwh.zza(new zzdh(this.zzwj));
        }
        if (this.zzwg != null) {
            this.zzwh.zza(this.zzwg.zzaY());
        }
        if (this.zzwl != null) {
            this.zzwh.zza(new VideoOptionsParcel(this.zzwl));
        }
        this.zzwh.setManualImpressionsEnabled(this.zzqs);
        this.zzef();
    }

    protected zzu zzeh() throws RemoteException {
        Context context = this.zzwn.getContext();
        AdSizeParcel adSizeParcel = zzae.zza(context, this.zzvz, this.zzwo);
        if (this.zzb(adSizeParcel)) {
            return zzm.zzdR().zza(context, adSizeParcel, this.zzqO);
        }
        return zzm.zzdR().zza(context, adSizeParcel, this.zzqO, this.zzwc);
    }

    private static AdSizeParcel zza(Context context, AdSize[] adSizeArray, boolean bl) {
        AdSizeParcel adSizeParcel = new AdSizeParcel(context, adSizeArray);
        adSizeParcel.zzj(bl);
        return adSizeParcel;
    }

    private static AdSizeParcel zza(Context context, AdSize adSize, boolean bl) {
        AdSizeParcel adSizeParcel = new AdSizeParcel(context, adSize);
        adSizeParcel.zzj(bl);
        return adSizeParcel;
    }

    public boolean zzb(AdSizeParcel adSizeParcel) {
        return "search_v2".equals(adSizeParcel.zzvs);
    }
}

