/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.client;

import android.content.Context;
import android.os.RemoteException;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.Correlator;
import com.google.android.gms.ads.doubleclick.AppEventListener;
import com.google.android.gms.ads.doubleclick.OnCustomRenderedAdLoadedListener;
import com.google.android.gms.ads.doubleclick.PublisherInterstitialAd;
import com.google.android.gms.ads.internal.client.AdSizeParcel;
import com.google.android.gms.ads.internal.client.zza;
import com.google.android.gms.ads.internal.client.zzad;
import com.google.android.gms.ads.internal.client.zzb;
import com.google.android.gms.ads.internal.client.zzc;
import com.google.android.gms.ads.internal.client.zzh;
import com.google.android.gms.ads.internal.client.zzj;
import com.google.android.gms.ads.internal.client.zzm;
import com.google.android.gms.ads.internal.client.zzu;
import com.google.android.gms.ads.internal.reward.client.zzg;
import com.google.android.gms.ads.purchase.InAppPurchaseListener;
import com.google.android.gms.ads.purchase.PlayStorePurchaseListener;
import com.google.android.gms.ads.reward.RewardedVideoAdListener;
import com.google.android.gms.internal.zzdh;
import com.google.android.gms.internal.zzfz;
import com.google.android.gms.internal.zzhm;
import com.google.android.gms.internal.zzhq;
import com.google.android.gms.internal.zzig;

@zzig
public class zzaf {
    private final zzfz zzwc = new zzfz();
    private final Context mContext;
    private final zzh zzpd;
    private AdListener zzuM;
    private zza zzuL;
    private zzu zzwh;
    private String zzqO;
    private String zzwm;
    private AppEventListener zzvy;
    private PlayStorePurchaseListener zzwk;
    private InAppPurchaseListener zzwi;
    private PublisherInterstitialAd zzwq;
    private OnCustomRenderedAdLoadedListener zzwj;
    private Correlator zzwg;
    private RewardedVideoAdListener zzaY;
    private boolean zzwr;

    public zzaf(Context context) {
        this(context, zzh.zzdB(), null);
    }

    public zzaf(Context context, PublisherInterstitialAd publisherInterstitialAd) {
        this(context, zzh.zzdB(), publisherInterstitialAd);
    }

    public zzaf(Context context, zzh zzh2, PublisherInterstitialAd publisherInterstitialAd) {
        this.mContext = context;
        this.zzpd = zzh2;
        this.zzwq = publisherInterstitialAd;
    }

    public AdListener getAdListener() {
        return this.zzuM;
    }

    public String getAdUnitId() {
        return this.zzqO;
    }

    public AppEventListener getAppEventListener() {
        return this.zzvy;
    }

    public InAppPurchaseListener getInAppPurchaseListener() {
        return this.zzwi;
    }

    public OnCustomRenderedAdLoadedListener getOnCustomRenderedAdLoadedListener() {
        return this.zzwj;
    }

    public boolean isLoaded() {
        try {
            if (this.zzwh == null) {
                return false;
            }
            return this.zzwh.isReady();
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to check if ad is ready.", remoteException);
            return false;
        }
    }

    public boolean isLoading() {
        try {
            if (this.zzwh == null) {
                return false;
            }
            return this.zzwh.isLoading();
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to check if ad is loading.", remoteException);
            return false;
        }
    }

    public void zza(zzad zzad2) {
        try {
            if (this.zzwh == null) {
                this.zzM("loadAd");
            }
            if (this.zzwh.zzb(this.zzpd.zza(this.mContext, zzad2))) {
                this.zzwc.zzh(zzad2.zzea());
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to load ad.", remoteException);
        }
    }

    public void setAdListener(AdListener adListener) {
        try {
            this.zzuM = adListener;
            if (this.zzwh != null) {
                this.zzwh.zza(adListener != null ? new zzc(adListener) : null);
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to set the AdListener.", remoteException);
        }
    }

    public void zza(zza zza2) {
        try {
            this.zzuL = zza2;
            if (this.zzwh != null) {
                this.zzwh.zza(zza2 != null ? new zzb(zza2) : null);
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to set the AdClickListener.", remoteException);
        }
    }

    public void setAdUnitId(String string) {
        if (this.zzqO != null) {
            throw new IllegalStateException("The ad unit ID can only be set once on InterstitialAd.");
        }
        this.zzqO = string;
    }

    public void setAppEventListener(AppEventListener appEventListener) {
        try {
            this.zzvy = appEventListener;
            if (this.zzwh != null) {
                this.zzwh.zza(appEventListener != null ? new zzj(appEventListener) : null);
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to set the AppEventListener.", remoteException);
        }
    }

    public void setInAppPurchaseListener(InAppPurchaseListener inAppPurchaseListener) {
        if (this.zzwk != null) {
            throw new IllegalStateException("Play store purchase parameter has already been set.");
        }
        try {
            this.zzwi = inAppPurchaseListener;
            if (this.zzwh != null) {
                this.zzwh.zza(inAppPurchaseListener != null ? new zzhm(inAppPurchaseListener) : null);
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to set the InAppPurchaseListener.", remoteException);
        }
    }

    public void setOnCustomRenderedAdLoadedListener(OnCustomRenderedAdLoadedListener onCustomRenderedAdLoadedListener) {
        try {
            this.zzwj = onCustomRenderedAdLoadedListener;
            if (this.zzwh != null) {
                this.zzwh.zza(onCustomRenderedAdLoadedListener != null ? new zzdh(onCustomRenderedAdLoadedListener) : null);
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to set the OnCustomRenderedAdLoadedListener.", remoteException);
        }
    }

    public void setPlayStorePurchaseParams(PlayStorePurchaseListener playStorePurchaseListener, String string) {
        if (this.zzwi != null) {
            throw new IllegalStateException("In app purchase parameter has already been set.");
        }
        try {
            this.zzwk = playStorePurchaseListener;
            this.zzwm = string;
            if (this.zzwh != null) {
                this.zzwh.zza(playStorePurchaseListener != null ? new zzhq(playStorePurchaseListener) : null, string);
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to set the play store purchase parameter.", remoteException);
        }
    }

    public void setCorrelator(Correlator correlator) {
        this.zzwg = correlator;
        try {
            if (this.zzwh != null) {
                this.zzwh.zza(this.zzwg == null ? null : this.zzwg.zzaY());
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to set correlator.", remoteException);
        }
    }

    public void setRewardedVideoAdListener(RewardedVideoAdListener rewardedVideoAdListener) {
        try {
            this.zzaY = rewardedVideoAdListener;
            if (this.zzwh != null) {
                this.zzwh.zza(rewardedVideoAdListener != null ? new zzg(rewardedVideoAdListener) : null);
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to set the AdListener.", remoteException);
        }
    }

    public void zzc(boolean bl) {
        this.zzwr = bl;
    }

    public String getMediationAdapterClassName() {
        try {
            if (this.zzwh != null) {
                return this.zzwh.getMediationAdapterClassName();
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to get the mediation adapter class name.", remoteException);
        }
        return null;
    }

    public void show() {
        try {
            this.zzN("show");
            this.zzwh.showInterstitial();
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to show interstitial.", remoteException);
        }
    }

    private void zzM(String string) throws RemoteException {
        if (this.zzqO == null) {
            this.zzN(string);
        }
        AdSizeParcel adSizeParcel = this.zzwr ? AdSizeParcel.zzdC() : new AdSizeParcel();
        this.zzwh = zzm.zzdR().zzb(this.mContext, adSizeParcel, this.zzqO, this.zzwc);
        if (this.zzuM != null) {
            this.zzwh.zza(new zzc(this.zzuM));
        }
        if (this.zzuL != null) {
            this.zzwh.zza(new zzb(this.zzuL));
        }
        if (this.zzvy != null) {
            this.zzwh.zza(new zzj(this.zzvy));
        }
        if (this.zzwi != null) {
            this.zzwh.zza(new zzhm(this.zzwi));
        }
        if (this.zzwk != null) {
            this.zzwh.zza(new zzhq(this.zzwk), this.zzwm);
        }
        if (this.zzwj != null) {
            this.zzwh.zza(new zzdh(this.zzwj));
        }
        if (this.zzwg != null) {
            this.zzwh.zza(this.zzwg.zzaY());
        }
        if (this.zzaY != null) {
            this.zzwh.zza(new zzg(this.zzaY));
        }
    }

    private void zzN(String string) {
        if (this.zzwh == null) {
            throw new IllegalStateException(new StringBuilder(63 + String.valueOf(string).length()).append("The ad unit ID must be set on InterstitialAd before ").append(string).append(" is called.").toString());
        }
    }
}

