/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.search;

import android.content.Context;
import android.os.Bundle;
import com.google.ads.mediation.admob.AdMobAdapter;
import com.google.android.gms.ads.internal.client.zzad;
import com.google.android.gms.ads.mediation.MediationAdapter;
import com.google.android.gms.ads.mediation.NetworkExtras;
import com.google.android.gms.ads.mediation.customevent.CustomEvent;
import com.google.android.gms.ads.search.SearchAdRequest;

public final class DynamicHeightSearchAdRequest {
    private final SearchAdRequest zzTp;

    private DynamicHeightSearchAdRequest(Builder builder) {
        this.zzTp = builder.zzTq.build();
    }

    @Deprecated
    public <T extends NetworkExtras> T getNetworkExtras(Class<T> clazz) {
        return this.zzTp.getNetworkExtras(clazz);
    }

    public <T extends MediationAdapter> Bundle getNetworkExtrasBundle(Class<T> clazz) {
        return this.zzTp.getNetworkExtrasBundle(clazz);
    }

    public <T extends CustomEvent> Bundle getCustomEventExtrasBundle(Class<T> clazz) {
        return this.zzTp.getCustomEventExtrasBundle(clazz);
    }

    public String getQuery() {
        return this.zzTp.getQuery();
    }

    public boolean isTestDevice(Context context) {
        return this.zzTp.isTestDevice(context);
    }

    zzad zzaX() {
        return this.zzTp.zzaX();
    }

    public static final class Builder {
        private final SearchAdRequest.Builder zzTq = new SearchAdRequest.Builder();
        private final Bundle zzTr = new Bundle();

        public Builder addNetworkExtras(NetworkExtras networkExtras) {
            this.zzTq.addNetworkExtras(networkExtras);
            return this;
        }

        public Builder addNetworkExtrasBundle(Class<? extends MediationAdapter> clazz, Bundle bundle) {
            this.zzTq.addNetworkExtrasBundle(clazz, bundle);
            return this;
        }

        public Builder addCustomEventExtrasBundle(Class<? extends CustomEvent> clazz, Bundle bundle) {
            this.zzTq.addCustomEventExtrasBundle(clazz, bundle);
            return this;
        }

        public Builder setPage(int n) {
            this.zzTr.putString("csa_adPage", Integer.toString(n));
            return this;
        }

        public Builder setNumber(int n) {
            this.zzTr.putString("csa_number", Integer.toString(n));
            return this;
        }

        public Builder setAdTest(boolean bl) {
            this.zzTr.putString("csa_adtest", bl ? "on" : "off");
            return this;
        }

        public Builder setChannel(String string) {
            this.zzTr.putString("csa_channel", string);
            return this;
        }

        public Builder setHostLanguage(String string) {
            this.zzTr.putString("csa_hl", string);
            return this;
        }

        public Builder setLocationColor(String string) {
            this.zzTr.putString("csa_colorLocation", string);
            return this;
        }

        public Builder setLocationFontSize(int n) {
            this.zzTr.putString("csa_fontSizeLocation", Integer.toString(n));
            return this;
        }

        public Builder setIsClickToCallEnabled(boolean bl) {
            this.zzTr.putString("csa_clickToCall", Boolean.toString(bl));
            return this;
        }

        public Builder setIsLocationEnabled(boolean bl) {
            this.zzTr.putString("csa_location", Boolean.toString(bl));
            return this;
        }

        public Builder setIsPlusOnesEnabled(boolean bl) {
            this.zzTr.putString("csa_plusOnes", Boolean.toString(bl));
            return this;
        }

        public Builder setIsSellerRatingsEnabled(boolean bl) {
            this.zzTr.putString("csa_sellerRatings", Boolean.toString(bl));
            return this;
        }

        public Builder setIsSiteLinksEnabled(boolean bl) {
            this.zzTr.putString("csa_siteLinks", Boolean.toString(bl));
            return this;
        }

        public Builder setCssWidth(int n) {
            this.zzTr.putString("csa_width", Integer.toString(n));
            return this;
        }

        public Builder setFontFamily(int n) {
            this.zzTr.putString("csa_fontFamily", Integer.toString(n));
            return this;
        }

        public Builder setFontFamilyAttribution(String string) {
            this.zzTr.putString("csa_fontFamilyAttribution", string);
            return this;
        }

        public Builder setFontSizeAnnotation(int n) {
            this.zzTr.putString("csa_fontSizeAnnotation", Integer.toString(n));
            return this;
        }

        public Builder setFontSizeAttribution(int n) {
            this.zzTr.putString("csa_fontSizeAttribution", Integer.toString(n));
            return this;
        }

        public Builder setFontSizeDescription(int n) {
            this.zzTr.putString("csa_fontSizeDescription", Integer.toString(n));
            return this;
        }

        public Builder setFontSizeDomainLink(int n) {
            this.zzTr.putString("csa_fontSizeDomainLink", Integer.toString(n));
            return this;
        }

        public Builder setFontSizeTitle(int n) {
            this.zzTr.putString("csa_fontSizeTitle", Integer.toString(n));
            return this;
        }

        public Builder setColorAdBorder(String string) {
            this.zzTr.putString("csa_colorAdBorder", string);
            return this;
        }

        public Builder setColorAdSeparator(String string) {
            this.zzTr.putString("csa_colorAdSeparator", string);
            return this;
        }

        public Builder setColorAnnotation(String string) {
            this.zzTr.putString("csa_colorAnnotation", string);
            return this;
        }

        public Builder setColorAttribution(String string) {
            this.zzTr.putString("csa_colorAttribution", string);
            return this;
        }

        public Builder setColorBackground(String string) {
            this.zzTr.putString("csa_colorBackground", string);
            return this;
        }

        public Builder setColorBorder(String string) {
            this.zzTr.putString("csa_colorBorder", string);
            return this;
        }

        public Builder setColorDomainLink(String string) {
            this.zzTr.putString("csa_colorDomainLink", string);
            return this;
        }

        public Builder setColorText(String string) {
            this.zzTr.putString("csa_colorText", string);
            return this;
        }

        public Builder setColorTitleLink(String string) {
            this.zzTr.putString("csa_colorTitleLink", string);
            return this;
        }

        public Builder setAdBorderSelectors(String string) {
            this.zzTr.putString("csa_adBorderSelectors", string);
            return this;
        }

        public Builder setAdjustableLineHeight(int n) {
            this.zzTr.putString("csa_adjustableLineHeight", Integer.toString(n));
            return this;
        }

        public Builder setAttributionSpacingBelow(int n) {
            this.zzTr.putString("csa_attributionSpacingBelow", Integer.toString(n));
            return this;
        }

        public Builder setBorderSelections(String string) {
            this.zzTr.putString("csa_borderSelections", string);
            return this;
        }

        public Builder setIsTitleUnderlined(boolean bl) {
            this.zzTr.putString("csa_noTitleUnderline", Boolean.toString(!bl));
            return this;
        }

        public Builder setIsTitleBold(boolean bl) {
            this.zzTr.putString("csa_titleBold", Boolean.toString(bl));
            return this;
        }

        public Builder setVerticalSpacing(int n) {
            this.zzTr.putString("csa_verticalSpacing", Integer.toString(n));
            return this;
        }

        public Builder setDetailedAttribution(boolean bl) {
            this.zzTr.putString("csa_detailedAttribution", Boolean.toString(bl));
            return this;
        }

        public Builder setLongerHeadlines(boolean bl) {
            this.zzTr.putString("csa_longerHeadlines", Boolean.toString(bl));
            return this;
        }

        public Builder setAdvancedOptionValue(String string, String string2) {
            this.zzTr.putString(string, string2);
            return this;
        }

        public DynamicHeightSearchAdRequest build() {
            this.zzTq.addNetworkExtrasBundle(AdMobAdapter.class, this.zzTr);
            return new DynamicHeightSearchAdRequest(this);
        }

        public Builder setQuery(String string) {
            this.zzTq.setQuery(string);
            return this;
        }
    }
}

