/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.overlay;

import android.content.Context;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.view.Display;
import android.view.WindowManager;
import com.google.android.gms.internal.zzme;
import com.google.android.gms.internal.zzpk;

@zzme
class zzx
implements SensorEventListener {
    private final SensorManager zzOo;
    private final Object zzOp;
    private final Display zzOq;
    private final float[] zzOr;
    private final float[] zzOs;
    private float[] zzOt;
    private Handler zzOu;
    private zza zzOv;

    zzx(Context context) {
        this.zzOo = (SensorManager)context.getSystemService("sensor");
        WindowManager windowManager = (WindowManager)context.getSystemService("window");
        this.zzOq = windowManager.getDefaultDisplay();
        this.zzOr = new float[9];
        this.zzOs = new float[9];
        this.zzOp = new Object();
    }

    int getRotation() {
        return this.zzOq.getRotation();
    }

    void start() {
        if (this.zzOu != null) {
            return;
        }
        Sensor sensor = this.zzOo.getDefaultSensor(11);
        if (sensor == null) {
            zzpk.e((String)"No Sensor of TYPE_ROTATION_VECTOR");
            return;
        }
        HandlerThread handlerThread = new HandlerThread("OrientationMonitor");
        handlerThread.start();
        this.zzOu = new Handler(handlerThread.getLooper());
        boolean bl = this.zzOo.registerListener((SensorEventListener)this, sensor, 0, this.zzOu);
        if (!bl) {
            zzpk.e((String)"SensorManager.registerListener failed.");
            this.stop();
        }
    }

    void stop() {
        if (this.zzOu == null) {
            return;
        }
        this.zzOo.unregisterListener((SensorEventListener)this);
        this.zzOu.post(new Runnable(this){

            @Override
            public void run() {
                Looper.myLooper().quit();
            }
        });
        this.zzOu = null;
    }

    void zza(zza zza2) {
        this.zzOv = zza2;
    }

    public void onSensorChanged(SensorEvent sensorEvent) {
        this.zza(sensorEvent.values);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void zza(float[] fArray) {
        if (fArray[0] == 0.0f && fArray[1] == 0.0f && fArray[2] == 0.0f) {
            return;
        }
        Object object = this.zzOp;
        synchronized (object) {
            if (this.zzOt == null) {
                this.zzOt = new float[9];
            }
        }
        SensorManager.getRotationMatrixFromVector((float[])this.zzOr, (float[])fArray);
        int n = this.getRotation();
        switch (n) {
            case 1: {
                SensorManager.remapCoordinateSystem((float[])this.zzOr, (int)2, (int)129, (float[])this.zzOs);
                break;
            }
            case 2: {
                SensorManager.remapCoordinateSystem((float[])this.zzOr, (int)129, (int)130, (float[])this.zzOs);
                break;
            }
            case 3: {
                SensorManager.remapCoordinateSystem((float[])this.zzOr, (int)130, (int)1, (float[])this.zzOs);
                break;
            }
            default: {
                System.arraycopy(this.zzOr, 0, this.zzOs, 0, 9);
            }
        }
        this.zzi(1, 3);
        this.zzi(2, 6);
        this.zzi(5, 7);
        Object object2 = this.zzOp;
        synchronized (object2) {
            System.arraycopy(this.zzOs, 0, this.zzOt, 0, 9);
        }
        if (this.zzOv != null) {
            this.zzOv.zzhJ();
        }
    }

    public void onAccuracyChanged(Sensor sensor, int n) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean zzb(float[] fArray) {
        Object object = this.zzOp;
        synchronized (object) {
            if (this.zzOt == null) {
                return false;
            }
            System.arraycopy(this.zzOt, 0, fArray, 0, this.zzOt.length);
            return true;
        }
    }

    private void zzi(int n, int n2) {
        float f = this.zzOs[n];
        this.zzOs[n] = this.zzOs[n2];
        this.zzOs[n2] = f;
    }

    static interface zza {
        public void zzhJ();
    }
}

