/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Color;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Looper;
import android.os.RemoteException;
import android.os.SystemClock;
import android.text.TextUtils;
import com.google.android.gms.ads.internal.zzs;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.common.util.zzt;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.zzd;
import com.google.android.gms.internal.zzaw;
import com.google.android.gms.internal.zzgd;
import com.google.android.gms.internal.zzgl;
import com.google.android.gms.internal.zzgs;
import com.google.android.gms.internal.zzgu;
import com.google.android.gms.internal.zzgx;
import com.google.android.gms.internal.zzha;
import com.google.android.gms.internal.zzhb;
import com.google.android.gms.internal.zzhn;
import com.google.android.gms.internal.zzhr;
import com.google.android.gms.internal.zzhs;
import com.google.android.gms.internal.zzid;
import com.google.android.gms.internal.zzjj;
import com.google.android.gms.internal.zzlw;
import com.google.android.gms.internal.zzly;
import com.google.android.gms.internal.zzlz;
import com.google.android.gms.internal.zzma;
import com.google.android.gms.internal.zzmb;
import com.google.android.gms.internal.zzme;
import com.google.android.gms.internal.zzpb;
import com.google.android.gms.internal.zzpk;
import com.google.android.gms.internal.zzpo;
import com.google.android.gms.internal.zzpv;
import com.google.android.gms.internal.zzqj;
import com.google.android.gms.internal.zzqk;
import com.google.android.gms.internal.zzql;
import com.google.android.gms.internal.zzqm;
import com.google.android.gms.internal.zzqw;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@zzme
public class zzlx
implements Callable<zzpb> {
    static long zzQl = TimeUnit.SECONDS.toMillis(60L);
    private final Context mContext;
    private final zzpv zzQu;
    private final zzs zzQv;
    private final zzaw zzGP;
    private final zzlw zzGN;
    private final Object zzrJ = new Object();
    private final zzpb.zza zzPR;
    private final zzgl zzsn;
    private boolean zzQw;
    private int zzPY;
    private List<String> zzQx;
    private JSONObject zzQy;
    private String zzQz;

    public zzlx(Context context, zzs zzs2, zzpv zzpv2, zzaw zzaw2, zzpb.zza zza2, zzgl zzgl2) {
        this.mContext = context;
        this.zzQv = zzs2;
        this.zzQu = zzpv2;
        this.zzPR = zza2;
        this.zzGP = zzaw2;
        this.zzsn = zzgl2;
        this.zzGN = this.zza(context, zza2, zzs2, zzaw2);
        this.zzGN.zziT();
        this.zzQw = false;
        this.zzPY = -2;
        this.zzQx = null;
        this.zzQz = null;
    }

    public zzpb zzje() {
        try {
            this.zzGN.zziU();
            String string2 = this.zzjg();
            JSONObject jSONObject = this.zzaH(string2);
            zza zza2 = this.zzc(jSONObject);
            zzha.zza zza3 = this.zza(zza2, jSONObject, string2);
            this.zza(zza3);
            zzpb zzpb2 = this.zzb(zza3);
            return zzpb2;
        }
        catch (CancellationException cancellationException) {
        }
        catch (ExecutionException executionException) {
        }
        catch (InterruptedException interruptedException) {
        }
        catch (JSONException jSONException) {
            zzpk.zzc((String)"Malformed native JSON response.", (Throwable)jSONException);
        }
        catch (TimeoutException timeoutException) {
            zzpk.zzc((String)"Timeout when loading native ad.", (Throwable)timeoutException);
        }
        if (!this.zzQw) {
            this.zzU(0);
        }
        return this.zzb(null);
    }

    private JSONObject zzaH(final String string2) throws ExecutionException, InterruptedException, TimeoutException, JSONException {
        if (this.zzjf()) {
            return null;
        }
        final zzqj zzqj2 = new zzqj();
        final zzb zzb2 = new zzb(this);
        zzlw.zza zza2 = new zzlw.zza(){

            @Override
            public void zze(final zzjj zzjj2) {
                zzid zzid2;
                zzb2.zzQU = zzid2 = new zzid(){

                    @Override
                    public void zza(zzqw zzqw2, Map<String, String> map) {
                        try {
                            boolean bl;
                            JSONObject jSONObject;
                            String string2 = map.get("success");
                            String string3 = map.get("failure");
                            if (!TextUtils.isEmpty((CharSequence)string3)) {
                                jSONObject = new JSONObject(string3);
                                bl = false;
                            } else {
                                jSONObject = new JSONObject(string2);
                                bl = true;
                            }
                            if (!string2.equals(jSONObject.optString("ads_id", ""))) {
                                return;
                            }
                            zzjj2.zzb("/nativeAdPreProcess", zzb2.zzQU);
                            if (bl) {
                                JSONArray jSONArray = jSONObject.optJSONArray("ads");
                                if (jSONArray != null && jSONArray.length() > 0) {
                                    zzqj2.zzh(jSONArray.getJSONObject(0));
                                } else {
                                    zzlx.this.zzU(3);
                                    zzqj2.zzh(null);
                                }
                                return;
                            }
                        }
                        catch (JSONException jSONException) {
                            zzpk.zzb((String)"Malformed native JSON response.", (Throwable)jSONException);
                        }
                        zzlx.this.zzU(0);
                        zzac.zza((boolean)zzlx.this.zzjf(), (Object)"Unable to set the ad state error!");
                        zzqj2.zzh(null);
                    }
                };
                zzjj2.zza("/nativeAdPreProcess", zzid2);
                try {
                    JSONObject jSONObject = new JSONObject(((zzlx)zzlx.this).zzPR.zzWm.body);
                    jSONObject.put("ads_id", (Object)string2);
                    zzjj2.zza("google.afma.nativeAds.preProcessJsonGmsg", jSONObject);
                }
                catch (JSONException jSONException) {
                    zzpk.zzc((String)"Exception occurred while invoking javascript", (Throwable)jSONException);
                    zzqj2.zzh(null);
                }
            }

            @Override
            public void zzjd() {
                zzqj2.zzh(null);
            }
        };
        this.zzGN.zza(zza2);
        return (JSONObject)zzqj2.get(zzQl, TimeUnit.MILLISECONDS);
    }

    protected zza zzc(JSONObject jSONObject) throws ExecutionException, InterruptedException, JSONException, TimeoutException {
        boolean bl;
        if (this.zzjf() || jSONObject == null) {
            return null;
        }
        String string2 = jSONObject.getString("template_id");
        boolean bl2 = this.zzPR.zzTi.zzvF != null ? this.zzPR.zzTi.zzvF.zzHa : false;
        boolean bl3 = bl = this.zzPR.zzTi.zzvF != null ? this.zzPR.zzTi.zzvF.zzHc : false;
        if ("2".equals(string2)) {
            return new zzlz(bl2, bl);
        }
        if ("1".equals(string2)) {
            return new zzma(bl2, bl);
        }
        if ("3".equals(string2)) {
            final String string3 = jSONObject.getString("custom_template_id");
            final zzqj zzqj2 = new zzqj();
            zzpo.zzXC.post(new Runnable(){

                @Override
                public void run() {
                    zzqj2.zzh((zzhs)zzlx.this.zzQv.zzcu().get((Object)string3));
                }
            });
            if (zzqj2.get(zzQl, TimeUnit.MILLISECONDS) != null) {
                return new zzmb(bl2);
            }
            String string4 = String.valueOf(jSONObject.getString("custom_template_id"));
            zzpk.e((String)(string4.length() != 0 ? "No handler for custom template: ".concat(string4) : new String("No handler for custom template: ")));
        } else {
            this.zzU(0);
        }
        return null;
    }

    private void zza(zzha.zza zza2) {
        zzid zzid2;
        if (!(zza2 instanceof zzgx)) {
            return;
        }
        final zzgx zzgx2 = (zzgx)zza2;
        zzb zzb2 = new zzb(this);
        zzb2.zzQU = zzid2 = new zzid(){

            @Override
            public void zza(zzqw zzqw2, Map<String, String> map) {
                String string2 = map.get("asset");
                zzlx.this.zzb((zzhn)zzgx2, string2);
            }
        };
        this.zzGN.zza(new zzlw.zza(this){

            @Override
            public void zze(zzjj zzjj2) {
                zzjj2.zza("/nativeAdCustomClick", zzid2);
            }
        });
    }

    private void zzb(zzhn zzhn2, String string2) {
        try {
            zzhr zzhr2 = this.zzQv.zzz(zzhn2.getCustomTemplateId());
            if (zzhr2 != null) {
                zzhr2.zza(zzhn2, string2);
            }
        }
        catch (RemoteException remoteException) {
            zzpk.zzc((String)new StringBuilder(40 + String.valueOf(string2).length()).append("Failed to call onCustomClick for asset ").append(string2).append(".").toString(), (Throwable)remoteException);
        }
    }

    private zzha.zza zza(zza zza2, JSONObject jSONObject, String string2) throws ExecutionException, InterruptedException, JSONException {
        if (this.zzjf() || zza2 == null || jSONObject == null) {
            return null;
        }
        JSONObject jSONObject2 = jSONObject.getJSONObject("tracking_urls_and_actions");
        String[] stringArray = this.zzd(jSONObject2, "impression_tracking_urls");
        this.zzQx = stringArray == null ? null : Arrays.asList(stringArray);
        this.zzQy = jSONObject2.optJSONObject("active_view");
        this.zzQz = jSONObject.optString("debug_signals");
        Object t = zza2.zza(this, jSONObject);
        if (t == null) {
            zzpk.e((String)"Failed to retrieve ad assets.");
            return null;
        }
        t.zzb(new zzhb(this.mContext, this.zzQv, this.zzGN, this.zzGP, jSONObject, (zzha.zza)t, this.zzPR.zzTi.zzvn, string2));
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private zzpb zzb(zzha.zza zza2) {
        int n;
        Object object = this.zzrJ;
        synchronized (object) {
            n = this.zzPY;
            if (zza2 == null && this.zzPY == -2) {
                n = 0;
            }
        }
        if (n != -2) {
            zza2 = null;
        }
        return new zzpb(this.zzPR.zzTi.zzRy, null, this.zzPR.zzWm.zzKF, n, this.zzPR.zzWm.zzKG, this.zzQx, this.zzPR.zzWm.orientation, this.zzPR.zzWm.zzKL, this.zzPR.zzTi.zzRB, false, null, null, null, null, null, 0L, this.zzPR.zzvr, this.zzPR.zzWm.zzSm, this.zzPR.zzWg, this.zzPR.zzWh, this.zzPR.zzWm.zzSs, this.zzQy, zza2, null, null, null, this.zzPR.zzWm.zzSF, this.zzPR.zzWm.zzSG, null, this.zzPR.zzWm.zzKI, this.zzQz);
    }

    public zzqm<zzgs> zzd(JSONObject jSONObject) throws JSONException {
        JSONObject jSONObject2 = jSONObject.optJSONObject("attribution");
        if (jSONObject2 == null) {
            return new zzqk<Object>(null);
        }
        final String string2 = jSONObject2.optString("text");
        final int n = jSONObject2.optInt("text_size", -1);
        final Integer n2 = this.zzb(jSONObject2, "text_color");
        final Integer n3 = this.zzb(jSONObject2, "bg_color");
        final int n4 = jSONObject2.optInt("animation_ms", 1000);
        final int n5 = jSONObject2.optInt("presentation_ms", 4000);
        final int n6 = this.zzPR.zzTi.zzvF != null && this.zzPR.zzTi.zzvF.versionCode >= 2 ? this.zzPR.zzTi.zzvF.zzHd : 1;
        final boolean bl = jSONObject2.optBoolean("allow_pub_rendering");
        ArrayList arrayList = new ArrayList<zzqm<zzgu>>();
        if (jSONObject2.optJSONArray("images") != null) {
            arrayList = this.zza(jSONObject2, "images", false, false, true);
        } else {
            arrayList.add(this.zza(jSONObject2, "image", false, false));
        }
        zzqm zzqm2 = zzql.zzo(arrayList);
        return zzql.zza(zzqm2, new zzql.zza<List<zzgu>, zzgs>(this){

            public zzgs zzj(List<zzgu> list) {
                try {
                    return list == null || list.isEmpty() ? null : new zzgs(string2, zzlx.zzh(list), n3, n2, n > 0 ? Integer.valueOf(n) : null, n5 + n4, n6, bl);
                }
                catch (RemoteException remoteException) {
                    zzpk.zzb((String)"Could not get attribution icon", (Throwable)remoteException);
                    return null;
                }
            }

            @Override
            public /* synthetic */ Object apply(Object object) {
                return this.zzj((List)object);
            }
        });
    }

    private Integer zzb(JSONObject jSONObject, String string2) {
        try {
            JSONObject jSONObject2 = jSONObject.getJSONObject(string2);
            int n = jSONObject2.getInt("r");
            int n2 = jSONObject2.getInt("g");
            int n3 = jSONObject2.getInt("b");
            return Color.rgb((int)n, (int)n2, (int)n3);
        }
        catch (JSONException jSONException) {
            return null;
        }
    }

    public Future<zzgu> zza(JSONObject jSONObject, String string2, boolean bl) throws JSONException {
        JSONObject jSONObject2 = jSONObject.getJSONObject(string2);
        boolean bl2 = jSONObject2.optBoolean("require", true);
        jSONObject2 = jSONObject2 == null ? new JSONObject() : jSONObject2;
        return this.zza(jSONObject2, bl2, bl);
    }

    public zzqm<zzgu> zza(JSONObject jSONObject, String string2, boolean bl, boolean bl2) throws JSONException {
        JSONObject jSONObject2 = bl ? jSONObject.getJSONObject(string2) : jSONObject.optJSONObject(string2);
        jSONObject2 = jSONObject2 == null ? new JSONObject() : jSONObject2;
        return this.zza(jSONObject2, bl, bl2);
    }

    public List<zzqm<zzgu>> zza(JSONObject jSONObject, String string2, boolean bl, boolean bl2, boolean bl3) throws JSONException {
        JSONArray jSONArray = bl ? jSONObject.getJSONArray(string2) : jSONObject.optJSONArray(string2);
        ArrayList<zzqm<zzgu>> arrayList = new ArrayList<zzqm<zzgu>>();
        if (jSONArray == null || jSONArray.length() == 0) {
            this.zza(0, bl);
            return arrayList;
        }
        int n = bl3 ? jSONArray.length() : 1;
        for (int i = 0; i < n; ++i) {
            JSONObject jSONObject2 = jSONArray.getJSONObject(i);
            jSONObject2 = jSONObject2 == null ? new JSONObject() : jSONObject2;
            arrayList.add(this.zza(jSONObject2, bl, bl2));
        }
        return arrayList;
    }

    private zzqm<zzgu> zza(JSONObject jSONObject, final boolean bl, boolean bl2) throws JSONException {
        final String string2 = bl ? jSONObject.getString("url") : jSONObject.optString("url");
        final double d = jSONObject.optDouble("scale", 1.0);
        final boolean bl3 = jSONObject.optBoolean("is_transparent", true);
        if (TextUtils.isEmpty((CharSequence)string2)) {
            this.zza(0, bl);
            return new zzqk<Object>(null);
        }
        if (bl2) {
            return new zzqk<zzgu>(new zzgu(null, Uri.parse((String)string2), d));
        }
        return this.zzQu.zza(string2, new zzpv.zza<zzgu>(){

            public zzgu zzjh() {
                zzlx.this.zza(2, bl);
                return null;
            }

            @TargetApi(value=19)
            public zzgu zzg(InputStream inputStream) {
                Bitmap bitmap = null;
                BitmapFactory.Options options = new BitmapFactory.Options();
                options.inDensity = (int)(160.0 * d);
                if (!bl3) {
                    options.inPreferredConfig = Bitmap.Config.RGB_565;
                }
                long l = SystemClock.uptimeMillis();
                try {
                    bitmap = BitmapFactory.decodeStream((InputStream)inputStream, null, (BitmapFactory.Options)options);
                }
                catch (Exception exception) {
                    zzpk.zzb((String)"Error grabbing image.", (Throwable)exception);
                }
                if (bitmap == null) {
                    zzlx.this.zza(2, bl);
                    return null;
                }
                long l2 = SystemClock.uptimeMillis();
                if (zzt.zzzl() && zzpk.zzkI()) {
                    int n = bitmap.getWidth();
                    int n2 = bitmap.getHeight();
                    int n3 = bitmap.getAllocationByteCount();
                    long l3 = l2 - l;
                    boolean bl2 = Looper.getMainLooper().getThread() == Thread.currentThread();
                    zzpk.v(new StringBuilder(108).append("Decoded image w: ").append(n).append(" h:").append(n2).append(" bytes: ").append(n3).append(" time: ").append(l3).append(" on ui thread: ").append(bl2).toString());
                }
                return new zzgu((Drawable)new BitmapDrawable(Resources.getSystem(), bitmap), Uri.parse((String)string2), d);
            }

            @Override
            public /* synthetic */ Object zzji() {
                return this.zzjh();
            }

            @Override
            @TargetApi(value=19)
            public /* synthetic */ Object zzh(InputStream inputStream) {
                return this.zzg(inputStream);
            }
        });
    }

    public zzqm<zzqw> zzc(JSONObject jSONObject, String string2) throws JSONException {
        JSONObject jSONObject2 = jSONObject.optJSONObject(string2);
        if (jSONObject2 == null) {
            return new zzqk<Object>(null);
        }
        String string3 = jSONObject2.optString("vast_xml");
        if (TextUtils.isEmpty((CharSequence)string3)) {
            zzpk.zzbh((String)"Required field 'vast_xml' is missing");
            return new zzqk<Object>(null);
        }
        return this.zza(this.mContext, this.zzGP, this.zzPR, this.zzsn, this.zzQv).zze(jSONObject2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean zzjf() {
        Object object = this.zzrJ;
        synchronized (object) {
            return this.zzQw;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzU(int n) {
        Object object = this.zzrJ;
        synchronized (object) {
            this.zzQw = true;
            this.zzPY = n;
        }
    }

    public void zza(int n, boolean bl) {
        if (bl) {
            this.zzU(n);
        }
    }

    static zzqw zzb(zzqm<zzqw> zzqm2) {
        try {
            return (zzqw)zzqm2.get(zzgd.zzEs.get().intValue(), TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            zzpk.zzc((String)"InterruptedException occurred while waiting for video to load", (Throwable)interruptedException);
            Thread.currentThread().interrupt();
        }
        catch (CancellationException | ExecutionException | TimeoutException exception) {
            zzpk.zzc((String)"Exception occurred while waiting for video to load", (Throwable)exception);
        }
        return null;
    }

    private String[] zzd(JSONObject jSONObject, String string2) throws JSONException {
        JSONArray jSONArray = jSONObject.optJSONArray(string2);
        if (jSONArray == null) {
            return null;
        }
        String[] stringArray = new String[jSONArray.length()];
        for (int i = 0; i < jSONArray.length(); ++i) {
            stringArray[i] = jSONArray.getString(i);
        }
        return stringArray;
    }

    private static List<Drawable> zzh(List<zzgu> list) throws RemoteException {
        ArrayList<Drawable> arrayList = new ArrayList<Drawable>();
        for (zzgu zzgu2 : list) {
            arrayList.add((Drawable)zzd.zzF((IObjectWrapper)zzgu2.zzfP()));
        }
        return arrayList;
    }

    zzlw zza(Context context, zzpb.zza zza2, zzs zzs2, zzaw zzaw2) {
        return new zzlw(context, zza2, zzs2, zzaw2);
    }

    zzly zza(Context context, zzaw zzaw2, zzpb.zza zza2, zzgl zzgl2, zzs zzs2) {
        return new zzly(context, zzaw2, zza2, zzgl2, zzs2);
    }

    String zzjg() {
        return UUID.randomUUID().toString();
    }

    @Override
    public /* synthetic */ Object call() throws Exception {
        return this.zzje();
    }

    class zzb {
        public zzid zzQU;

        zzb(zzlx zzlx2) {
        }
    }

    public static interface zza<T extends zzha.zza> {
        public T zza(zzlx var1, JSONObject var2) throws JSONException, InterruptedException, ExecutionException;
    }
}

