/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.res.Resources;
import android.net.Uri;
import android.text.TextUtils;
import android.view.MotionEvent;
import com.google.android.gms.R;
import com.google.android.gms.ads.internal.zzw;
import com.google.android.gms.internal.zzgd;
import com.google.android.gms.internal.zzme;
import com.google.android.gms.internal.zzpk;
import com.google.android.gms.internal.zzpn;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@zzme
public class zzpr {
    private final Context mContext;
    private String zzXK;
    private String zzts;
    private String zzwd;
    private final float zzMx;
    private float zzXL;
    private float zzXM;
    private float zzXN;
    private int mState = 0;

    public zzpr(Context context) {
        this.mContext = context;
        this.zzMx = context.getResources().getDisplayMetrics().density;
    }

    public zzpr(Context context, String string2) {
        this(context);
        this.zzXK = string2;
    }

    public void zzg(MotionEvent motionEvent) {
        int n = motionEvent.getHistorySize();
        for (int i = 0; i < n; ++i) {
            this.zza(motionEvent.getActionMasked(), motionEvent.getHistoricalX(0, i), motionEvent.getHistoricalY(0, i));
        }
        this.zza(motionEvent.getActionMasked(), motionEvent.getX(), motionEvent.getY());
    }

    void zza(int n, float f, float f2) {
        if (n == 0) {
            this.mState = 0;
            this.zzXL = f;
            this.zzXM = f2;
            this.zzXN = f2;
        } else {
            if (this.mState == -1) {
                return;
            }
            if (n == 2) {
                if (f2 > this.zzXM) {
                    this.zzXM = f2;
                } else if (f2 < this.zzXN) {
                    this.zzXN = f2;
                }
                if (this.zzXM - this.zzXN > 30.0f * this.zzMx) {
                    this.mState = -1;
                    return;
                }
                if (this.mState == 0 || this.mState == 2) {
                    if (f - this.zzXL >= 50.0f * this.zzMx) {
                        this.zzXL = f;
                        ++this.mState;
                    }
                } else if ((this.mState == 1 || this.mState == 3) && f - this.zzXL <= -50.0f * this.zzMx) {
                    this.zzXL = f;
                    ++this.mState;
                }
                if (this.mState == 1 || this.mState == 3) {
                    if (f > this.zzXL) {
                        this.zzXL = f;
                    }
                } else if (this.mState == 2 && f < this.zzXL) {
                    this.zzXL = f;
                }
            } else if (n == 1 && this.mState == 4) {
                this.showDialog();
            }
        }
    }

    public void showDialog() {
        if (zzgd.zzFm.get().booleanValue() || zzgd.zzFl.get().booleanValue()) {
            this.zzkU();
        } else {
            this.zzkV();
        }
    }

    public void setAdUnitId(String string2) {
        this.zzts = string2;
    }

    public void zzba(String string2) {
        this.zzwd = string2;
    }

    public void zzbb(String string2) {
        this.zzXK = string2;
    }

    private void zzkU() {
        if (!(this.mContext instanceof Activity)) {
            zzpk.zzbg((String)"Can not create dialog without Activity Context");
            return;
        }
        Resources resources = zzw.zzcQ().getResources();
        String string2 = resources != null ? resources.getString(R.string.debug_menu_title) : "Select a Debug Mode";
        String string3 = resources != null ? resources.getString(R.string.debug_menu_ad_information) : "Ad Information";
        String string4 = resources != null ? resources.getString(R.string.debug_menu_creative_preview) : "Creative Preview";
        String string5 = resources != null ? resources.getString(R.string.debug_menu_troubleshooting) : "Troubleshooting";
        ArrayList<String> arrayList = new ArrayList<String>();
        final int n = this.zza(arrayList, string3, true);
        final int n2 = this.zza(arrayList, string4, zzgd.zzFl.get());
        final int n3 = this.zza(arrayList, string5, zzgd.zzFm.get());
        AlertDialog.Builder builder = new AlertDialog.Builder(this.mContext).setTitle((CharSequence)string2).setItems((CharSequence[])arrayList.toArray(new String[0]), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int n4) {
                if (n4 == n) {
                    zzpr.this.zzkV();
                } else if (n4 == n2 && zzgd.zzFl.get().booleanValue()) {
                    zzpr.this.zzkW();
                } else if (n4 == n3 && zzgd.zzFm.get().booleanValue()) {
                    zzpr.this.zzkX();
                }
            }
        });
        AlertDialog alertDialog = builder.create();
        alertDialog.show();
    }

    private int zza(List<String> list, String string2, boolean bl) {
        if (!bl) {
            return -1;
        }
        list.add(string2);
        return list.size() - 1;
    }

    private void zzkV() {
        if (!(this.mContext instanceof Activity)) {
            zzpk.zzbg((String)"Can not create dialog without Activity Context");
            return;
        }
        final String string2 = zzpr.zzbc(this.zzXK);
        AlertDialog.Builder builder = new AlertDialog.Builder(this.mContext);
        builder.setMessage((CharSequence)string2);
        builder.setTitle((CharSequence)"Ad Information");
        builder.setPositiveButton((CharSequence)"Share", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int n) {
                zzw.zzcM().zzb(zzpr.this.mContext, Intent.createChooser((Intent)new Intent("android.intent.action.SEND").setType("text/plain").putExtra("android.intent.extra.TEXT", string2), (CharSequence)"Share via"));
            }
        });
        builder.setNegativeButton((CharSequence)"Close", new DialogInterface.OnClickListener(this){

            public void onClick(DialogInterface dialogInterface, int n) {
            }
        });
        AlertDialog alertDialog = builder.create();
        alertDialog.show();
    }

    private void zzkW() {
        zzpk.zzbf((String)"Debug mode [Creative Preview] selected.");
        zzpn.zza(new Runnable(){

            @Override
            public void run() {
                zzw.zzcU().zzh(zzpr.this.mContext, zzpr.this.zzts, zzpr.this.zzwd);
            }
        });
    }

    private void zzkX() {
        zzpk.zzbf((String)"Debug mode [Troubleshooting] selected.");
        zzpn.zza(new Runnable(){

            @Override
            public void run() {
                zzw.zzcU().zzi(zzpr.this.mContext, zzpr.this.zzts, zzpr.this.zzwd);
            }
        });
    }

    static String zzbc(String string2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return "No debug information";
        }
        string2 = string2.replaceAll("\\+", "%20");
        Uri uri = new Uri.Builder().encodedQuery(string2).build();
        StringBuilder stringBuilder = new StringBuilder();
        Map<String, String> map = zzw.zzcM().zzg(uri);
        for (String string3 : map.keySet()) {
            stringBuilder.append(string3).append(" = ").append(map.get(string3)).append("\n\n");
        }
        String string4 = stringBuilder.toString().trim();
        return !TextUtils.isEmpty((CharSequence)string4) ? string4 : "No debug information";
    }
}

