/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.overlay;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.Window;
import android.webkit.WebChromeClient;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;
import com.google.android.gms.ads.internal.overlay.AdOverlayInfoParcel;
import com.google.android.gms.ads.internal.overlay.zzm;
import com.google.android.gms.ads.internal.overlay.zzn;
import com.google.android.gms.ads.internal.overlay.zzp;
import com.google.android.gms.ads.internal.overlay.zzt;
import com.google.android.gms.ads.internal.overlay.zzv;
import com.google.android.gms.ads.internal.zzw;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.internal.zzgd;
import com.google.android.gms.internal.zzkz;
import com.google.android.gms.internal.zzme;
import com.google.android.gms.internal.zzpj;
import com.google.android.gms.internal.zzpk;
import com.google.android.gms.internal.zzpo;
import com.google.android.gms.internal.zzpr;
import com.google.android.gms.internal.zzqw;
import com.google.android.gms.internal.zzqx;
import java.util.Collections;
import java.util.Map;

@zzme
public class zze
extends zzkz.zza
implements zzv {
    static final int zzNf = Color.argb((int)0, (int)0, (int)0, (int)0);
    private final Activity mActivity;
    AdOverlayInfoParcel zzNg;
    zzqw zzIs;
    zzc zzNh;
    zzp zzNi;
    boolean zzNj = false;
    FrameLayout zzNk;
    WebChromeClient.CustomViewCallback zzNl;
    boolean zzNm = false;
    boolean zzNn = false;
    zzb zzNo;
    boolean zzNp = false;
    int zzNq = 0;
    zzm zzNr;
    private final Object zzNs = new Object();
    private Runnable zzNt;
    private boolean zzNu;
    private boolean zzNv;
    private boolean zzNw = false;
    private boolean zzNx = false;
    private boolean zzNy = true;

    public zze(Activity activity) {
        this.mActivity = activity;
        this.zzNr = new zzt();
    }

    public void close() {
        this.zzNq = 2;
        this.mActivity.finish();
    }

    public void zzhD() {
        if (this.zzNg != null && this.zzNj) {
            this.setRequestedOrientation(this.zzNg.orientation);
        }
        if (this.zzNk != null) {
            this.mActivity.setContentView((View)this.zzNo);
            this.zzbo();
            this.zzNk.removeAllViews();
            this.zzNk = null;
        }
        if (this.zzNl != null) {
            this.zzNl.onCustomViewHidden();
            this.zzNl = null;
        }
        this.zzNj = false;
    }

    @Override
    public void zzhE() {
        this.zzNq = 1;
        this.mActivity.finish();
    }

    public void onBackPressed() {
        this.zzNq = 0;
    }

    public boolean zzhF() {
        boolean bl;
        this.zzNq = 0;
        if (this.zzIs == null) {
            return true;
        }
        boolean bl2 = bl = this.zzIs.zzlB();
        if (!bl) {
            this.zzIs.zza("onbackblocked", Collections.emptyMap());
        }
        return bl;
    }

    public void onCreate(Bundle bundle) {
        this.mActivity.requestWindowFeature(1);
        this.zzNm = bundle != null ? bundle.getBoolean("com.google.android.gms.ads.internal.overlay.hasResumed", false) : false;
        try {
            this.zzNg = AdOverlayInfoParcel.zzb(this.mActivity.getIntent());
            if (this.zzNg == null) {
                throw new zza("Could not get info for ad overlay.");
            }
            if (this.zzNg.zzvn.zzYX > 7500000) {
                this.zzNq = 3;
            }
            if (this.mActivity.getIntent() != null) {
                this.zzNy = this.mActivity.getIntent().getBooleanExtra("shouldCallOnOverlayOpened", true);
            }
            this.zzNn = this.zzNg.zzNQ != null ? this.zzNg.zzNQ.zztK : false;
            if (zzgd.zzEa.get().booleanValue() && this.zzNn && this.zzNg.zzNQ.zztP != -1) {
                new zzd().zziP();
            }
            if (bundle == null) {
                if (this.zzNg.zzNG != null && this.zzNy) {
                    this.zzNg.zzNG.zzbO();
                }
                if (this.zzNg.zzNN != 1 && this.zzNg.zzNF != null) {
                    this.zzNg.zzNF.onAdClicked();
                }
            }
            this.zzNo = new zzb((Context)this.mActivity, this.zzNg.zzNP, this.zzNg.zzvn.zzba);
            this.zzNo.setId(1000);
            switch (this.zzNg.zzNN) {
                case 1: {
                    this.zzA(false);
                    break;
                }
                case 2: {
                    this.zzNh = new zzc(this.zzNg.zzNH);
                    this.zzA(false);
                    break;
                }
                case 3: {
                    this.zzA(true);
                    break;
                }
                case 4: {
                    if (this.zzNm) {
                        this.zzNq = 3;
                        this.mActivity.finish();
                        break;
                    }
                    if (!zzw.zzcJ().zza((Context)this.mActivity, this.zzNg.zzNE, this.zzNg.zzNM)) {
                        this.zzNq = 3;
                        this.mActivity.finish();
                    }
                    break;
                }
                default: {
                    throw new zza("Could not determine ad overlay type.");
                }
            }
        }
        catch (zza zza2) {
            zzpk.zzbh((String)zza2.getMessage());
            this.zzNq = 3;
            this.mActivity.finish();
        }
    }

    public void onRestart() {
    }

    public void onStart() {
        boolean bl = zzgd.zzFu.get();
        if (bl) {
            if (this.zzIs != null && !this.zzIs.isDestroyed()) {
                zzw.zzcO().zzm(this.zzIs);
            } else {
                zzpk.zzbh((String)"The webview does not exist. Ignoring action.");
            }
        }
    }

    public void onResume() {
        boolean bl;
        if (this.zzNg != null && this.zzNg.zzNN == 4) {
            if (this.zzNm) {
                this.zzNq = 3;
                this.mActivity.finish();
            } else {
                this.zzNm = true;
            }
        }
        if (this.zzNg.zzNG != null) {
            this.zzNg.zzNG.onResume();
        }
        if (!(bl = zzgd.zzFu.get().booleanValue())) {
            if (this.zzIs != null && !this.zzIs.isDestroyed()) {
                zzw.zzcO().zzm(this.zzIs);
            } else {
                zzpk.zzbh((String)"The webview does not exist. Ignoring action.");
            }
        }
    }

    public void onPause() {
        boolean bl;
        this.zzhD();
        if (this.zzNg.zzNG != null) {
            this.zzNg.zzNG.onPause();
        }
        if (!((bl = zzgd.zzFu.get().booleanValue()) || this.zzIs == null || this.mActivity.isFinishing() && this.zzNh != null)) {
            zzw.zzcO().zzl(this.zzIs);
        }
        this.zzhH();
    }

    public void onActivityResult(int n, int n2, Intent intent) {
    }

    public void zzo(IObjectWrapper iObjectWrapper) {
        if (zzgd.zzFt.get().booleanValue() && com.google.android.gms.common.util.zzt.isAtLeastN()) {
            Configuration configuration = (Configuration)com.google.android.gms.dynamic.zzd.zzF((IObjectWrapper)iObjectWrapper);
            if (zzw.zzcM().zza(this.mActivity, configuration)) {
                this.mActivity.getWindow().addFlags(1024);
                this.mActivity.getWindow().clearFlags(2048);
            } else {
                this.mActivity.getWindow().addFlags(2048);
                this.mActivity.getWindow().clearFlags(1024);
            }
        }
    }

    public void onSaveInstanceState(Bundle bundle) {
        bundle.putBoolean("com.google.android.gms.ads.internal.overlay.hasResumed", this.zzNm);
    }

    public void onStop() {
        boolean bl = zzgd.zzFu.get();
        if (bl && this.zzIs != null && (!this.mActivity.isFinishing() || this.zzNh == null)) {
            zzw.zzcO().zzl(this.zzIs);
        }
        this.zzhH();
    }

    public void onDestroy() {
        if (this.zzIs != null) {
            this.zzNo.removeView(this.zzIs.getView());
        }
        this.zzhH();
    }

    public void zzz(boolean bl) {
        int n = zzgd.zzFv.get();
        zzp.zza zza2 = new zzp.zza();
        zza2.size = 50;
        zza2.paddingLeft = bl ? n : 0;
        zza2.paddingRight = bl ? 0 : n;
        zza2.paddingTop = 0;
        zza2.paddingBottom = n;
        this.zzNi = new zzp((Context)this.mActivity, zza2, this);
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-2, -2);
        layoutParams.addRule(10);
        int n2 = bl ? 11 : 9;
        layoutParams.addRule(n2);
        this.zzNi.zza(bl, this.zzNg.zzNK);
        this.zzNo.addView((View)this.zzNi, (ViewGroup.LayoutParams)layoutParams);
    }

    public void zzbo() {
        this.zzNv = true;
    }

    public void zza(boolean bl, boolean bl2) {
        if (this.zzNi != null) {
            this.zzNi.zza(bl, bl2);
        }
    }

    public void zzhG() {
        this.zzNo.removeView((View)this.zzNi);
        this.zzz(true);
    }

    public void setRequestedOrientation(int n) {
        this.mActivity.setRequestedOrientation(n);
    }

    public void zza(View view, WebChromeClient.CustomViewCallback customViewCallback) {
        this.zzNk = new FrameLayout((Context)this.mActivity);
        this.zzNk.setBackgroundColor(-16777216);
        this.zzNk.addView(view, -1, -1);
        this.mActivity.setContentView((View)this.zzNk);
        this.zzbo();
        this.zzNl = customViewCallback;
        this.zzNj = true;
    }

    protected void zzA(boolean bl) throws zza {
        com.google.android.gms.ads.internal.zze zze2;
        zzn zzn2;
        zzqx zzqx2;
        boolean bl2;
        Window window;
        if (!this.zzNv) {
            this.mActivity.requestWindowFeature(1);
        }
        if ((window = this.mActivity.getWindow()) == null) {
            throw new zza("Invalid activity, no window available.");
        }
        boolean bl3 = true;
        if (com.google.android.gms.common.util.zzt.isAtLeastN() && zzgd.zzFt.get().booleanValue()) {
            bl3 = zzw.zzcM().zza(this.mActivity, this.mActivity.getResources().getConfiguration());
        }
        boolean bl4 = bl2 = this.zzNg.zzNQ != null && this.zzNg.zzNQ.zztL;
        if ((!this.zzNn || bl2) && bl3) {
            window.setFlags(1024, 1024);
        }
        boolean bl5 = (zzqx2 = this.zzNg.zzNH.zzlv()) != null ? zzqx2.zzdD() : false;
        this.zzNp = false;
        if (bl5) {
            if (this.zzNg.orientation == zzw.zzcO().zzkQ()) {
                this.zzNp = this.mActivity.getResources().getConfiguration().orientation == 1;
            } else if (this.zzNg.orientation == zzw.zzcO().zzkR()) {
                this.zzNp = this.mActivity.getResources().getConfiguration().orientation == 2;
            }
        }
        boolean bl6 = this.zzNp;
        zzpk.zzbf((String)new StringBuilder(46).append("Delay onShow to next orientation change: ").append(bl6).toString());
        this.setRequestedOrientation(this.zzNg.orientation);
        if (zzw.zzcO().zza(window)) {
            zzpk.zzbf((String)"Hardware acceleration on the AdActivity window enabled.");
        }
        if (!this.zzNn) {
            this.zzNo.setBackgroundColor(-16777216);
        } else {
            this.zzNo.setBackgroundColor(zzNf);
        }
        this.mActivity.setContentView((View)this.zzNo);
        this.zzbo();
        if (bl) {
            this.zzIs = zzw.zzcN().zza((Context)this.mActivity, this.zzNg.zzNH.zzbC(), true, bl5, null, this.zzNg.zzvn, null, null, this.zzNg.zzNH.zzby());
            this.zzIs.zzlv().zza(null, null, this.zzNg.zzNI, this.zzNg.zzNM, true, this.zzNg.zzNO, null, this.zzNg.zzNH.zzlv().zzlN(), null, null);
            this.zzIs.zzlv().zza(new zzqx.zza(this){

                @Override
                public void zza(zzqw zzqw2, boolean bl) {
                    zzqw2.zzhK();
                }
            });
            if (this.zzNg.url != null) {
                this.zzIs.loadUrl(this.zzNg.url);
            } else if (this.zzNg.zzNL != null) {
                this.zzIs.loadDataWithBaseURL(this.zzNg.zzNJ, this.zzNg.zzNL, "text/html", "UTF-8", null);
            } else {
                throw new zza("No URL or HTML to display in ad overlay.");
            }
            if (this.zzNg.zzNH != null) {
                this.zzNg.zzNH.zzc(this);
            }
        } else {
            this.zzIs = this.zzNg.zzNH;
            this.zzIs.setContext((Context)this.mActivity);
        }
        this.zzIs.zzb(this);
        ViewParent viewParent = this.zzIs.getParent();
        if (viewParent != null && viewParent instanceof ViewGroup) {
            ((ViewGroup)viewParent).removeView(this.zzIs.getView());
        }
        if (this.zzNn) {
            this.zzIs.zzlM();
        }
        this.zzNo.addView(this.zzIs.getView(), -1, -1);
        if (!bl && !this.zzNp) {
            this.zzhK();
        }
        this.zzz(bl5);
        if (this.zzIs.zzlw()) {
            this.zza(bl5, true);
        }
        zzn zzn3 = zzn2 = (zze2 = this.zzIs.zzby()) != null ? zze2.zzsO : null;
        if (zzn2 != null) {
            this.zzNr = zzn2.zza(this.mActivity, this.zzIs, this.zzNo);
        } else {
            zzpk.zzbh((String)"Appstreaming controller is null.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void zzhH() {
        if (!this.mActivity.isFinishing() || this.zzNw) {
            return;
        }
        this.zzNw = true;
        if (this.zzIs != null) {
            this.zzM(this.zzNq);
            Object object = this.zzNs;
            synchronized (object) {
                if (!this.zzNu && this.zzIs.zzlH()) {
                    this.zzNt = new Runnable(){

                        @Override
                        public void run() {
                            zze.this.zzhI();
                        }
                    };
                    zzpo.zzXC.postDelayed(this.zzNt, zzgd.zzCY.get().longValue());
                    return;
                }
            }
        }
        this.zzhI();
    }

    void zzhI() {
        if (this.zzNx) {
            return;
        }
        this.zzNx = true;
        if (this.zzIs != null) {
            this.zzNo.removeView(this.zzIs.getView());
            if (this.zzNh != null) {
                this.zzIs.setContext(this.zzNh.zzqn);
                this.zzIs.zzK(false);
                this.zzNh.parent.addView(this.zzIs.getView(), this.zzNh.index, this.zzNh.zzNB);
                this.zzNh = null;
            } else if (this.mActivity.getApplicationContext() != null) {
                this.zzIs.setContext(this.mActivity.getApplicationContext());
            }
            this.zzIs = null;
        }
        if (this.zzNg != null && this.zzNg.zzNG != null) {
            this.zzNg.zzNG.zzbN();
        }
    }

    public void zzhJ() {
        if (this.zzNp) {
            this.zzNp = false;
            this.zzhK();
        }
    }

    protected void zzhK() {
        this.zzIs.zzhK();
    }

    protected void zzM(int n) {
        this.zzIs.zzM(n);
    }

    public void zzg(zzqw zzqw2, Map<String, String> map) {
    }

    public void zzhL() {
        this.zzNo.disable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzhM() {
        Object object = this.zzNs;
        synchronized (object) {
            this.zzNu = true;
            if (this.zzNt != null) {
                zzpo.zzXC.removeCallbacks(this.zzNt);
                zzpo.zzXC.post(this.zzNt);
            }
        }
    }

    @zzme
    private class zzd
    extends zzpj {
        private zzd() {
        }

        @Override
        public void zzco() {
            Bitmap bitmap = zzw.zzdh().zza(zze.this.zzNg.zzNQ.zztP);
            if (bitmap != null) {
                final Drawable drawable = zzw.zzcO().zza((Context)zze.this.mActivity, bitmap, zze.this.zzNg.zzNQ.zztN, zze.this.zzNg.zzNQ.zztO);
                zzpo.zzXC.post(new Runnable(){

                    @Override
                    public void run() {
                        zze.this.mActivity.getWindow().setBackgroundDrawable(drawable);
                    }
                });
            }
        }

        @Override
        public void onStop() {
        }
    }

    @zzme
    static class zzb
    extends RelativeLayout {
        zzpr zzvX;
        boolean zzNA;

        public zzb(Context context, String string2, String string3) {
            super(context);
            this.zzvX = new zzpr(context, string2);
            this.zzvX.zzba(string3);
        }

        public boolean onInterceptTouchEvent(MotionEvent motionEvent) {
            if (!this.zzNA) {
                this.zzvX.zzg(motionEvent);
            }
            return false;
        }

        void disable() {
            this.zzNA = true;
        }
    }

    @zzme
    public static class zzc {
        public final int index;
        public final ViewGroup.LayoutParams zzNB;
        public final ViewGroup parent;
        public final Context zzqn;

        public zzc(zzqw zzqw2) throws zza {
            this.zzNB = zzqw2.getLayoutParams();
            ViewParent viewParent = zzqw2.getParent();
            this.zzqn = zzqw2.zzls();
            if (viewParent == null || !(viewParent instanceof ViewGroup)) {
                throw new zza("Could not get the parent of the WebView for an overlay.");
            }
            this.parent = (ViewGroup)viewParent;
            this.index = this.parent.indexOfChild(zzqw2.getView());
            this.parent.removeView(zzqw2.getView());
            zzqw2.zzK(true);
        }
    }

    @zzme
    private static final class zza
    extends Exception {
        public zza(String string2) {
            super(string2);
        }
    }
}

