/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.overlay;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.SurfaceTexture;
import android.opengl.GLES20;
import android.opengl.GLUtils;
import android.support.annotation.Nullable;
import android.util.Log;
import com.google.android.gms.ads.internal.overlay.zzx;
import com.google.android.gms.ads.internal.zzw;
import com.google.android.gms.internal.zzfz;
import com.google.android.gms.internal.zzgd;
import com.google.android.gms.internal.zzme;
import com.google.android.gms.internal.zzpk;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.util.concurrent.CountDownLatch;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLContext;
import javax.microedition.khronos.egl.EGLDisplay;
import javax.microedition.khronos.egl.EGLSurface;

@zzme
@TargetApi(value=14)
public class zzy
extends Thread
implements SurfaceTexture.OnFrameAvailableListener,
zzx.zza {
    private static final float[] zzOw = new float[]{-1.0f, -1.0f, -1.0f, 1.0f, -1.0f, -1.0f, -1.0f, 1.0f, -1.0f, 1.0f, 1.0f, -1.0f};
    private final zzx zzOx;
    private final float[] zzOt;
    private final float[] zzOy;
    private final float[] zzOz;
    private final float[] zzOA;
    private final float[] zzOB;
    private final float[] zzOC;
    private final float[] zzOD;
    private float zzOE;
    private float zzOF;
    private float zzOG;
    private int zzrD;
    private int zzrC;
    private SurfaceTexture zzOH;
    private SurfaceTexture zzOI;
    private int zzOJ;
    private int zzOK;
    private int zzOL;
    private FloatBuffer zzOM = ByteBuffer.allocateDirect(zzOw.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
    private final CountDownLatch zzON;
    private final Object zzOO;
    private EGL10 zzOP;
    private EGLDisplay zzOQ;
    private EGLContext zzOR;
    private EGLSurface zzOS;
    private volatile boolean zzOT;
    private volatile boolean zzOU;

    public zzy(Context context) {
        super("SphericalVideoProcessor");
        this.zzOM.put(zzOw).position(0);
        this.zzOt = new float[9];
        this.zzOy = new float[9];
        this.zzOz = new float[9];
        this.zzOA = new float[9];
        this.zzOB = new float[9];
        this.zzOC = new float[9];
        this.zzOD = new float[9];
        this.zzOE = Float.NaN;
        this.zzOx = new zzx(context);
        this.zzOx.zza(this);
        this.zzON = new CountDownLatch(1);
        this.zzOO = new Object();
    }

    public void zza(SurfaceTexture surfaceTexture, int n, int n2) {
        this.zzrC = n;
        this.zzrD = n2;
        this.zzOI = surfaceTexture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzj(int n, int n2) {
        Object object = this.zzOO;
        synchronized (object) {
            this.zzrC = n;
            this.zzrD = n2;
            this.zzOT = true;
            this.zzOO.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzil() {
        Object object = this.zzOO;
        synchronized (object) {
            this.zzOU = true;
            this.zzOI = null;
            this.zzOO.notifyAll();
        }
    }

    public SurfaceTexture zzim() {
        if (this.zzOI == null) {
            return null;
        }
        try {
            this.zzON.await();
        }
        catch (InterruptedException interruptedException) {}
        return this.zzOH;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onFrameAvailable(SurfaceTexture surfaceTexture) {
        ++this.zzOL;
        Object object = this.zzOO;
        synchronized (object) {
            this.zzOO.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzhJ() {
        Object object = this.zzOO;
        synchronized (object) {
            this.zzOO.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        boolean bl;
        if (this.zzOI == null) {
            zzpk.e((String)"SphericalVideoProcessor started with no output texture.");
            this.zzON.countDown();
            return;
        }
        boolean bl2 = this.zzir();
        int n = this.zzip();
        boolean bl3 = bl = this.zzOJ != 0;
        if (!bl2 || !bl) {
            String string2 = GLUtils.getEGLErrorString((int)this.zzOP.eglGetError());
            String string3 = String.valueOf(string2);
            String string4 = string3.length() != 0 ? "EGL initialization failed: ".concat(string3) : new String("EGL initialization failed: ");
            zzpk.e((String)string4);
            zzw.zzcQ().zza(new Throwable(string4), "SphericalVideoProcessor.run.1");
            this.zziv();
            this.zzON.countDown();
            return;
        }
        this.zzOH = new SurfaceTexture(n);
        this.zzOH.setOnFrameAvailableListener((SurfaceTexture.OnFrameAvailableListener)this);
        this.zzON.countDown();
        this.zzOx.start();
        try {
            this.zzOT = true;
            while (!this.zzOU) {
                this.zzin();
                if (this.zzOT) {
                    this.zzio();
                    this.zzOT = false;
                }
                try {
                    Object object = this.zzOO;
                    synchronized (object) {
                        if (!this.zzOU && !this.zzOT && this.zzOL == 0) {
                            this.zzOO.wait();
                        }
                    }
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }
        catch (IllegalStateException illegalStateException) {
            zzpk.zzbh((String)"SphericalVideoProcessor halted unexpectedly.");
        }
        catch (Throwable throwable) {
            zzpk.zzb((String)"SphericalVideoProcessor died.", (Throwable)throwable);
            zzw.zzcQ().zza(throwable, "SphericalVideoProcessor.run.2");
        }
        finally {
            this.zzOx.stop();
            this.zzOH.setOnFrameAvailableListener(null);
            this.zzOH = null;
            this.zziv();
        }
    }

    void zzin() {
        while (this.zzOL > 0) {
            this.zzOH.updateTexImage();
            --this.zzOL;
        }
        if (this.zzOx.zzb(this.zzOt)) {
            if (Float.isNaN(this.zzOE)) {
                this.zzOE = -this.zzc(this.zzOt);
            }
            this.zzb(this.zzOC, this.zzOE + this.zzOF);
        } else {
            this.zza(this.zzOt, -1.5707964f);
            this.zzb(this.zzOC, this.zzOF);
        }
        this.zza(this.zzOy, 1.5707964f);
        this.zza(this.zzOz, this.zzOC, this.zzOy);
        this.zza(this.zzOA, this.zzOt, this.zzOz);
        this.zza(this.zzOB, this.zzOG);
        this.zza(this.zzOD, this.zzOB, this.zzOA);
        GLES20.glUniformMatrix3fv((int)this.zzOK, (int)1, (boolean)false, (float[])this.zzOD, (int)0);
        GLES20.glDrawArrays((int)5, (int)0, (int)4);
        this.zzaD("drawArrays");
        GLES20.glFinish();
        this.zzOP.eglSwapBuffers(this.zzOQ, this.zzOS);
    }

    private float zzc(float[] fArray) {
        float[] fArray2 = this.zza(fArray, new float[]{0.0f, 1.0f, 0.0f});
        return (float)Math.atan2(fArray2[1], fArray2[0]) - 1.5707964f;
    }

    public void zzb(float f, float f2) {
        float f3;
        float f4;
        if (this.zzrC > this.zzrD) {
            f4 = 1.7453293f * f / (float)this.zzrC;
            f3 = 1.7453293f * f2 / (float)this.zzrC;
        } else {
            f4 = 1.7453293f * f / (float)this.zzrD;
            f3 = 1.7453293f * f2 / (float)this.zzrD;
        }
        this.zzOF -= f4;
        this.zzOG -= f3;
        if (this.zzOG < -1.5707964f) {
            this.zzOG = -1.5707964f;
        }
        if (this.zzOG > 1.5707964f) {
            this.zzOG = 1.5707964f;
        }
    }

    private void zzio() {
        GLES20.glViewport((int)0, (int)0, (int)this.zzrC, (int)this.zzrD);
        this.zzaD("viewport");
        int n = GLES20.glGetUniformLocation((int)this.zzOJ, (String)"uFOVx");
        int n2 = GLES20.glGetUniformLocation((int)this.zzOJ, (String)"uFOVy");
        if (this.zzrC > this.zzrD) {
            GLES20.glUniform1f((int)n, (float)0.87266463f);
            GLES20.glUniform1f((int)n2, (float)(0.87266463f * (float)this.zzrD / (float)this.zzrC));
        } else {
            GLES20.glUniform1f((int)n, (float)(0.87266463f * (float)this.zzrC / (float)this.zzrD));
            GLES20.glUniform1f((int)n2, (float)0.87266463f);
        }
    }

    private float[] zza(float[] fArray, float[] fArray2) {
        return new float[]{fArray[0] * fArray2[0] + fArray[1] * fArray2[1] + fArray[2] * fArray2[2], fArray[3] * fArray2[0] + fArray[4] * fArray2[1] + fArray[5] * fArray2[2], fArray[6] * fArray2[0] + fArray[7] * fArray2[1] + fArray[8] * fArray2[2]};
    }

    private void zza(float[] fArray, float[] fArray2, float[] fArray3) {
        fArray[0] = fArray2[0] * fArray3[0] + fArray2[1] * fArray3[3] + fArray2[2] * fArray3[6];
        fArray[1] = fArray2[0] * fArray3[1] + fArray2[1] * fArray3[4] + fArray2[2] * fArray3[7];
        fArray[2] = fArray2[0] * fArray3[2] + fArray2[1] * fArray3[5] + fArray2[2] * fArray3[8];
        fArray[3] = fArray2[3] * fArray3[0] + fArray2[4] * fArray3[3] + fArray2[5] * fArray3[6];
        fArray[4] = fArray2[3] * fArray3[1] + fArray2[4] * fArray3[4] + fArray2[5] * fArray3[7];
        fArray[5] = fArray2[3] * fArray3[2] + fArray2[4] * fArray3[5] + fArray2[5] * fArray3[8];
        fArray[6] = fArray2[6] * fArray3[0] + fArray2[7] * fArray3[3] + fArray2[8] * fArray3[6];
        fArray[7] = fArray2[6] * fArray3[1] + fArray2[7] * fArray3[4] + fArray2[8] * fArray3[7];
        fArray[8] = fArray2[6] * fArray3[2] + fArray2[7] * fArray3[5] + fArray2[8] * fArray3[8];
    }

    private void zza(float[] fArray, float f) {
        fArray[0] = 1.0f;
        fArray[1] = 0.0f;
        fArray[2] = 0.0f;
        fArray[3] = 0.0f;
        fArray[4] = (float)Math.cos(f);
        fArray[5] = (float)(-Math.sin(f));
        fArray[6] = 0.0f;
        fArray[7] = (float)Math.sin(f);
        fArray[8] = (float)Math.cos(f);
    }

    private void zzb(float[] fArray, float f) {
        fArray[0] = (float)Math.cos(f);
        fArray[1] = (float)(-Math.sin(f));
        fArray[2] = 0.0f;
        fArray[3] = (float)Math.sin(f);
        fArray[4] = (float)Math.cos(f);
        fArray[5] = 0.0f;
        fArray[6] = 0.0f;
        fArray[7] = 0.0f;
        fArray[8] = 1.0f;
    }

    int zzip() {
        this.zzOJ = this.zziq();
        GLES20.glUseProgram((int)this.zzOJ);
        this.zzaD("useProgram");
        int n = GLES20.glGetAttribLocation((int)this.zzOJ, (String)"aPosition");
        GLES20.glVertexAttribPointer((int)n, (int)3, (int)5126, (boolean)false, (int)12, (Buffer)this.zzOM);
        this.zzaD("vertexAttribPointer");
        GLES20.glEnableVertexAttribArray((int)n);
        this.zzaD("enableVertexAttribArray");
        int[] nArray = new int[1];
        GLES20.glGenTextures((int)1, (int[])nArray, (int)0);
        this.zzaD("genTextures");
        int n2 = nArray[0];
        GLES20.glBindTexture((int)36197, (int)n2);
        this.zzaD("bindTextures");
        GLES20.glTexParameteri((int)36197, (int)10240, (int)9729);
        this.zzaD("texParameteri");
        GLES20.glTexParameteri((int)36197, (int)10241, (int)9729);
        this.zzaD("texParameteri");
        GLES20.glTexParameteri((int)36197, (int)10242, (int)33071);
        this.zzaD("texParameteri");
        GLES20.glTexParameteri((int)36197, (int)10243, (int)33071);
        this.zzaD("texParameteri");
        this.zzOK = GLES20.glGetUniformLocation((int)this.zzOJ, (String)"uVMat");
        float[] fArray = new float[]{1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f};
        GLES20.glUniformMatrix3fv((int)this.zzOK, (int)1, (boolean)false, (float[])fArray, (int)0);
        return n2;
    }

    private int zziq() {
        int n = this.zzc(35633, this.zzit());
        if (n == 0) {
            return 0;
        }
        int n2 = this.zzc(35632, this.zziu());
        if (n2 == 0) {
            return 0;
        }
        int n3 = GLES20.glCreateProgram();
        this.zzaD("createProgram");
        if (n3 != 0) {
            GLES20.glAttachShader((int)n3, (int)n);
            this.zzaD("attachShader");
            GLES20.glAttachShader((int)n3, (int)n2);
            this.zzaD("attachShader");
            GLES20.glLinkProgram((int)n3);
            this.zzaD("linkProgram");
            int[] nArray = new int[1];
            GLES20.glGetProgramiv((int)n3, (int)35714, (int[])nArray, (int)0);
            this.zzaD("getProgramiv");
            if (nArray[0] != 1) {
                Log.e((String)"SphericalVideoRenderer", (String)"Could not link program: ");
                Log.e((String)"SphericalVideoRenderer", (String)GLES20.glGetProgramInfoLog((int)n3));
                GLES20.glDeleteProgram((int)n3);
                this.zzaD("deleteProgram");
                n3 = 0;
            } else {
                GLES20.glValidateProgram((int)n3);
                this.zzaD("validateProgram");
            }
        }
        return n3;
    }

    private int zzc(int n, String string2) {
        int n2 = GLES20.glCreateShader((int)n);
        this.zzaD("createShader");
        if (n2 != 0) {
            GLES20.glShaderSource((int)n2, (String)string2);
            this.zzaD("shaderSource");
            GLES20.glCompileShader((int)n2);
            this.zzaD("compileShader");
            int[] nArray = new int[1];
            GLES20.glGetShaderiv((int)n2, (int)35713, (int[])nArray, (int)0);
            this.zzaD("getShaderiv");
            if (nArray[0] == 0) {
                Log.e((String)"SphericalVideoRenderer", (String)new StringBuilder(37).append("Could not compile shader ").append(n).append(":").toString());
                Log.e((String)"SphericalVideoRenderer", (String)GLES20.glGetShaderInfoLog((int)n2));
                GLES20.glDeleteShader((int)n2);
                this.zzaD("deleteShader");
                n2 = 0;
            }
        }
        return n2;
    }

    boolean zzir() {
        this.zzOP = (EGL10)EGLContext.getEGL();
        this.zzOQ = this.zzOP.eglGetDisplay(EGL10.EGL_DEFAULT_DISPLAY);
        if (this.zzOQ == EGL10.EGL_NO_DISPLAY) {
            return false;
        }
        int[] nArray = new int[2];
        if (!this.zzOP.eglInitialize(this.zzOQ, nArray)) {
            return false;
        }
        EGLConfig eGLConfig = this.zzis();
        if (eGLConfig == null) {
            return false;
        }
        int[] nArray2 = new int[]{12440, 2, 12344};
        this.zzOR = this.zzOP.eglCreateContext(this.zzOQ, eGLConfig, EGL10.EGL_NO_CONTEXT, nArray2);
        if (this.zzOR == null || this.zzOR == EGL10.EGL_NO_CONTEXT) {
            return false;
        }
        this.zzOS = this.zzOP.eglCreateWindowSurface(this.zzOQ, eGLConfig, (Object)this.zzOI, null);
        if (this.zzOS == null || this.zzOS == EGL10.EGL_NO_SURFACE) {
            return false;
        }
        return this.zzOP.eglMakeCurrent(this.zzOQ, this.zzOS, this.zzOS, this.zzOR);
    }

    @Nullable
    private EGLConfig zzis() {
        int[] nArray = new int[1];
        EGLConfig[] eGLConfigArray = new EGLConfig[1];
        int[] nArray2 = new int[]{12352, 4, 12324, 8, 12323, 8, 12322, 8, 12325, 16, 12344};
        if (!this.zzOP.eglChooseConfig(this.zzOQ, nArray2, eGLConfigArray, 1, nArray)) {
            return null;
        }
        if (nArray[0] > 0) {
            return eGLConfigArray[0];
        }
        return null;
    }

    private String zzit() {
        zzfz<String> zzfz2 = zzgd.zzDo;
        if (!zzfz2.get().equals(zzfz2.zzfr())) {
            return zzfz2.get();
        }
        return "attribute highp vec3 aPosition;varying vec3 pos;void main() {  gl_Position = vec4(aPosition, 1.0);  pos = aPosition;}";
    }

    private String zziu() {
        zzfz<String> zzfz2 = zzgd.zzDp;
        if (!zzfz2.get().equals(zzfz2.zzfr())) {
            return zzfz2.get();
        }
        return "#extension GL_OES_EGL_image_external : require\n#define INV_PI 0.3183\nprecision highp float;varying vec3 pos;uniform samplerExternalOES uSplr;uniform mat3 uVMat;uniform float uFOVx;uniform float uFOVy;void main() {  vec3 ray = vec3(pos.x * tan(uFOVx), pos.y * tan(uFOVy), -1);  ray = (uVMat * ray).xyz;  ray = normalize(ray);  vec2 texCrd = vec2(    0.5 + atan(ray.x, - ray.z) * INV_PI * 0.5, acos(ray.y) * INV_PI);  gl_FragColor = vec4(texture2D(uSplr, texCrd).xyz, 1.0);}";
    }

    boolean zziv() {
        boolean bl = false;
        if (this.zzOS != null && this.zzOS != EGL10.EGL_NO_SURFACE) {
            bl = false | this.zzOP.eglMakeCurrent(this.zzOQ, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_CONTEXT);
            bl |= this.zzOP.eglDestroySurface(this.zzOQ, this.zzOS);
            this.zzOS = null;
        }
        if (this.zzOR != null) {
            bl |= this.zzOP.eglDestroyContext(this.zzOQ, this.zzOR);
            this.zzOR = null;
        }
        if (this.zzOQ != null) {
            bl |= this.zzOP.eglTerminate(this.zzOQ);
            this.zzOQ = null;
        }
        return bl;
    }

    private void zzaD(String string2) {
        int n = GLES20.glGetError();
        if (n != 0) {
            Log.e((String)"SphericalVideoRenderer", (String)new StringBuilder(21 + String.valueOf(string2).length()).append(string2).append(": glError ").append(n).toString());
        }
    }
}

