/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.purchase;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.SystemClock;
import com.google.android.gms.ads.internal.purchase.zzb;
import com.google.android.gms.ads.internal.purchase.zzf;
import com.google.android.gms.ads.internal.purchase.zzg;
import com.google.android.gms.ads.internal.purchase.zzh;
import com.google.android.gms.ads.internal.purchase.zzk;
import com.google.android.gms.ads.internal.zzw;
import com.google.android.gms.common.stats.zza;
import com.google.android.gms.internal.zzlh;
import com.google.android.gms.internal.zzli;
import com.google.android.gms.internal.zzme;
import com.google.android.gms.internal.zzpj;
import com.google.android.gms.internal.zzpk;
import com.google.android.gms.internal.zzpo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

@zzme
public class zzc
extends zzpj
implements ServiceConnection {
    private final Object zzrJ = new Object();
    private boolean zzPs = false;
    private Context mContext;
    private zzli zzJv;
    private zzb zzPt;
    private zzh zzPu;
    private List<zzf> zzPv = null;
    private zzk zzPw;

    public zzc(Context context, zzli zzli2, zzk zzk2) {
        this(context, zzli2, zzk2, new zzb(context), zzh.zzu(context.getApplicationContext()));
    }

    zzc(Context context, zzli zzli2, zzk zzk2, zzb zzb2, zzh zzh2) {
        this.mContext = context;
        this.zzJv = zzli2;
        this.zzPw = zzk2;
        this.zzPt = zzb2;
        this.zzPu = zzh2;
        this.zzPv = this.zzPu.zzg(10L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzco() {
        Object object = this.zzrJ;
        synchronized (object) {
            Intent intent = new Intent("com.android.vending.billing.InAppBillingService.BIND");
            intent.setPackage("com.android.vending");
            zza.zzyJ().zza(this.mContext, intent, (ServiceConnection)this, 1);
            this.zze(SystemClock.elapsedRealtime());
            zza.zzyJ().zza(this.mContext, (ServiceConnection)this);
            this.zzPt.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onStop() {
        Object object = this.zzrJ;
        synchronized (object) {
            zza.zzyJ().zza(this.mContext, (ServiceConnection)this);
            this.zzPt.destroy();
        }
    }

    public void onServiceDisconnected(ComponentName componentName) {
        zzpk.zzbg((String)"In-app billing service disconnected.");
        this.zzPt.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
        Object object = this.zzrJ;
        synchronized (object) {
            this.zzPt.zzV(iBinder);
            this.zziI();
            this.zzPs = true;
            this.zzrJ.notify();
        }
    }

    protected void zziI() {
        int n;
        Bundle bundle;
        if (this.zzPv.isEmpty()) {
            return;
        }
        HashMap<String, zzf> hashMap = new HashMap<String, zzf>();
        for (zzf object2 : this.zzPv) {
            hashMap.put(object2.zzPI, object2);
        }
        Object object3 = null;
        while ((bundle = this.zzPt.zzn(this.mContext.getPackageName(), (String)object3)) != null && (n = zzw.zzda().zzd(bundle)) == 0) {
            ArrayList arrayList = bundle.getStringArrayList("INAPP_PURCHASE_ITEM_LIST");
            ArrayList arrayList2 = bundle.getStringArrayList("INAPP_PURCHASE_DATA_LIST");
            ArrayList arrayList3 = bundle.getStringArrayList("INAPP_DATA_SIGNATURE_LIST");
            object3 = bundle.getString("INAPP_CONTINUATION_TOKEN");
            for (int i = 0; i < arrayList.size(); ++i) {
                if (!hashMap.containsKey(arrayList.get(i))) continue;
                String string2 = (String)arrayList.get(i);
                String string3 = (String)arrayList2.get(i);
                String string4 = (String)arrayList3.get(i);
                zzf zzf2 = (zzf)hashMap.get(string2);
                String string5 = zzw.zzda().zzaE(string3);
                if (!zzf2.zzPH.equals(string5)) continue;
                this.zza(zzf2, string3, string4);
                hashMap.remove(string2);
            }
            if (object3 != null && !hashMap.isEmpty()) continue;
        }
        for (String string6 : hashMap.keySet()) {
            this.zzPu.zza((zzf)hashMap.get(string6));
        }
    }

    protected void zza(final zzf zzf2, String string2, String string3) {
        final Intent intent = new Intent();
        zzw.zzda();
        intent.putExtra("RESPONSE_CODE", 0);
        zzw.zzda();
        intent.putExtra("INAPP_PURCHASE_DATA", string2);
        zzw.zzda();
        intent.putExtra("INAPP_DATA_SIGNATURE", string3);
        zzpo.zzXC.post(new Runnable(){

            @Override
            public void run() {
                try {
                    if (zzc.this.zzPw.zza(zzf2.zzPH, -1, intent)) {
                        zzc.this.zzJv.zza((zzlh)new zzg(zzc.this.mContext, zzf2.zzPI, true, -1, intent, zzf2));
                    } else {
                        zzc.this.zzJv.zza((zzlh)new zzg(zzc.this.mContext, zzf2.zzPI, false, -1, intent, zzf2));
                    }
                }
                catch (RemoteException remoteException) {
                    zzpk.zzbh((String)"Fail to verify and dispatch pending transaction");
                }
            }
        });
    }

    private void zze(long l) {
        do {
            if (this.zzf(l)) continue;
            zzpk.v("Timeout waiting for pending transaction to be processed.");
        } while (!this.zzPs);
    }

    private boolean zzf(long l) {
        long l2 = 60000L - (SystemClock.elapsedRealtime() - l);
        if (l2 <= 0L) {
            return false;
        }
        try {
            this.zzrJ.wait(l2);
        }
        catch (InterruptedException interruptedException) {
            zzpk.zzbh((String)"waitWithTimeout_lock interrupted");
        }
        return true;
    }
}

